/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import java.io.IOException;
import java.io.Reader;
import java.lang.invoke.MethodHandles;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.DocumentStoredFieldVisitor;
import org.apache.lucene.document.LazyDocument;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.ReaderUtil;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.index.StoredFieldVisitor;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.NumericUtils;
import org.apache.solr.common.SolrDocumentBase;
import org.apache.solr.core.SolrConfig;
import org.apache.solr.schema.AbstractEnumField;
import org.apache.solr.schema.BoolField;
import org.apache.solr.schema.LatLonPointSpatialField;
import org.apache.solr.schema.NumberType;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.schema.StrField;
import org.apache.solr.schema.TextField;
import org.apache.solr.search.SolrCache;
import org.apache.solr.search.SolrIndexSearcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolrDocumentFetcher {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final SolrIndexSearcher searcher;
    private final boolean enableLazyFieldLoading;
    private final SolrCache<Integer, Document> documentCache;
    private final Set<String> allStored;
    private final Set<String> dvsCanSubstituteStored;
    private final Set<String> allNonStoredDVs;
    private final Set<String> nonStoredDVsUsedAsStored;
    private final Set<String> nonStoredDVsWithoutCopyTargets;
    private static int largeValueLengthCacheThreshold = Integer.getInteger("solr.largeField.cacheThreshold", 524288);
    private final Set<String> largeFields;
    private Collection<String> storedHighlightFieldNames;

    SolrDocumentFetcher(SolrIndexSearcher searcher, SolrConfig solrConfig, boolean cachingEnabled) {
        this.searcher = searcher;
        this.enableLazyFieldLoading = solrConfig.enableLazyFieldLoading;
        this.documentCache = cachingEnabled ? (solrConfig.documentCacheConfig == null ? null : solrConfig.documentCacheConfig.newInstance()) : null;
        HashSet<String> nonStoredDVsUsedAsStored = new HashSet<String>();
        HashSet<String> allNonStoredDVs = new HashSet<String>();
        HashSet<String> nonStoredDVsWithoutCopyTargets = new HashSet<String>();
        HashSet<String> storedLargeFields = new HashSet<String>();
        HashSet<String> dvsCanSubstituteStored = new HashSet<String>();
        HashSet<String> allStoreds = new HashSet<String>();
        for (FieldInfo fieldInfo : searcher.getFieldInfos()) {
            SchemaField schemaField = searcher.getSchema().getFieldOrNull(fieldInfo.name);
            if (schemaField == null) continue;
            if (this.canSubstituteDvForStored(fieldInfo, schemaField)) {
                dvsCanSubstituteStored.add(fieldInfo.name);
            }
            if (schemaField.stored()) {
                allStoreds.add(fieldInfo.name);
            }
            if (!schemaField.stored() && schemaField.hasDocValues()) {
                if (schemaField.useDocValuesAsStored()) {
                    nonStoredDVsUsedAsStored.add(fieldInfo.name);
                }
                allNonStoredDVs.add(fieldInfo.name);
                if (!searcher.getSchema().isCopyFieldTarget(schemaField)) {
                    nonStoredDVsWithoutCopyTargets.add(fieldInfo.name);
                }
            }
            if (!schemaField.stored() || !schemaField.isLarge()) continue;
            storedLargeFields.add(schemaField.getName());
        }
        this.nonStoredDVsUsedAsStored = Collections.unmodifiableSet(nonStoredDVsUsedAsStored);
        this.allNonStoredDVs = Collections.unmodifiableSet(allNonStoredDVs);
        this.nonStoredDVsWithoutCopyTargets = Collections.unmodifiableSet(nonStoredDVsWithoutCopyTargets);
        this.largeFields = Collections.unmodifiableSet(storedLargeFields);
        this.dvsCanSubstituteStored = Collections.unmodifiableSet(dvsCanSubstituteStored);
        this.allStored = Collections.unmodifiableSet(allStoreds);
    }

    private boolean canSubstituteDvForStored(FieldInfo fieldInfo, SchemaField schemaField) {
        if (!schemaField.hasDocValues() || !schemaField.stored()) {
            return false;
        }
        if (schemaField.multiValued()) {
            return false;
        }
        DocValuesType docValuesType = fieldInfo.getDocValuesType();
        NumberType numberType = schemaField.getType().getNumberType();
        return numberType != null || docValuesType != DocValuesType.SORTED_NUMERIC && docValuesType != DocValuesType.NUMERIC;
    }

    public boolean isLazyFieldLoadingEnabled() {
        return this.enableLazyFieldLoading;
    }

    public SolrCache<Integer, Document> getDocumentCache() {
        return this.documentCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<String> getStoredHighlightFieldNames() {
        SolrDocumentFetcher solrDocumentFetcher = this;
        synchronized (solrDocumentFetcher) {
            if (this.storedHighlightFieldNames == null) {
                this.storedHighlightFieldNames = new LinkedList<String>();
                for (FieldInfo fieldInfo : this.searcher.getFieldInfos()) {
                    String fieldName = fieldInfo.name;
                    try {
                        SchemaField field = this.searcher.getSchema().getField(fieldName);
                        if (!field.stored() || !(field.getType() instanceof TextField) && !(field.getType() instanceof StrField)) continue;
                        this.storedHighlightFieldNames.add(fieldName);
                    }
                    catch (RuntimeException e) {
                        log.warn("Field [{}] found in index, but not defined in schema.", (Object)fieldName);
                    }
                }
            }
            return this.storedHighlightFieldNames;
        }
    }

    public Document doc(int docId) throws IOException {
        return this.doc(docId, (Set<String>)null);
    }

    public Document doc(int i, Set<String> fields) throws IOException {
        Document d;
        if (this.documentCache != null && (d = this.documentCache.get(i)) != null) {
            return d;
        }
        DirectoryReader reader = this.searcher.getIndexReader();
        if (this.documentCache != null && !this.enableLazyFieldLoading) {
            fields = null;
        }
        SolrDocumentStoredFieldVisitor visitor = new SolrDocumentStoredFieldVisitor(fields, (IndexReader)reader, i);
        reader.document(i, (StoredFieldVisitor)visitor);
        d = visitor.getDocument();
        if (this.documentCache != null) {
            this.documentCache.put(i, d);
        }
        return d;
    }

    public void doc(int docId, StoredFieldVisitor visitor) throws IOException {
        Document cached;
        if (this.documentCache != null && (cached = this.documentCache.get(docId)) != null) {
            this.visitFromCached(cached, visitor);
            return;
        }
        this.searcher.getIndexReader().document(docId, visitor);
    }

    private void visitFromCached(Document document, StoredFieldVisitor visitor) throws IOException {
        for (IndexableField f : document) {
            FieldInfo info = this.searcher.getFieldInfos().fieldInfo(f.name());
            StoredFieldVisitor.Status needsField = visitor.needsField(info);
            if (needsField == StoredFieldVisitor.Status.STOP) {
                return;
            }
            if (needsField == StoredFieldVisitor.Status.NO) continue;
            BytesRef binaryValue = f.binaryValue();
            if (binaryValue != null) {
                visitor.binaryField(info, this.toByteArrayUnwrapIfPossible(binaryValue));
                continue;
            }
            Number numericValue = f.numericValue();
            if (numericValue != null) {
                if (numericValue instanceof Double) {
                    visitor.doubleField(info, numericValue.doubleValue());
                    continue;
                }
                if (numericValue instanceof Integer) {
                    visitor.intField(info, numericValue.intValue());
                    continue;
                }
                if (numericValue instanceof Float) {
                    visitor.floatField(info, numericValue.floatValue());
                    continue;
                }
                if (numericValue instanceof Long) {
                    visitor.longField(info, numericValue.longValue());
                    continue;
                }
                throw new AssertionError();
            }
            if (f instanceof LargeLazyField) {
                visitor.stringField(info, this.toByteArrayUnwrapIfPossible(((LargeLazyField)f).readBytes()));
                continue;
            }
            visitor.stringField(info, f.stringValue().getBytes(StandardCharsets.UTF_8));
        }
    }

    private byte[] toByteArrayUnwrapIfPossible(BytesRef bytesRef) {
        if (bytesRef.offset == 0 && bytesRef.bytes.length == bytesRef.length) {
            return bytesRef.bytes;
        }
        return Arrays.copyOfRange(bytesRef.bytes, bytesRef.offset, bytesRef.offset + bytesRef.length);
    }

    public void decorateDocValueFields(SolrDocumentBase doc, int docid, Set<String> fields) throws IOException {
        List<LeafReaderContext> leafContexts = this.searcher.getLeafContexts();
        int subIndex = ReaderUtil.subIndex((int)docid, leafContexts);
        int localId = docid - leafContexts.get((int)subIndex).docBase;
        LeafReader leafReader = leafContexts.get(subIndex).reader();
        for (String fieldName : fields) {
            Object fieldValue = this.decodeDVField(localId, leafReader, fieldName);
            if (fieldValue == null) continue;
            doc.setField(fieldName, fieldValue);
        }
    }

    private Object decodeDVField(int localId, LeafReader leafReader, String fieldName) throws IOException {
        SchemaField schemaField = this.searcher.getSchema().getFieldOrNull(fieldName);
        FieldInfo fi = this.searcher.getFieldInfos().fieldInfo(fieldName);
        if (schemaField == null || !schemaField.hasDocValues() || fi == null) {
            return null;
        }
        DocValuesType dvType = fi.getDocValuesType();
        switch (dvType) {
            case NUMERIC: {
                NumericDocValues ndv = leafReader.getNumericDocValues(fieldName);
                if (ndv == null) {
                    return null;
                }
                if (!ndv.advanceExact(localId)) {
                    return null;
                }
                Long val = ndv.longValue();
                return this.decodeNumberFromDV(schemaField, val, false);
            }
            case BINARY: {
                BinaryDocValues bdv = leafReader.getBinaryDocValues(fieldName);
                if (bdv != null && bdv.advanceExact(localId)) {
                    return BytesRef.deepCopyOf((BytesRef)bdv.binaryValue());
                }
                return null;
            }
            case SORTED: {
                SortedDocValues sdv = leafReader.getSortedDocValues(fieldName);
                if (sdv != null && sdv.advanceExact(localId)) {
                    BytesRef bRef = sdv.binaryValue();
                    if (schemaField.getType() instanceof BoolField) {
                        return schemaField.getType().toObject(schemaField, bRef);
                    }
                    return bRef.utf8ToString();
                }
                return null;
            }
            case SORTED_NUMERIC: {
                SortedNumericDocValues numericDv = leafReader.getSortedNumericDocValues(fieldName);
                if (numericDv != null && numericDv.advance(localId) == localId) {
                    ArrayList<Object> outValues = new ArrayList<Object>(numericDv.docValueCount());
                    for (int i = 0; i < numericDv.docValueCount(); ++i) {
                        long number = numericDv.nextValue();
                        Object value = this.decodeNumberFromDV(schemaField, number, true);
                        if (value == null) {
                            return null;
                        }
                        if (!schemaField.multiValued()) {
                            return value;
                        }
                        outValues.add(value);
                    }
                    assert (outValues.size() > 0);
                    return outValues;
                }
                return null;
            }
            case SORTED_SET: {
                SortedSetDocValues values = leafReader.getSortedSetDocValues(fieldName);
                if (values != null && values.getValueCount() > 0L && values.advance(localId) == localId) {
                    LinkedList<Object> outValues = new LinkedList<Object>();
                    long ord = values.nextOrd();
                    while (ord != -1L) {
                        BytesRef value = values.lookupOrd(ord);
                        outValues.add(schemaField.getType().toObject(schemaField, value));
                        ord = values.nextOrd();
                    }
                    assert (outValues.size() > 0);
                    return outValues;
                }
                return null;
            }
        }
        return null;
    }

    private Object decodeNumberFromDV(SchemaField schemaField, long value, boolean sortableNumeric) {
        if (schemaField.getType() instanceof LatLonPointSpatialField) {
            return LatLonPointSpatialField.decodeDocValueToString(value);
        }
        if (schemaField.getType().getNumberType() == null) {
            log.warn("Couldn't decode docValues for field: [{}], schemaField: [{}], numberType is unknown", (Object)schemaField.getName(), (Object)schemaField);
            return null;
        }
        switch (schemaField.getType().getNumberType()) {
            case INTEGER: {
                int raw = (int)value;
                if (schemaField.getType() instanceof AbstractEnumField) {
                    return ((AbstractEnumField)schemaField.getType()).getEnumMapping().intValueToStringValue(raw);
                }
                return raw;
            }
            case LONG: {
                return value;
            }
            case FLOAT: {
                if (sortableNumeric) {
                    return Float.valueOf(NumericUtils.sortableIntToFloat((int)((int)value)));
                }
                return Float.valueOf(Float.intBitsToFloat((int)value));
            }
            case DOUBLE: {
                if (sortableNumeric) {
                    return NumericUtils.sortableLongToDouble((long)value);
                }
                return Double.longBitsToDouble(value);
            }
            case DATE: {
                return new Date(value);
            }
        }
        throw new AssertionError();
    }

    public Set<String> getDvsCanSubstituteStored() {
        return this.dvsCanSubstituteStored;
    }

    public Set<String> getAllStored() {
        return this.allStored;
    }

    public Set<String> getNonStoredDVs(boolean onlyUseDocValuesAsStored) {
        return onlyUseDocValuesAsStored ? this.nonStoredDVsUsedAsStored : this.allNonStoredDVs;
    }

    public Set<String> getNonStoredDVsWithoutCopyTargets() {
        return this.nonStoredDVsWithoutCopyTargets;
    }

    class LargeLazyField
    implements IndexableField {
        final String name;
        final int docId;
        BytesRef cachedBytes;

        private LargeLazyField(String name, int docId) {
            this.name = name;
            this.docId = docId;
        }

        public String toString() {
            return this.fieldType().toString() + "<" + this.name() + ">";
        }

        public String name() {
            return this.name;
        }

        public IndexableFieldType fieldType() {
            return SolrDocumentFetcher.this.searcher.getSchema().getField(this.name());
        }

        public TokenStream tokenStream(Analyzer analyzer, TokenStream reuse) {
            return analyzer.tokenStream(this.name(), this.stringValue());
        }

        synchronized boolean hasBeenLoaded() {
            return this.cachedBytes != null;
        }

        public synchronized String stringValue() {
            try {
                return this.readBytes().utf8ToString();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        synchronized BytesRef readBytes() throws IOException {
            if (this.cachedBytes != null) {
                return this.cachedBytes;
            }
            final BytesRef bytesRef = new BytesRef();
            SolrDocumentFetcher.this.searcher.getIndexReader().document(this.docId, new StoredFieldVisitor(){
                boolean done = false;

                public StoredFieldVisitor.Status needsField(FieldInfo fieldInfo) throws IOException {
                    if (this.done) {
                        return StoredFieldVisitor.Status.STOP;
                    }
                    return fieldInfo.name.equals(LargeLazyField.this.name()) ? StoredFieldVisitor.Status.YES : StoredFieldVisitor.Status.NO;
                }

                public void stringField(FieldInfo fieldInfo, byte[] value) throws IOException {
                    bytesRef.bytes = value;
                    bytesRef.length = value.length;
                    this.done = true;
                }

                public void binaryField(FieldInfo fieldInfo, byte[] value) throws IOException {
                    throw new UnsupportedOperationException("'large' binary fields are not (yet) supported");
                }
            });
            if (bytesRef.length < largeValueLengthCacheThreshold) {
                this.cachedBytes = bytesRef;
                return this.cachedBytes;
            }
            return bytesRef;
        }

        public BytesRef binaryValue() {
            return null;
        }

        public Reader readerValue() {
            return null;
        }

        public Number numericValue() {
            return null;
        }
    }

    private class SolrDocumentStoredFieldVisitor
    extends DocumentStoredFieldVisitor {
        private final Document doc;
        private final LazyDocument lazyFieldProducer;
        private final int docId;
        private final boolean addLargeFieldsLazily;

        SolrDocumentStoredFieldVisitor(Set<String> toLoad, IndexReader reader, int docId) {
            super(toLoad);
            this.docId = docId;
            this.doc = this.getDocument();
            this.lazyFieldProducer = toLoad != null && SolrDocumentFetcher.this.enableLazyFieldLoading ? new LazyDocument(reader, docId) : null;
            this.addLargeFieldsLazily = SolrDocumentFetcher.this.documentCache != null && !SolrDocumentFetcher.this.largeFields.isEmpty();
        }

        public StoredFieldVisitor.Status needsField(FieldInfo fieldInfo) throws IOException {
            StoredFieldVisitor.Status status = super.needsField(fieldInfo);
            assert (status != StoredFieldVisitor.Status.STOP) : "Status.STOP not supported or expected";
            if (this.addLargeFieldsLazily && SolrDocumentFetcher.this.largeFields.contains(fieldInfo.name)) {
                if (this.lazyFieldProducer != null || status == StoredFieldVisitor.Status.YES) {
                    this.doc.add((IndexableField)new LargeLazyField(fieldInfo.name, this.docId));
                }
                return StoredFieldVisitor.Status.NO;
            }
            if (status == StoredFieldVisitor.Status.NO && this.lazyFieldProducer != null) {
                this.doc.add(this.lazyFieldProducer.getField(fieldInfo));
            }
            return status;
        }
    }
}

