/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.index;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.codecs.DocValuesProducer;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.CodecReader;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.FilterCodecReader;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.OneMergeWrappingMergePolicy;
import org.apache.lucene.index.SegmentCommitInfo;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.index.MergePolicyFactoryArgs;
import org.apache.solr.index.WrapperMergePolicyFactory;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.uninverting.UninvertingReader;

public class UninvertDocValuesMergePolicyFactory
extends WrapperMergePolicyFactory {
    private final boolean skipIntegrityCheck;

    public boolean getSkipIntegrityCheck() {
        return this.skipIntegrityCheck;
    }

    public UninvertDocValuesMergePolicyFactory(SolrResourceLoader resourceLoader, MergePolicyFactoryArgs args, IndexSchema schema) {
        super(resourceLoader, args, schema);
        Boolean sic = (Boolean)args.remove("skipIntegrityCheck");
        this.skipIntegrityCheck = sic != null ? sic : false;
        if (!args.keys().isEmpty()) {
            throw new IllegalArgumentException("Arguments were " + args + " but " + this.getClass().getSimpleName() + " takes no arguments.");
        }
    }

    @Override
    protected MergePolicy getMergePolicyInstance(MergePolicy wrappedMP) {
        return new OneMergeWrappingMergePolicy(wrappedMP, merge -> new UninvertDocValuesOneMerge(merge.segments));
    }

    private UninvertingReader.Type getUninversionType(FieldInfo fi) {
        SchemaField sf = this.schema.getFieldOrNull(fi.name);
        if (null != sf && sf.hasDocValues() && fi.getDocValuesType() == DocValuesType.NONE && fi.getIndexOptions() != IndexOptions.NONE) {
            return sf.getType().getUninversionType(sf);
        }
        return null;
    }

    private class UninvertingFilterCodecReader
    extends FilterCodecReader {
        private final UninvertingReader uninvertingReader;
        private final DocValuesProducer docValuesProducer;

        public UninvertingFilterCodecReader(CodecReader in, Map<String, UninvertingReader.Type> uninversionMap) {
            super(in);
            this.uninvertingReader = new UninvertingReader((LeafReader)in, uninversionMap);
            this.docValuesProducer = new DocValuesProducer(){

                public NumericDocValues getNumeric(FieldInfo field) throws IOException {
                    return UninvertingFilterCodecReader.this.uninvertingReader.getNumericDocValues(field.name);
                }

                public BinaryDocValues getBinary(FieldInfo field) throws IOException {
                    return UninvertingFilterCodecReader.this.uninvertingReader.getBinaryDocValues(field.name);
                }

                public SortedDocValues getSorted(FieldInfo field) throws IOException {
                    return UninvertingFilterCodecReader.this.uninvertingReader.getSortedDocValues(field.name);
                }

                public SortedNumericDocValues getSortedNumeric(FieldInfo field) throws IOException {
                    return UninvertingFilterCodecReader.this.uninvertingReader.getSortedNumericDocValues(field.name);
                }

                public SortedSetDocValues getSortedSet(FieldInfo field) throws IOException {
                    return UninvertingFilterCodecReader.this.uninvertingReader.getSortedSetDocValues(field.name);
                }

                public void checkIntegrity() throws IOException {
                    if (!UninvertDocValuesMergePolicyFactory.this.skipIntegrityCheck) {
                        UninvertingFilterCodecReader.this.uninvertingReader.checkIntegrity();
                    }
                }

                public void close() throws IOException {
                }

                public long ramBytesUsed() {
                    return 0L;
                }
            };
        }

        protected void doClose() throws IOException {
            this.docValuesProducer.close();
            this.uninvertingReader.close();
            super.doClose();
        }

        public DocValuesProducer getDocValuesReader() {
            return this.docValuesProducer;
        }

        public FieldInfos getFieldInfos() {
            return this.uninvertingReader.getFieldInfos();
        }

        public IndexReader.CacheHelper getCoreCacheHelper() {
            return this.in.getCoreCacheHelper();
        }

        public IndexReader.CacheHelper getReaderCacheHelper() {
            return this.in.getReaderCacheHelper();
        }
    }

    private class UninvertDocValuesOneMerge
    extends MergePolicy.OneMerge {
        public UninvertDocValuesOneMerge(List<SegmentCommitInfo> segments) {
            super(segments);
        }

        public CodecReader wrapForMerge(CodecReader reader) throws IOException {
            HashMap<String, UninvertingReader.Type> uninversionMap = null;
            for (FieldInfo fi : reader.getFieldInfos()) {
                UninvertingReader.Type type = UninvertDocValuesMergePolicyFactory.this.getUninversionType(fi);
                if (type == null) continue;
                if (uninversionMap == null) {
                    uninversionMap = new HashMap<String, UninvertingReader.Type>();
                }
                uninversionMap.put(fi.name, type);
            }
            if (uninversionMap == null) {
                return reader;
            }
            return new UninvertingFilterCodecReader(reader, uninversionMap);
        }
    }
}

