/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin;

import java.lang.invoke.MethodHandles;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.SolrInfoBean;
import org.apache.solr.handler.RequestHandlerBase;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.security.AuthorizationContext;
import org.apache.solr.security.PermissionNameProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoscalingHistoryHandler
extends RequestHandlerBase
implements PermissionNameProvider {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String SYSTEM_COLLECTION_PARAM = "systemCollection";
    public static final String ACTION_PARAM = "action";
    public static final String MESSAGE_PARAM = "message";
    public static final String TRIGGER_PARAM = "trigger";
    public static final String TYPE_PARAM = "eventType";
    public static final String NODE_PARAM = "node";
    public static final String COLLECTION_PARAM = "collection";
    public static final String STAGE_PARAM = "stage";
    public static final String BEFORE_ACTION_PARAM = "beforeAction";
    public static final String AFTER_ACTION_PARAM = "afterAction";
    private static final String EVENTS_FQ = "{!term f=type}autoscaling_event";
    private static final String ACTION_FQ_FORMAT = "{!term f=action_s}%s";
    private static final String MESSAGE_FQ_FORMAT = "{!lucene}message_t:%s";
    private static final String TRIGGER_FQ_FORMAT = "{!term f=event.source_s}%s";
    private static final String STAGE_FQ_FORMAT = "{!term f=stage_s}%s";
    private static final String COLLECTION_FQ_FORMAT = "{!term f=collections_ss}%s";
    private static final String TYPE_FQ_FORMAT = "{!term f=event.type_s}%s";
    private static final String NODE_FQ_FORMAT = "{!term f=event.property.nodeNames_ss}%s";
    private static final String BEFORE_ACTION_FQ_FORMAT = "{!term f=before.actions_ss}%s";
    private static final String AFTER_ACTION_FQ_FORMAT = "{!term f=after.actions_ss}%s";
    private static final Map<String, String> formats = new HashMap<String, String>(){
        {
            this.put(AutoscalingHistoryHandler.ACTION_PARAM, AutoscalingHistoryHandler.ACTION_FQ_FORMAT);
            this.put(AutoscalingHistoryHandler.MESSAGE_PARAM, AutoscalingHistoryHandler.MESSAGE_FQ_FORMAT);
            this.put(AutoscalingHistoryHandler.TRIGGER_PARAM, AutoscalingHistoryHandler.TRIGGER_FQ_FORMAT);
            this.put(AutoscalingHistoryHandler.TYPE_PARAM, AutoscalingHistoryHandler.TYPE_FQ_FORMAT);
            this.put(AutoscalingHistoryHandler.STAGE_PARAM, AutoscalingHistoryHandler.STAGE_FQ_FORMAT);
            this.put(AutoscalingHistoryHandler.NODE_PARAM, AutoscalingHistoryHandler.NODE_FQ_FORMAT);
            this.put(AutoscalingHistoryHandler.COLLECTION_PARAM, AutoscalingHistoryHandler.COLLECTION_FQ_FORMAT);
            this.put(AutoscalingHistoryHandler.BEFORE_ACTION_PARAM, AutoscalingHistoryHandler.BEFORE_ACTION_FQ_FORMAT);
            this.put(AutoscalingHistoryHandler.AFTER_ACTION_PARAM, AutoscalingHistoryHandler.AFTER_ACTION_FQ_FORMAT);
        }
    };
    private final CoreContainer coreContainer;

    public AutoscalingHistoryHandler(CoreContainer coreContainer) {
        this.coreContainer = coreContainer;
    }

    @Override
    public PermissionNameProvider.Name getPermissionName(AuthorizationContext request) {
        return PermissionNameProvider.Name.AUTOSCALING_HISTORY_READ_PERM;
    }

    @Override
    public void handleRequestBody(SolrQueryRequest req, SolrQueryResponse rsp) throws Exception {
        ModifiableSolrParams params = new ModifiableSolrParams(req.getParams());
        String collection = params.get(SYSTEM_COLLECTION_PARAM, ".system");
        params.remove(SYSTEM_COLLECTION_PARAM);
        params.remove("qt");
        if (params.get("q") == null) {
            params.add("q", new String[]{"*:*"});
        }
        if (params.get("sort") == null) {
            params.add("sort", new String[]{"id asc"});
        }
        params.remove("fq", EVENTS_FQ);
        params.add("fq", new String[]{EVENTS_FQ});
        for (Map.Entry<String, String> e : formats.entrySet()) {
            String[] values = params.remove(e.getKey());
            if (values == null) continue;
            for (String value : values) {
                params.add("fq", new String[]{String.format(Locale.ROOT, (String)e.getValue(), value)});
            }
        }
        try {
            Map.Entry<String, String> e;
            CloudSolrClient cloudSolrClient = ((CloudSolrClient.Builder)new CloudSolrClient.Builder(Collections.singletonList(this.coreContainer.getZkController().getZkServerAddress()), Optional.empty()).withHttpClient(this.coreContainer.getUpdateShardHandler().getDefaultHttpClient())).build();
            e = null;
            try {
                QueryResponse qr = cloudSolrClient.query(collection, (SolrParams)params);
                rsp.setAllValues((NamedList<Object>)qr.getResponse());
            }
            catch (Throwable throwable) {
                e = throwable;
                throw throwable;
            }
            finally {
                if (cloudSolrClient != null) {
                    if (e != null) {
                        try {
                            cloudSolrClient.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)((Object)e)).addSuppressed(throwable);
                        }
                    } else {
                        cloudSolrClient.close();
                    }
                }
            }
        }
        catch (Exception e) {
            if (e instanceof SolrException && e.getMessage().contains("Collection not found")) {
                String msg = "Collection " + collection + " does not exist.";
                LOG.info(msg);
                rsp.getValues().add("error", (Object)msg);
            }
            throw e;
        }
    }

    @Override
    public String getDescription() {
        return "A handler to return autoscaling event history";
    }

    @Override
    public SolrInfoBean.Category getCategory() {
        return SolrInfoBean.Category.ADMIN;
    }
}

