/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.core;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.io.Closeable;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import org.apache.http.auth.AuthSchemeProvider;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.config.Lookup;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.IOUtils;
import org.apache.solr.client.solrj.cloud.SolrCloudManager;
import org.apache.solr.client.solrj.embedded.EmbeddedSolrServer;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.apache.solr.client.solrj.impl.HttpClientUtil;
import org.apache.solr.client.solrj.impl.SolrHttpClientBuilder;
import org.apache.solr.client.solrj.impl.SolrHttpClientContextBuilder;
import org.apache.solr.client.solrj.util.SolrIdentifierValidator;
import org.apache.solr.cloud.CloudDescriptor;
import org.apache.solr.cloud.Overseer;
import org.apache.solr.cloud.ZkController;
import org.apache.solr.cloud.autoscaling.AutoScalingHandler;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.util.ExecutorUtil;
import org.apache.solr.common.util.Utils;
import org.apache.solr.core.BlobRepository;
import org.apache.solr.core.CloserThread;
import org.apache.solr.core.ConfigSet;
import org.apache.solr.core.ConfigSetService;
import org.apache.solr.core.CoreDescriptor;
import org.apache.solr.core.CorePropertiesLocator;
import org.apache.solr.core.CoreSorter;
import org.apache.solr.core.CoresLocator;
import org.apache.solr.core.DirectoryFactory;
import org.apache.solr.core.NodeConfig;
import org.apache.solr.core.PluginBag;
import org.apache.solr.core.PluginInfo;
import org.apache.solr.core.SolrConfig;
import org.apache.solr.core.SolrCore;
import org.apache.solr.core.SolrCoreInitializationException;
import org.apache.solr.core.SolrCores;
import org.apache.solr.core.SolrInfoBean;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.core.SolrXmlConfig;
import org.apache.solr.core.TransientSolrCoreCache;
import org.apache.solr.core.ZkContainer;
import org.apache.solr.core.backup.repository.BackupRepository;
import org.apache.solr.core.backup.repository.BackupRepositoryFactory;
import org.apache.solr.handler.RequestHandlerBase;
import org.apache.solr.handler.admin.AutoscalingHistoryHandler;
import org.apache.solr.handler.admin.CollectionsHandler;
import org.apache.solr.handler.admin.ConfigSetsHandler;
import org.apache.solr.handler.admin.CoreAdminHandler;
import org.apache.solr.handler.admin.InfoHandler;
import org.apache.solr.handler.admin.MetricsCollectorHandler;
import org.apache.solr.handler.admin.MetricsHandler;
import org.apache.solr.handler.admin.MetricsHistoryHandler;
import org.apache.solr.handler.admin.SecurityConfHandler;
import org.apache.solr.handler.admin.SecurityConfHandlerLocal;
import org.apache.solr.handler.admin.SecurityConfHandlerZk;
import org.apache.solr.handler.admin.ZookeeperInfoHandler;
import org.apache.solr.handler.component.ShardHandlerFactory;
import org.apache.solr.logging.LogWatcher;
import org.apache.solr.logging.MDCLoggingContext;
import org.apache.solr.metrics.SolrCoreMetricManager;
import org.apache.solr.metrics.SolrMetricManager;
import org.apache.solr.metrics.SolrMetricProducer;
import org.apache.solr.request.SolrRequestHandler;
import org.apache.solr.search.SolrFieldCacheBean;
import org.apache.solr.security.AuthenticationPlugin;
import org.apache.solr.security.AuthorizationPlugin;
import org.apache.solr.security.HttpClientBuilderPlugin;
import org.apache.solr.security.PKIAuthenticationPlugin;
import org.apache.solr.security.PublicKeyHandler;
import org.apache.solr.security.SecurityPluginHolder;
import org.apache.solr.update.SolrCoreState;
import org.apache.solr.update.UpdateShardHandler;
import org.apache.solr.util.DefaultSolrThreadFactory;
import org.apache.solr.util.OrderedExecutor;
import org.apache.solr.util.stats.MetricUtils;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoreContainer {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    final SolrCores solrCores = new SolrCores(this);
    protected final Map<String, CoreLoadFailure> coreInitFailures = new ConcurrentHashMap<String, CoreLoadFailure>();
    protected CoreAdminHandler coreAdminHandler = null;
    protected CollectionsHandler collectionsHandler = null;
    private InfoHandler infoHandler;
    protected ConfigSetsHandler configSetsHandler = null;
    private PKIAuthenticationPlugin pkiAuthenticationPlugin;
    protected Properties containerProperties;
    private ConfigSetService coreConfigService;
    protected ZkContainer zkSys = new ZkContainer();
    protected ShardHandlerFactory shardHandlerFactory;
    private UpdateShardHandler updateShardHandler;
    private ExecutorService coreContainerWorkExecutor = ExecutorUtil.newMDCAwareCachedThreadPool((ThreadFactory)new DefaultSolrThreadFactory("coreContainerWorkExecutor"));
    private final OrderedExecutor replayUpdatesExecutor;
    protected LogWatcher logging = null;
    private CloserThread backgroundCloser = null;
    protected final NodeConfig cfg;
    protected final SolrResourceLoader loader;
    protected final String solrHome;
    protected final CoresLocator coresLocator;
    private String hostName;
    private final BlobRepository blobRepository = new BlobRepository(this);
    private PluginBag<SolrRequestHandler> containerHandlers = new PluginBag<SolrRequestHandler>(SolrRequestHandler.class, null);
    private boolean asyncSolrCoreLoad;
    protected SecurityConfHandler securityConfHandler;
    private SecurityPluginHolder<AuthorizationPlugin> authorizationPlugin;
    private SecurityPluginHolder<AuthenticationPlugin> authenticationPlugin;
    private BackupRepositoryFactory backupRepoFactory;
    protected SolrMetricManager metricManager;
    protected String metricTag = Integer.toHexString(this.hashCode());
    protected MetricsHandler metricsHandler;
    protected MetricsHistoryHandler metricsHistoryHandler;
    protected MetricsCollectorHandler metricsCollectorHandler;
    protected AutoscalingHistoryHandler autoscalingHistoryHandler;
    public static final long LOAD_COMPLETE = 1L;
    public static final long CORE_DISCOVERY_COMPLETE = 2L;
    public static final long INITIAL_CORE_LOAD_COMPLETE = 4L;
    private volatile long status = 0L;
    protected AutoScalingHandler autoScalingHandler;
    private volatile boolean isShutDown;

    public BackupRepository newBackupRepository(Optional<String> repositoryName) {
        BackupRepository repository = repositoryName.isPresent() ? this.backupRepoFactory.newInstance(this.getResourceLoader(), repositoryName.get()) : this.backupRepoFactory.newInstance(this.getResourceLoader());
        return repository;
    }

    public ExecutorService getCoreZkRegisterExecutorService() {
        return this.zkSys.getCoreZkRegisterExecutorService();
    }

    public SolrRequestHandler getRequestHandler(String path) {
        return RequestHandlerBase.getRequestHandler(path, this.containerHandlers);
    }

    public PluginBag<SolrRequestHandler> getRequestHandlers() {
        return this.containerHandlers;
    }

    public CoreContainer() {
        this(new SolrResourceLoader(SolrResourceLoader.locateSolrHome()));
    }

    public CoreContainer(SolrResourceLoader loader) {
        this(SolrXmlConfig.fromSolrHome(loader, loader.getInstancePath()));
    }

    public CoreContainer(String solrHome) {
        this(new SolrResourceLoader(Paths.get(solrHome, new String[0])));
    }

    public CoreContainer(NodeConfig config) {
        this(config, new Properties());
    }

    public CoreContainer(NodeConfig config, Properties properties) {
        this(config, properties, new CorePropertiesLocator(config.getCoreRootDirectory()));
    }

    public CoreContainer(NodeConfig config, Properties properties, boolean asyncSolrCoreLoad) {
        this(config, properties, new CorePropertiesLocator(config.getCoreRootDirectory()), asyncSolrCoreLoad);
    }

    public CoreContainer(NodeConfig config, Properties properties, CoresLocator locator) {
        this(config, properties, locator, false);
    }

    public CoreContainer(NodeConfig config, Properties properties, CoresLocator locator, boolean asyncSolrCoreLoad) {
        log.debug("New CoreContainer " + System.identityHashCode(this));
        this.isShutDown = false;
        this.loader = config.getSolrResourceLoader();
        this.solrHome = this.loader.getInstancePath().toString();
        this.containerHandlers.put("/admin/info/key", new PublicKeyHandler());
        this.cfg = Objects.requireNonNull(config);
        this.coresLocator = locator;
        this.containerProperties = new Properties(properties);
        this.asyncSolrCoreLoad = asyncSolrCoreLoad;
        this.replayUpdatesExecutor = new OrderedExecutor(this.cfg.getReplayUpdatesThreads(), ExecutorUtil.newMDCAwareCachedThreadPool((int)this.cfg.getReplayUpdatesThreads(), (ThreadFactory)new DefaultSolrThreadFactory("replayUpdatesExecutor")));
    }

    private synchronized void initializeAuthorizationPlugin(Map<String, Object> authorizationConf) {
        authorizationConf = Utils.getDeepCopy(authorizationConf, (int)4);
        SecurityPluginHolder<AuthorizationPlugin> old = this.authorizationPlugin;
        SecurityPluginHolder<AuthorizationPlugin> authorizationPlugin = null;
        if (authorizationConf != null) {
            String klas = (String)authorizationConf.get("class");
            if (klas == null) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "class is required for authorization plugin");
            }
            if (old != null && old.getZnodeVersion() == CoreContainer.readVersion(authorizationConf)) {
                return;
            }
            log.info("Initializing authorization plugin: " + klas);
            authorizationPlugin = new SecurityPluginHolder<AuthorizationPlugin>(CoreContainer.readVersion(authorizationConf), this.getResourceLoader().newInstance(klas, AuthorizationPlugin.class));
            ((AuthorizationPlugin)authorizationPlugin.plugin).init(authorizationConf);
        } else {
            log.debug("Security conf doesn't exist. Skipping setup for authorization module.");
        }
        this.authorizationPlugin = authorizationPlugin;
        if (old != null) {
            try {
                ((AuthorizationPlugin)old.plugin).close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private synchronized void initializeAuthenticationPlugin(Map<String, Object> authenticationConfig) {
        authenticationConfig = Utils.getDeepCopy(authenticationConfig, (int)4);
        String pluginClassName = null;
        if (authenticationConfig != null) {
            if (authenticationConfig.containsKey("class")) {
                pluginClassName = String.valueOf(authenticationConfig.get("class"));
            } else {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "No 'class' specified for authentication in ZK.");
            }
        }
        if (pluginClassName != null) {
            log.debug("Authentication plugin class obtained from security.json: " + pluginClassName);
        } else if (System.getProperty("authenticationPlugin") != null) {
            pluginClassName = System.getProperty("authenticationPlugin");
            log.debug("Authentication plugin class obtained from system property 'authenticationPlugin': " + pluginClassName);
        } else {
            log.debug("No authentication plugin used.");
        }
        SecurityPluginHolder<AuthenticationPlugin> old = this.authenticationPlugin;
        SecurityPluginHolder<AuthenticationPlugin> authenticationPlugin = null;
        if (pluginClassName != null) {
            log.info("Initializing authentication plugin: " + pluginClassName);
            authenticationPlugin = new SecurityPluginHolder<AuthenticationPlugin>(CoreContainer.readVersion(authenticationConfig), this.getResourceLoader().newInstance(pluginClassName, AuthenticationPlugin.class, null, new Class[]{CoreContainer.class}, new Object[]{this}));
        }
        if (authenticationPlugin != null) {
            ((AuthenticationPlugin)authenticationPlugin.plugin).init(authenticationConfig);
            this.setupHttpClientForAuthPlugin(authenticationPlugin.plugin);
        }
        this.authenticationPlugin = authenticationPlugin;
        try {
            if (old != null) {
                ((AuthenticationPlugin)old.plugin).close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void setupHttpClientForAuthPlugin(Object authcPlugin) {
        if (authcPlugin instanceof HttpClientBuilderPlugin) {
            final SolrHttpClientBuilder builder = ((HttpClientBuilderPlugin)authcPlugin).getHttpClientBuilder(HttpClientUtil.getHttpClientBuilder());
            log.debug("Reconfiguring HttpClient settings.");
            SolrHttpClientContextBuilder httpClientBuilder = new SolrHttpClientContextBuilder();
            if (builder.getCredentialsProviderProvider() != null) {
                httpClientBuilder.setDefaultCredentialsProvider(new SolrHttpClientContextBuilder.CredentialsProviderProvider(){

                    public CredentialsProvider getCredentialsProvider() {
                        return builder.getCredentialsProviderProvider().getCredentialsProvider();
                    }
                });
            }
            if (builder.getAuthSchemeRegistryProvider() != null) {
                httpClientBuilder.setAuthSchemeRegistryProvider(new SolrHttpClientContextBuilder.AuthSchemeRegistryProvider(){

                    public Lookup<AuthSchemeProvider> getAuthSchemeRegistry() {
                        return builder.getAuthSchemeRegistryProvider().getAuthSchemeRegistry();
                    }
                });
            }
            HttpClientUtil.setHttpClientRequestContextBuilder((SolrHttpClientContextBuilder)httpClientBuilder);
        } else if (this.pkiAuthenticationPlugin != null) {
            if (this.pkiAuthenticationPlugin.isInterceptorRegistered()) {
                return;
            }
            log.info("PKIAuthenticationPlugin is managing internode requests");
            this.setupHttpClientForAuthPlugin(this.pkiAuthenticationPlugin);
            this.pkiAuthenticationPlugin.setInterceptorRegistered();
        }
    }

    private static int readVersion(Map<String, Object> conf) {
        if (conf == null) {
            return -1;
        }
        Map meta = (Map)conf.get("");
        if (meta == null) {
            return -1;
        }
        Number v = (Number)meta.get("v");
        return v == null ? -1 : v.intValue();
    }

    protected CoreContainer(Object testConstructor) {
        log.debug("New CoreContainer " + System.identityHashCode(this));
        this.isShutDown = false;
        this.solrHome = null;
        this.loader = null;
        this.coresLocator = null;
        this.cfg = null;
        this.containerProperties = null;
        this.replayUpdatesExecutor = null;
    }

    public static CoreContainer createAndLoad(Path solrHome) {
        return CoreContainer.createAndLoad(solrHome, solrHome.resolve("solr.xml"));
    }

    public static CoreContainer createAndLoad(Path solrHome, Path configFile) {
        SolrResourceLoader loader = new SolrResourceLoader(solrHome);
        CoreContainer cc = new CoreContainer(SolrXmlConfig.fromFile(loader, configFile));
        try {
            cc.load();
        }
        catch (Exception e) {
            cc.shutdown();
            throw e;
        }
        return cc;
    }

    public Properties getContainerProperties() {
        return this.containerProperties;
    }

    public PKIAuthenticationPlugin getPkiAuthenticationPlugin() {
        return this.pkiAuthenticationPlugin;
    }

    public SolrMetricManager getMetricManager() {
        return this.metricManager;
    }

    public OrderedExecutor getReplayUpdatesExecutor() {
        return this.replayUpdatesExecutor;
    }

    public MetricsHandler getMetricsHandler() {
        return this.metricsHandler;
    }

    public MetricsHistoryHandler getMetricsHistoryHandler() {
        return this.metricsHistoryHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() {
        block17: {
            log.debug("Loading cores into CoreContainer [instanceDir={}]", (Object)this.loader.getInstancePath());
            String libDir = this.cfg.getSharedLibDirectory();
            if (libDir != null) {
                Path libPath = this.loader.getInstancePath().resolve(libDir);
                try {
                    this.loader.addToClassLoader(SolrResourceLoader.getURLs(libPath));
                    this.loader.reloadLuceneSPI();
                }
                catch (IOException e) {
                    if (libDir.equals("lib")) break block17;
                    log.warn("Couldn't add files from {} to classpath: {}", (Object)libPath, (Object)e.getMessage());
                }
            }
        }
        this.metricManager = new SolrMetricManager(this.loader, this.cfg.getMetricsConfig());
        this.coreContainerWorkExecutor = MetricUtils.instrumentedExecutorService(this.coreContainerWorkExecutor, null, this.metricManager.registry(SolrMetricManager.getRegistryName(SolrInfoBean.Group.node, new String[0])), SolrMetricManager.mkName("coreContainerWorkExecutor", SolrInfoBean.Category.CONTAINER.toString(), "threadPool"));
        this.shardHandlerFactory = ShardHandlerFactory.newInstance(this.cfg.getShardHandlerFactoryPluginInfo(), this.loader);
        if (this.shardHandlerFactory instanceof SolrMetricProducer) {
            SolrMetricProducer metricProducer = (SolrMetricProducer)((Object)this.shardHandlerFactory);
            metricProducer.initializeMetrics(this.metricManager, SolrInfoBean.Group.node.toString(), this.metricTag, "httpShardHandler");
        }
        this.updateShardHandler = new UpdateShardHandler(this.cfg.getUpdateShardHandlerConfig());
        this.updateShardHandler.initializeMetrics(this.metricManager, SolrInfoBean.Group.node.toString(), this.metricTag, "updateShardHandler");
        this.solrCores.load(this.loader);
        this.logging = LogWatcher.newRegisteredLogWatcher(this.cfg.getLogWatcherConfig(), this.loader);
        this.hostName = this.cfg.getNodeName();
        this.zkSys.initZooKeeper(this, this.solrHome, this.cfg.getCloudConfig());
        if (this.isZooKeeperAware()) {
            this.pkiAuthenticationPlugin = new PKIAuthenticationPlugin(this, this.zkSys.getZkController().getNodeName(), (PublicKeyHandler)this.containerHandlers.get("/admin/info/key"));
        }
        MDCLoggingContext.setNode(this);
        this.securityConfHandler = this.isZooKeeperAware() ? new SecurityConfHandlerZk(this) : new SecurityConfHandlerLocal(this);
        this.reloadSecurityProperties();
        this.backupRepoFactory = new BackupRepositoryFactory(this.cfg.getBackupRepositoryPlugins());
        this.createHandler("/admin/zookeeper", ZookeeperInfoHandler.class.getName(), ZookeeperInfoHandler.class);
        this.collectionsHandler = this.createHandler("/admin/collections", this.cfg.getCollectionsHandlerClass(), CollectionsHandler.class);
        this.infoHandler = this.createHandler("/admin/info", this.cfg.getInfoHandlerClass(), InfoHandler.class);
        this.coreAdminHandler = this.createHandler("/admin/cores", this.cfg.getCoreAdminHandlerClass(), CoreAdminHandler.class);
        this.configSetsHandler = this.createHandler("/admin/configs", this.cfg.getConfigSetsHandlerClass(), ConfigSetsHandler.class);
        this.metricsHandler = new MetricsHandler(this);
        this.containerHandlers.put("/admin/metrics", this.metricsHandler);
        this.metricsHandler.initializeMetrics(this.metricManager, SolrInfoBean.Group.node.toString(), this.metricTag, "/admin/metrics");
        this.createMetricsHistoryHandler();
        this.autoscalingHistoryHandler = this.createHandler("/admin/autoscaling/history", AutoscalingHistoryHandler.class.getName(), AutoscalingHistoryHandler.class);
        this.metricsCollectorHandler = this.createHandler("/admin/metrics/collector", MetricsCollectorHandler.class.getName(), MetricsCollectorHandler.class);
        this.metricsCollectorHandler.init(null);
        this.containerHandlers.put("/admin/authorization", this.securityConfHandler);
        this.securityConfHandler.initializeMetrics(this.metricManager, SolrInfoBean.Group.node.toString(), this.metricTag, "/admin/authorization");
        this.containerHandlers.put("/admin/authentication", this.securityConfHandler);
        PluginInfo[] metricReporters = this.cfg.getMetricsConfig().getMetricReporters();
        this.metricManager.loadReporters(metricReporters, this.loader, this, null, null, SolrInfoBean.Group.node, new String[0]);
        this.metricManager.loadReporters(metricReporters, this.loader, this, null, null, SolrInfoBean.Group.jvm, new String[0]);
        this.metricManager.loadReporters(metricReporters, this.loader, this, null, null, SolrInfoBean.Group.jetty, new String[0]);
        this.coreConfigService = ConfigSetService.createConfigSetService(this.cfg, this.loader, this.zkSys.zkController);
        this.containerProperties.putAll((Map<?, ?>)this.cfg.getSolrProperties());
        String registryName = SolrMetricManager.getRegistryName(SolrInfoBean.Group.node, new String[0]);
        String metricTag = Integer.toHexString(this.hashCode());
        this.metricManager.registerGauge(null, registryName, () -> this.solrCores.getCores().size(), metricTag, true, "loaded", SolrInfoBean.Category.CONTAINER.toString(), "cores");
        this.metricManager.registerGauge(null, registryName, () -> this.solrCores.getLoadedCoreNames().size() - this.solrCores.getCores().size(), metricTag, true, "lazy", SolrInfoBean.Category.CONTAINER.toString(), "cores");
        this.metricManager.registerGauge(null, registryName, () -> this.solrCores.getAllCoreNames().size() - this.solrCores.getLoadedCoreNames().size(), metricTag, true, "unloaded", SolrInfoBean.Category.CONTAINER.toString(), "cores");
        Path dataHome = this.cfg.getSolrDataHome() != null ? this.cfg.getSolrDataHome() : this.cfg.getCoreRootDirectory();
        this.metricManager.registerGauge(null, registryName, () -> dataHome.toFile().getTotalSpace(), metricTag, true, "totalSpace", SolrInfoBean.Category.CONTAINER.toString(), "fs");
        this.metricManager.registerGauge(null, registryName, () -> dataHome.toFile().getUsableSpace(), metricTag, true, "usableSpace", SolrInfoBean.Category.CONTAINER.toString(), "fs");
        this.metricManager.registerGauge(null, registryName, () -> dataHome.toAbsolutePath().toString(), metricTag, true, "path", SolrInfoBean.Category.CONTAINER.toString(), "fs");
        this.metricManager.registerGauge(null, registryName, () -> {
            try {
                return IOUtils.spins((Path)dataHome.toAbsolutePath());
            }
            catch (IOException e) {
                return true;
            }
        }, metricTag, true, "spins", SolrInfoBean.Category.CONTAINER.toString(), "fs");
        this.metricManager.registerGauge(null, registryName, () -> this.cfg.getCoreRootDirectory().toFile().getTotalSpace(), metricTag, true, "totalSpace", SolrInfoBean.Category.CONTAINER.toString(), "fs", "coreRoot");
        this.metricManager.registerGauge(null, registryName, () -> this.cfg.getCoreRootDirectory().toFile().getUsableSpace(), metricTag, true, "usableSpace", SolrInfoBean.Category.CONTAINER.toString(), "fs", "coreRoot");
        this.metricManager.registerGauge(null, registryName, () -> this.cfg.getCoreRootDirectory().toAbsolutePath().toString(), metricTag, true, "path", SolrInfoBean.Category.CONTAINER.toString(), "fs", "coreRoot");
        this.metricManager.registerGauge(null, registryName, () -> {
            try {
                return IOUtils.spins((Path)this.cfg.getCoreRootDirectory().toAbsolutePath());
            }
            catch (IOException e) {
                return true;
            }
        }, metricTag, true, "spins", SolrInfoBean.Category.CONTAINER.toString(), "fs", "coreRoot");
        this.metricManager.registerGauge(null, registryName, () -> this.getClass().getPackage().getSpecificationVersion(), metricTag, true, "specification", SolrInfoBean.Category.CONTAINER.toString(), "version");
        this.metricManager.registerGauge(null, registryName, () -> this.getClass().getPackage().getImplementationVersion(), metricTag, true, "implementation", SolrInfoBean.Category.CONTAINER.toString(), "version");
        SolrFieldCacheBean fieldCacheBean = new SolrFieldCacheBean();
        fieldCacheBean.initializeMetrics(this.metricManager, registryName, metricTag, null);
        if (this.isZooKeeperAware()) {
            this.metricManager.loadClusterReporters(metricReporters, this);
        }
        ExecutorService coreLoadExecutor = MetricUtils.instrumentedExecutorService(ExecutorUtil.newMDCAwareFixedThreadPool((int)this.cfg.getCoreLoadThreadCount(this.isZooKeeperAware()), (ThreadFactory)new DefaultSolrThreadFactory("coreLoadExecutor")), null, this.metricManager.registry(SolrMetricManager.getRegistryName(SolrInfoBean.Group.node, new String[0])), SolrMetricManager.mkName("coreLoadExecutor", SolrInfoBean.Category.CONTAINER.toString(), "threadPool"));
        ArrayList<Future<SolrCore>> futures = new ArrayList<Future<SolrCore>>();
        try {
            List<CoreDescriptor> cds = this.coresLocator.discover(this);
            if (this.isZooKeeperAware()) {
                CoreSorter coreComparator = new CoreSorter().init(this);
                cds = new ArrayList<CoreDescriptor>(cds);
                Collections.sort(cds, coreComparator::compare);
            }
            CoreContainer.checkForDuplicateCoreNames(cds);
            this.status |= 2L;
            for (CoreDescriptor cd : cds) {
                if (cd.isTransient() || !cd.isLoadOnStartup()) {
                    this.solrCores.addCoreDescriptor(cd);
                } else if (this.asyncSolrCoreLoad) {
                    this.solrCores.markCoreAsLoading(cd);
                }
                if (!cd.isLoadOnStartup()) continue;
                futures.add(coreLoadExecutor.submit(() -> {
                    SolrCore core;
                    try {
                        if (this.zkSys.getZkController() != null) {
                            this.zkSys.getZkController().throwErrorIfReplicaReplaced(cd);
                        }
                        this.solrCores.waitAddPendingCoreOps(cd.getName());
                        core = this.createFromDescriptor(cd, false, false);
                    }
                    finally {
                        this.solrCores.removeFromPendingOps(cd.getName());
                        if (this.asyncSolrCoreLoad) {
                            this.solrCores.markCoreAsNotLoading(cd);
                        }
                    }
                    try {
                        this.zkSys.registerInZk(core, true, false);
                    }
                    catch (RuntimeException e) {
                        SolrException.log((Logger)log, (String)"Error registering SolrCore", (Throwable)e);
                    }
                    return core;
                }));
            }
            this.backgroundCloser = new CloserThread(this, this.solrCores, this.cfg);
            this.backgroundCloser.start();
        }
        finally {
            if (this.asyncSolrCoreLoad && futures != null) {
                this.coreContainerWorkExecutor.submit(() -> {
                    try {
                        for (Future future : futures) {
                            try {
                                future.get();
                            }
                            catch (InterruptedException e) {
                                Thread.currentThread().interrupt();
                            }
                            catch (ExecutionException e) {
                                log.error("Error waiting for SolrCore to be loaded on startup", e.getCause());
                            }
                        }
                    }
                    finally {
                        ExecutorUtil.shutdownAndAwaitTermination((ExecutorService)coreLoadExecutor);
                    }
                });
            } else {
                ExecutorUtil.shutdownAndAwaitTermination((ExecutorService)coreLoadExecutor);
            }
        }
        if (this.isZooKeeperAware()) {
            this.zkSys.getZkController().checkOverseerDesignate();
            this.autoScalingHandler = new AutoScalingHandler(this.getZkController().getSolrCloudManager(), this.loader);
            this.containerHandlers.put("/admin/autoscaling", this.autoScalingHandler);
            this.autoScalingHandler.initializeMetrics(this.metricManager, SolrInfoBean.Group.node.toString(), metricTag, "/admin/autoscaling");
        }
        this.status |= 5L;
    }

    private void createMetricsHistoryHandler() {
        EmbeddedSolrServer client;
        SolrCloudManager cloudManager;
        String name;
        Map<String, Object> initArgs;
        PluginInfo plugin = this.cfg.getMetricsConfig().getHistoryHandler();
        if (plugin != null && plugin.initArgs != null) {
            initArgs = plugin.initArgs.asMap(5);
            initArgs.put("enable", plugin.isEnabled());
        } else {
            initArgs = new HashMap();
        }
        if (this.isZooKeeperAware()) {
            name = this.getZkController().getNodeName();
            cloudManager = this.getZkController().getSolrCloudManager();
            client = ((CloudSolrClient.Builder)new CloudSolrClient.Builder(Collections.singletonList(this.getZkController().getZkServerAddress()), Optional.empty()).withHttpClient(this.updateShardHandler.getDefaultHttpClient())).build();
        } else {
            name = this.getNodeConfig().getNodeName();
            if (name == null || name.isEmpty()) {
                name = "localhost";
            }
            cloudManager = null;
            client = new EmbeddedSolrServer(this, ".system"){

                @Override
                public void close() throws IOException {
                }
            };
            if (!initArgs.containsKey("enableNodes")) {
                initArgs.put("enableNodes", true);
            }
            if (!initArgs.containsKey("enableReplicas")) {
                initArgs.put("enableReplicas", true);
            }
        }
        this.metricsHistoryHandler = new MetricsHistoryHandler(name, this.metricsHandler, client, cloudManager, initArgs);
        this.containerHandlers.put("/admin/metrics/history", this.metricsHistoryHandler);
        this.metricsHistoryHandler.initializeMetrics(this.metricManager, SolrInfoBean.Group.node.toString(), this.metricTag, "/admin/metrics/history");
    }

    public void securityNodeChanged() {
        log.info("Security node changed, reloading security.json");
        this.reloadSecurityProperties();
    }

    private void reloadSecurityProperties() {
        SecurityConfHandler.SecurityConfig securityConfig = this.securityConfHandler.getSecurityConfig(false);
        this.initializeAuthorizationPlugin((Map)securityConfig.getData().get("authorization"));
        this.initializeAuthenticationPlugin((Map)securityConfig.getData().get("authentication"));
    }

    private static void checkForDuplicateCoreNames(List<CoreDescriptor> cds) {
        HashMap addedCores = Maps.newHashMap();
        for (CoreDescriptor cd : cds) {
            String name = cd.getName();
            if (addedCores.containsKey(name)) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, String.format(Locale.ROOT, "Found multiple cores with the name [%s], with instancedirs [%s] and [%s]", name, addedCores.get(name), cd.getInstanceDir()));
            }
            addedCores.put(name, cd.getInstanceDir());
        }
    }

    public boolean isShutDown() {
        return this.isShutDown;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void shutdown() {
        log.info("Shutting down CoreContainer instance=" + System.identityHashCode(this));
        this.isShutDown = true;
        ExecutorUtil.shutdownAndAwaitTermination((ExecutorService)this.coreContainerWorkExecutor);
        this.replayUpdatesExecutor.shutdownAndAwaitTermination();
        if (this.metricsHistoryHandler != null) {
            org.apache.solr.common.util.IOUtils.closeQuietly((Closeable)this.metricsHistoryHandler.getSolrClient());
            this.metricsHistoryHandler.close();
        }
        if (this.metricManager != null) {
            this.metricManager.closeReporters(SolrMetricManager.getRegistryName(SolrInfoBean.Group.node, new String[0]));
            this.metricManager.closeReporters(SolrMetricManager.getRegistryName(SolrInfoBean.Group.jvm, new String[0]));
            this.metricManager.closeReporters(SolrMetricManager.getRegistryName(SolrInfoBean.Group.jetty, new String[0]));
            this.metricManager.unregisterGauges(SolrMetricManager.getRegistryName(SolrInfoBean.Group.node, new String[0]), this.metricTag);
            this.metricManager.unregisterGauges(SolrMetricManager.getRegistryName(SolrInfoBean.Group.jvm, new String[0]), this.metricTag);
            this.metricManager.unregisterGauges(SolrMetricManager.getRegistryName(SolrInfoBean.Group.jetty, new String[0]), this.metricTag);
        }
        if (this.isZooKeeperAware()) {
            this.cancelCoreRecoveries();
            this.zkSys.zkController.publishNodeAsDown(this.zkSys.zkController.getNodeName());
            try {
                this.zkSys.zkController.removeEphemeralLiveNode();
            }
            catch (Exception e) {
                log.warn("Error removing live node. Continuing to close CoreContainer", (Throwable)e);
            }
            if (this.metricManager != null) {
                this.metricManager.closeReporters(SolrMetricManager.getRegistryName(SolrInfoBean.Group.cluster, new String[0]));
            }
        }
        try {
            if (this.coreAdminHandler != null) {
                this.coreAdminHandler.shutdown();
            }
        }
        catch (Exception e) {
            log.warn("Error shutting down CoreAdminHandler. Continuing to close CoreContainer.", (Throwable)e);
        }
        try {
            Object e;
            block45: {
                e = this.solrCores.getModifyLock();
                // MONITORENTER : e
                this.solrCores.getModifyLock().notifyAll();
                // MONITOREXIT : e
                if (this.backgroundCloser != null) {
                    try {
                        while (true) {
                            this.backgroundCloser.join(15000L);
                            if (this.backgroundCloser.isAlive()) {
                                e = this.solrCores.getModifyLock();
                                // MONITORENTER : e
                                this.solrCores.getModifyLock().notifyAll();
                                // MONITOREXIT : e
                                continue;
                            }
                            break;
                        }
                    }
                    catch (InterruptedException e2) {
                        Thread.currentThread().interrupt();
                        if (!log.isDebugEnabled()) break block45;
                        log.debug("backgroundCloser thread was interrupted before finishing");
                    }
                }
            }
            this.solrCores.close();
            e = this.solrCores.getModifyLock();
            // MONITORENTER : e
            this.solrCores.getModifyLock().notifyAll();
            // MONITOREXIT : e
        }
        finally {
            try {
                if (this.shardHandlerFactory != null) {
                    this.shardHandlerFactory.close();
                }
            }
            finally {
                try {
                    if (this.updateShardHandler != null) {
                        this.updateShardHandler.close();
                    }
                }
                finally {
                    this.zkSys.close();
                }
            }
        }
        try {
            if (this.authorizationPlugin != null) {
                ((AuthorizationPlugin)this.authorizationPlugin.plugin).close();
            }
        }
        catch (IOException e) {
            log.warn("Exception while closing authorization plugin.", (Throwable)e);
        }
        try {
            if (this.authenticationPlugin != null) {
                ((AuthenticationPlugin)this.authenticationPlugin.plugin).close();
                this.authenticationPlugin = null;
            }
        }
        catch (Exception e) {
            log.warn("Exception while closing authentication plugin.", (Throwable)e);
        }
        IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{this.loader});
    }

    public void cancelCoreRecoveries() {
        List<SolrCore> cores = this.solrCores.getCores();
        for (SolrCore core : cores) {
            try {
                core.getSolrCoreState().cancelRecovery();
            }
            catch (Exception e) {
                SolrException.log((Logger)log, (String)"Error canceling recovery for core", (Throwable)e);
            }
        }
    }

    protected void finalize() throws Throwable {
        try {
            if (!this.isShutDown) {
                log.error("CoreContainer was not close prior to finalize(), indicates a bug -- POSSIBLE RESOURCE LEAK!!!  instance=" + System.identityHashCode(this));
            }
        }
        finally {
            super.finalize();
        }
    }

    public CoresLocator getCoresLocator() {
        return this.coresLocator;
    }

    protected SolrCore registerCore(CoreDescriptor cd, SolrCore core, boolean registerInZk, boolean skipRecovery) {
        if (core == null) {
            throw new RuntimeException("Can not register a null core.");
        }
        if (this.isShutDown) {
            core.close();
            throw new IllegalStateException("This CoreContainer has been closed");
        }
        SolrCore old = this.solrCores.putCore(cd, core);
        core.setName(cd.getName());
        this.coreInitFailures.remove(cd.getName());
        if (old == null || old == core) {
            log.debug("registering core: " + cd.getName());
            if (registerInZk) {
                this.zkSys.registerInZk(core, false, skipRecovery);
            }
            return null;
        }
        log.debug("replacing core: " + cd.getName());
        old.close();
        if (registerInZk) {
            this.zkSys.registerInZk(core, false, skipRecovery);
        }
        return old;
    }

    public SolrCore create(String coreName, Map<String, String> parameters) {
        return this.create(coreName, this.cfg.getCoreRootDirectory().resolve(coreName), parameters, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SolrCore create(String coreName, Path instancePath, Map<String, String> parameters, boolean newCollection) {
        CoreDescriptor cd = new CoreDescriptor(coreName, instancePath, parameters, this.getContainerProperties(), this.isZooKeeperAware());
        if (this.getAllCoreNames().contains(coreName)) {
            log.warn("Creating a core with existing name is not allowed");
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Core with name '" + coreName + "' already exists.");
        }
        boolean preExisitingZkEntry = false;
        try {
            if (this.getZkController() != null) {
                if (!Overseer.isLegacy(this.getZkController().getZkStateReader()) && cd.getCloudDescriptor().getCoreNodeName() == null) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "non legacy mode coreNodeName missing " + parameters.toString());
                }
                preExisitingZkEntry = this.getZkController().checkIfCoreNodeNameAlreadyExists(cd);
            }
            this.coresLocator.create(this, cd);
            SolrCore core = null;
            try {
                this.solrCores.waitAddPendingCoreOps(cd.getName());
                core = this.createFromDescriptor(cd, true, newCollection);
                this.coresLocator.persist(this, cd);
            }
            finally {
                this.solrCores.removeFromPendingOps(cd.getName());
            }
            return core;
        }
        catch (Exception ex) {
            this.coresLocator.delete(this, cd);
            if (this.isZooKeeperAware() && !preExisitingZkEntry) {
                try {
                    this.getZkController().unregister(coreName, cd);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    SolrException.log((Logger)log, null, (Throwable)e);
                }
                catch (KeeperException e) {
                    SolrException.log((Logger)log, null, (Throwable)e);
                }
                catch (Exception e) {
                    SolrException.log((Logger)log, null, (Throwable)e);
                }
            }
            Throwable tc = ex;
            Throwable c = null;
            do {
                if ((tc = tc.getCause()) == null) continue;
                c = tc;
            } while (tc != null);
            String rootMsg = "";
            if (c != null) {
                rootMsg = " Caused by: " + c.getMessage();
            }
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Error CREATEing SolrCore '" + coreName + "': " + ex.getMessage() + rootMsg, (Throwable)ex);
        }
    }

    private SolrCore createFromDescriptor(CoreDescriptor dcore, boolean publishState, boolean newCollection) {
        if (this.isShutDown) {
            throw new SolrException(SolrException.ErrorCode.SERVICE_UNAVAILABLE, "Solr has been shutdown.");
        }
        SolrCore core = null;
        try {
            MDCLoggingContext.setCoreDescriptor(this, dcore);
            SolrIdentifierValidator.validateCoreName((String)dcore.getName());
            if (this.zkSys.getZkController() != null) {
                this.zkSys.getZkController().preRegister(dcore, publishState);
            }
            ConfigSet coreConfig = this.getConfigSet(dcore);
            dcore.setConfigSetTrusted(coreConfig.isTrusted());
            log.info("Creating SolrCore '{}' using configuration from {}, trusted={}", new Object[]{dcore.getName(), coreConfig.getName(), dcore.isConfigSetTrusted()});
            try {
                core = new SolrCore(this, dcore, coreConfig);
            }
            catch (SolrException e) {
                core = this.processCoreCreateException(e, dcore, coreConfig);
            }
            if (!this.isZooKeeperAware() && core.getUpdateHandler().getUpdateLog() != null) {
                core.getUpdateHandler().getUpdateLog().recoverFromLog();
            }
            this.registerCore(dcore, core, publishState, newCollection);
            SolrCore e = core;
            return e;
        }
        catch (Exception e) {
            this.coreInitFailures.put(dcore.getName(), new CoreLoadFailure(dcore, e));
            if (e instanceof ZkController.NotInClusterStateException && !newCollection) {
                this.unload(dcore.getName(), true, true, true);
                throw e;
            }
            this.solrCores.removeCoreDescriptor(dcore);
            SolrException solrException = new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unable to create core [" + dcore.getName() + "]", (Throwable)e);
            if (core != null && !core.isClosed()) {
                org.apache.solr.common.util.IOUtils.closeQuietly((Closeable)core);
            }
            throw solrException;
        }
        catch (Throwable t) {
            SolrException e = new SolrException(SolrException.ErrorCode.SERVER_ERROR, "JVM Error creating core [" + dcore.getName() + "]: " + t.getMessage(), t);
            this.coreInitFailures.put(dcore.getName(), new CoreLoadFailure(dcore, (Exception)((Object)e)));
            this.solrCores.removeCoreDescriptor(dcore);
            if (core != null && !core.isClosed()) {
                org.apache.solr.common.util.IOUtils.closeQuietly((Closeable)core);
            }
            throw t;
        }
        finally {
            MDCLoggingContext.clear();
        }
    }

    public boolean isSharedFs(CoreDescriptor cd) {
        try (SolrCore core = this.getCore(cd.getName());){
            if (core != null) {
                boolean bl = core.getDirectoryFactory().isSharedStorage();
                return bl;
            }
            ConfigSet configSet = this.getConfigSet(cd);
            boolean bl = DirectoryFactory.loadDirectoryFactory(configSet.getSolrConfig(), this, null).isSharedStorage();
            return bl;
        }
    }

    private ConfigSet getConfigSet(CoreDescriptor cd) {
        return this.coreConfigService.getConfig(cd);
    }

    private SolrCore processCoreCreateException(SolrException original, CoreDescriptor dcore, ConfigSet coreConfig) {
        Throwable cause = original;
        while ((cause = cause.getCause()) != null && !(cause instanceof CorruptIndexException)) {
        }
        if (cause == null) {
            throw original;
        }
        CoreInitFailedAction action = CoreInitFailedAction.valueOf(System.getProperty(CoreInitFailedAction.class.getSimpleName(), "none"));
        log.debug("CorruptIndexException while creating core, will attempt to repair via {}", (Object)action);
        switch (action) {
            case fromleader: {
                if (this.isZooKeeperAware()) {
                    CloudDescriptor desc = dcore.getCloudDescriptor();
                    try {
                        Replica leader = this.getZkController().getClusterState().getCollection(desc.getCollectionName()).getSlice(desc.getShardId()).getLeader();
                        if (leader != null && leader.getState() == Replica.State.ACTIVE) {
                            log.info("Found active leader, will attempt to create fresh core and recover.");
                            this.resetIndexDirectory(dcore, coreConfig);
                            this.getZkController().getShardTerms(desc.getCollectionName(), desc.getShardId()).setTermToZero(desc.getCoreNodeName());
                            return new SolrCore(this, dcore, coreConfig);
                        }
                    }
                    catch (SolrException se) {
                        se.addSuppressed((Throwable)original);
                        throw se;
                    }
                }
                throw original;
            }
            case none: {
                throw original;
            }
        }
        log.warn("Failed to create core, and did not recognize specified 'CoreInitFailedAction': [{}]. Valid options are {}.", (Object)action, Arrays.asList(CoreInitFailedAction.values()));
        throw original;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void resetIndexDirectory(CoreDescriptor dcore, ConfigSet coreConfig) {
        SolrConfig config = coreConfig.getSolrConfig();
        String registryName = SolrMetricManager.getRegistryName(SolrInfoBean.Group.core, dcore.getName());
        DirectoryFactory df = DirectoryFactory.loadDirectoryFactory(config, this, registryName);
        String dataDir = SolrCore.findDataDir(df, null, config, dcore);
        String tmpIdxDirName = "index." + new SimpleDateFormat("yyyyMMddHHmmssSSS", Locale.ROOT).format(new Date());
        SolrCore.modifyIndexProps(df, dataDir, config, tmpIdxDirName);
        Directory dir = null;
        try {
            dir = df.get(dataDir, DirectoryFactory.DirContext.META_DATA, config.indexConfig.lockType);
        }
        catch (IOException e) {
            try {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
            }
            catch (Throwable throwable) {
                try {
                    df.release(dir);
                    df.doneWithDirectory(dir);
                    throw throwable;
                }
                catch (IOException e2) {
                    SolrException.log((Logger)log, (Throwable)e2);
                }
                throw throwable;
            }
        }
        try {
            df.release(dir);
            df.doneWithDirectory(dir);
            return;
        }
        catch (IOException e) {
            SolrException.log((Logger)log, (Throwable)e);
            return;
        }
    }

    public Collection<SolrCore> getCores() {
        return this.solrCores.getCores();
    }

    public Collection<String> getLoadedCoreNames() {
        return this.solrCores.getLoadedCoreNames();
    }

    public Collection<String> getNamesForCore(SolrCore core) {
        return this.solrCores.getNamesForCore(core);
    }

    public Collection<String> getAllCoreNames() {
        return this.solrCores.getAllCoreNames();
    }

    public Map<String, CoreLoadFailure> getCoreInitFailures() {
        return ImmutableMap.copyOf(this.coreInitFailures);
    }

    private CoreDescriptor reloadCoreDescriptor(CoreDescriptor oldDesc) {
        if (oldDesc == null) {
            return null;
        }
        CorePropertiesLocator cpl = new CorePropertiesLocator(null);
        CoreDescriptor ret = cpl.buildCoreDescriptor(oldDesc.getInstanceDir().resolve("core.properties"), this);
        if (ret == null) {
            oldDesc.loadExtraProperties();
            return oldDesc;
        }
        if (ret.getCloudDescriptor() != null) {
            ret.getCloudDescriptor().reload(oldDesc.getCloudDescriptor());
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void reload(String name) {
        SolrCore core = this.solrCores.getCoreFromAnyList(name, false);
        if (core != null) {
            CoreDescriptor cd = this.reloadCoreDescriptor(core.getCoreDescriptor());
            this.solrCores.addCoreDescriptor(cd);
            try {
                this.solrCores.waitAddPendingCoreOps(cd.getName());
                ConfigSet coreConfig = this.coreConfigService.getConfig(cd);
                log.info("Reloading SolrCore '{}' using configuration from {}", (Object)cd.getName(), (Object)coreConfig.getName());
                SolrCore newCore = core.reload(coreConfig);
                this.registerCore(cd, newCore, false, false);
                if (this.getZkController() == null) return;
                DocCollection docCollection = this.getZkController().getClusterState().getCollection(cd.getCollectionName());
                Replica replica = docCollection.getReplica(cd.getCloudDescriptor().getCoreNodeName());
                assert (replica != null);
                if (replica.getType() == Replica.Type.TLOG) {
                    this.getZkController().stopReplicationFromLeader(core.getName());
                    if (cd.getCloudDescriptor().isLeader()) return;
                    this.getZkController().startReplicationFromLeader(newCore.getName(), true);
                    return;
                }
                if (replica.getType() != Replica.Type.PULL) return;
                this.getZkController().stopReplicationFromLeader(core.getName());
                this.getZkController().startReplicationFromLeader(newCore.getName(), false);
                return;
            }
            catch (SolrCoreState.CoreIsClosedException e) {
                throw e;
            }
            catch (Exception e) {
                this.coreInitFailures.put(cd.getName(), new CoreLoadFailure(cd, e));
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unable to reload core [" + cd.getName() + "]", (Throwable)e);
            }
            finally {
                this.solrCores.removeFromPendingOps(cd.getName());
            }
        }
        CoreLoadFailure clf = this.coreInitFailures.get(name);
        if (clf == null) throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "No such core: " + name);
        try {
            this.solrCores.waitAddPendingCoreOps(clf.cd.getName());
            this.createFromDescriptor(clf.cd, true, false);
            return;
        }
        finally {
            this.solrCores.removeFromPendingOps(clf.cd.getName());
        }
    }

    public void swap(String n0, String n1) {
        if (n0 == null || n1 == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Can not swap unnamed cores.");
        }
        this.solrCores.swap(n0, n1);
        this.coresLocator.swap(this, this.solrCores.getCoreDescriptor(n0), this.solrCores.getCoreDescriptor(n1));
        log.info("swapped: " + n0 + " with " + n1);
    }

    public void unload(String name) {
        this.unload(name, false, false, false);
    }

    public void unload(String name, boolean deleteIndexDir, boolean deleteDataDir, boolean deleteInstanceDir) {
        CoreLoadFailure loadFailure;
        CoreDescriptor cd = this.solrCores.getCoreDescriptor(name);
        if (name != null && (loadFailure = this.coreInitFailures.remove(name)) != null) {
            SolrCore.deleteUnloadedCore(loadFailure.cd, deleteDataDir, deleteInstanceDir);
            if (cd != null) {
                this.solrCores.removeCoreDescriptor(cd);
                this.coresLocator.delete(this, cd);
            }
            return;
        }
        if (cd == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Cannot unload non-existent core [" + name + "]");
        }
        boolean close = this.solrCores.isLoadedNotPendingClose(name);
        SolrCore core = this.solrCores.remove(name);
        this.solrCores.removeCoreDescriptor(cd);
        this.coresLocator.delete(this, cd);
        if (core == null) {
            SolrCore.deleteUnloadedCore(cd, deleteDataDir, deleteInstanceDir);
            return;
        }
        this.metricManager.removeRegistry(core.getCoreMetricManager().getRegistryName());
        if (this.zkSys.getZkController() != null) {
            core.getSolrCoreState().cancelRecovery();
            if (cd.getCloudDescriptor().getReplicaType() == Replica.Type.PULL || cd.getCloudDescriptor().getReplicaType() == Replica.Type.TLOG) {
                this.zkSys.getZkController().stopReplicationFromLeader(name);
            }
        }
        core.unloadOnClose(cd, deleteIndexDir, deleteDataDir, deleteInstanceDir);
        if (close) {
            core.closeAndWait();
        }
        if (this.zkSys.getZkController() != null) {
            try {
                this.zkSys.getZkController().unregister(name, cd);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Interrupted while unregistering core [" + name + "] from cloud state");
            }
            catch (KeeperException e) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error unregistering core [" + name + "] from cloud state", (Throwable)e);
            }
            catch (Exception e) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error unregistering core [" + name + "] from cloud state", (Throwable)e);
            }
        }
    }

    public void rename(String name, String toName) {
        SolrIdentifierValidator.validateCoreName((String)toName);
        try (SolrCore core = this.getCore(name);){
            if (core != null) {
                String oldRegistryName = core.getCoreMetricManager().getRegistryName();
                String newRegistryName = SolrCoreMetricManager.createRegistryName(core, toName);
                this.metricManager.swapRegistries(oldRegistryName, newRegistryName);
                CoreDescriptor cd = core.getCoreDescriptor();
                this.solrCores.removeCoreDescriptor(cd);
                cd.setProperty("name", toName);
                this.solrCores.addCoreDescriptor(cd);
                core.setName(toName);
                this.registerCore(cd, core, true, false);
                SolrCore old = this.solrCores.remove(name);
                this.coresLocator.rename(this, old.getCoreDescriptor(), core.getCoreDescriptor());
            }
        }
    }

    public List<CoreDescriptor> getCoreDescriptors() {
        return this.solrCores.getCoreDescriptors();
    }

    public CoreDescriptor getCoreDescriptor(String coreName) {
        return this.solrCores.getCoreDescriptor(coreName);
    }

    public Path getCoreRootDirectory() {
        return this.cfg.getCoreRootDirectory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SolrCore getCore(String name) {
        SolrCore core = this.solrCores.getCoreFromAnyList(name, true);
        if (core != null) {
            return core;
        }
        CoreDescriptor desc = this.solrCores.getCoreDescriptor(name);
        CoreLoadFailure loadFailure = this.getCoreInitFailures().get(name);
        if (null != loadFailure) {
            throw new SolrCoreInitializationException(name, loadFailure.exception);
        }
        if (desc == null || this.zkSys.getZkController() != null) {
            return null;
        }
        core = this.solrCores.waitAddPendingCoreOps(name);
        if (this.isShutDown) {
            return null;
        }
        try {
            if (core == null) {
                if (this.zkSys.getZkController() != null) {
                    this.zkSys.getZkController().throwErrorIfReplicaReplaced(desc);
                }
                core = this.createFromDescriptor(desc, true, false);
            }
            core.open();
        }
        finally {
            this.solrCores.removeFromPendingOps(name);
        }
        return core;
    }

    public BlobRepository getBlobRepository() {
        return this.blobRepository;
    }

    public void waitForLoadingCoresToFinish(long timeoutMs) {
        this.solrCores.waitForLoadingCoresToFinish(timeoutMs);
    }

    public void waitForLoadingCore(String name, long timeoutMs) {
        this.solrCores.waitForLoadingCoreToFinish(name, timeoutMs);
    }

    protected <T> T createHandler(String path, String handlerClass, Class<T> clazz) {
        T handler = this.loader.newInstance(handlerClass, clazz, null, new Class[]{CoreContainer.class}, new Object[]{this});
        if (handler instanceof SolrRequestHandler) {
            this.containerHandlers.put(path, (SolrRequestHandler)handler);
        }
        if (handler instanceof SolrMetricProducer) {
            ((SolrMetricProducer)handler).initializeMetrics(this.metricManager, SolrInfoBean.Group.node.toString(), this.metricTag, path);
        }
        return handler;
    }

    public CoreAdminHandler getMultiCoreHandler() {
        return this.coreAdminHandler;
    }

    public CollectionsHandler getCollectionsHandler() {
        return this.collectionsHandler;
    }

    public InfoHandler getInfoHandler() {
        return this.infoHandler;
    }

    public ConfigSetsHandler getConfigSetsHandler() {
        return this.configSetsHandler;
    }

    public String getHostName() {
        return this.hostName;
    }

    public String getManagementPath() {
        return this.cfg.getManagementPath();
    }

    public LogWatcher getLogging() {
        return this.logging;
    }

    public boolean isLoaded(String name) {
        return this.solrCores.isLoaded(name);
    }

    public boolean isLoadedNotPendingClose(String name) {
        return this.solrCores.isLoadedNotPendingClose(name);
    }

    public CoreDescriptor getUnloadedCoreDescriptor(String cname) {
        return this.solrCores.getUnloadedCoreDescriptor(cname);
    }

    public String getSolrHome() {
        return this.solrHome;
    }

    public boolean isZooKeeperAware() {
        return this.zkSys.getZkController() != null;
    }

    public ZkController getZkController() {
        return this.zkSys.getZkController();
    }

    public NodeConfig getConfig() {
        return this.cfg;
    }

    public ShardHandlerFactory getShardHandlerFactory() {
        return this.shardHandlerFactory;
    }

    public UpdateShardHandler getUpdateShardHandler() {
        return this.updateShardHandler;
    }

    public SolrResourceLoader getResourceLoader() {
        return this.loader;
    }

    public boolean isCoreLoading(String name) {
        return this.solrCores.isCoreLoading(name);
    }

    public AuthorizationPlugin getAuthorizationPlugin() {
        return this.authorizationPlugin == null ? null : (AuthorizationPlugin)this.authorizationPlugin.plugin;
    }

    public AuthenticationPlugin getAuthenticationPlugin() {
        return this.authenticationPlugin == null ? null : (AuthenticationPlugin)this.authenticationPlugin.plugin;
    }

    public NodeConfig getNodeConfig() {
        return this.cfg;
    }

    public long getStatus() {
        return this.status;
    }

    public TransientSolrCoreCache getTransientCache() {
        return this.solrCores.getTransientCacheHandler();
    }

    public boolean repairCoreProperty(CoreDescriptor cd, String prop) {
        if (!"coreNodeName".equals(prop)) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, String.format(Locale.ROOT, "The only supported property for repair is currently [%s]", "coreNodeName"));
        }
        String coreName = cd.getName();
        DocCollection coll = this.getZkController().getZkStateReader().getClusterState().getCollection(cd.getCollectionName());
        for (Replica rep : coll.getReplicas()) {
            if (!coreName.equals(rep.getCoreName())) continue;
            log.warn("Core properties file for node {} found with no coreNodeName, attempting to repair with value {}. See SOLR-11503. This message should only appear if upgrading from collections created Solr 6.6.1 through 7.1.", (Object)rep.getCoreName(), (Object)rep.getName());
            cd.getCloudDescriptor().setCoreNodeName(rep.getName());
            this.coresLocator.persist(this, cd);
            return true;
        }
        log.error("Could not repair coreNodeName in core.properties file for core {}", (Object)coreName);
        return false;
    }

    private static enum CoreInitFailedAction {
        fromleader,
        none;

    }

    public static class CoreLoadFailure {
        public final CoreDescriptor cd;
        public final Exception exception;

        public CoreLoadFailure(CoreDescriptor cd, Exception loadFailure) {
            this.cd = new CoreDescriptor(cd.getName(), cd);
            this.exception = loadFailure;
        }
    }
}

