/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud.autoscaling;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.solr.client.solrj.cloud.autoscaling.TriggerEventType;
import org.apache.solr.cloud.autoscaling.AutoScaling;
import org.apache.solr.cloud.autoscaling.TriggerBase;
import org.apache.solr.cloud.autoscaling.TriggerEvent;
import org.apache.solr.common.SolrException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeLostTrigger
extends TriggerBase {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private Set<String> lastLiveNodes = new HashSet<String>();
    private Map<String, Long> nodeNameVsTimeRemoved = new HashMap<String, Long>();

    public NodeLostTrigger(String name) {
        super(TriggerEventType.NODELOST, name);
    }

    @Override
    public void init() throws Exception {
        super.init();
        this.lastLiveNodes = new HashSet<String>(this.cloudManager.getClusterStateProvider().getLiveNodes());
        log.debug("NodeLostTrigger {} - Initial livenodes: {}", (Object)this.name, this.lastLiveNodes);
        try {
            List lost = this.stateManager.listData("/autoscaling/nodeLost");
            lost.forEach(n -> {
                if (!this.lastLiveNodes.contains(n)) {
                    log.debug("Adding lost node from marker path: {}", n);
                    this.nodeNameVsTimeRemoved.put((String)n, this.cloudManager.getTimeSource().getTimeNs());
                }
                this.removeMarker((String)n);
            });
        }
        catch (NoSuchElementException lost) {
        }
        catch (Exception e) {
            log.warn("Exception retrieving nodeLost markers", (Throwable)e);
        }
    }

    @Override
    public void restoreState(AutoScaling.Trigger old) {
        NodeLostTrigger that;
        assert (old.isClosed());
        if (old instanceof NodeLostTrigger) {
            that = (NodeLostTrigger)old;
            assert (this.name.equals(that.name));
        } else {
            throw new SolrException(SolrException.ErrorCode.INVALID_STATE, "Unable to restore state from an unknown type of trigger");
        }
        this.lastLiveNodes.clear();
        this.lastLiveNodes.addAll(that.lastLiveNodes);
        this.nodeNameVsTimeRemoved.clear();
        this.nodeNameVsTimeRemoved.putAll(that.nodeNameVsTimeRemoved);
    }

    @Override
    protected Map<String, Object> getState() {
        HashMap<String, Object> state = new HashMap<String, Object>();
        state.put("lastLiveNodes", this.lastLiveNodes);
        state.put("nodeNameVsTimeRemoved", this.nodeNameVsTimeRemoved);
        return state;
    }

    @Override
    protected void setState(Map<String, Object> state) {
        Map nodeNameVsTimeRemoved;
        this.lastLiveNodes.clear();
        this.nodeNameVsTimeRemoved.clear();
        Collection lastLiveNodes = (Collection)state.get("lastLiveNodes");
        if (lastLiveNodes != null) {
            this.lastLiveNodes.addAll(lastLiveNodes);
        }
        if ((nodeNameVsTimeRemoved = (Map)state.get("nodeNameVsTimeRemoved")) != null) {
            this.nodeNameVsTimeRemoved.putAll(nodeNameVsTimeRemoved);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            NodeLostTrigger nodeLostTrigger = this;
            synchronized (nodeLostTrigger) {
                if (this.isClosed) {
                    log.warn("NodeLostTrigger ran but was already closed");
                    return;
                }
            }
            HashSet newLiveNodes = new HashSet(this.cloudManager.getClusterStateProvider().getLiveNodes());
            log.debug("Running NodeLostTrigger: {} with currently live nodes: {}", (Object)this.name, (Object)newLiveNodes.size());
            Set<String> trackingKeySet = this.nodeNameVsTimeRemoved.keySet();
            trackingKeySet.removeAll(newLiveNodes);
            HashSet<String> copyOfLastLiveNodes = new HashSet<String>(this.lastLiveNodes);
            copyOfLastLiveNodes.removeAll(newLiveNodes);
            copyOfLastLiveNodes.forEach(n -> {
                log.debug("Tracking lost node: {}", n);
                this.nodeNameVsTimeRemoved.put((String)n, this.cloudManager.getTimeSource().getTimeNs());
            });
            ArrayList<String> nodeNames = new ArrayList<String>();
            ArrayList<Long> times = new ArrayList<Long>();
            for (Map.Entry<String, Long> entry : this.nodeNameVsTimeRemoved.entrySet()) {
                String nodeName = entry.getKey();
                Long timeRemoved = entry.getValue();
                long now = this.cloudManager.getTimeSource().getTimeNs();
                if (TimeUnit.SECONDS.convert(now - timeRemoved, TimeUnit.NANOSECONDS) < (long)this.getWaitForSecond()) continue;
                nodeNames.add(nodeName);
                times.add(timeRemoved);
            }
            AutoScaling.TriggerEventProcessor processor = (AutoScaling.TriggerEventProcessor)this.processorRef.get();
            if (!nodeNames.isEmpty()) {
                if (processor != null) {
                    log.debug("NodeLostTrigger firing registered processor for lost nodes: {}", nodeNames);
                    if (processor.process(new NodeLostEvent(this.getEventType(), this.getName(), times, nodeNames))) {
                        nodeNames.forEach(n -> {
                            this.nodeNameVsTimeRemoved.remove(n);
                            this.removeMarker((String)n);
                        });
                    } else {
                        log.debug("NodeLostTrigger processor for lost nodes: {} is not ready, will try later", nodeNames);
                    }
                } else {
                    nodeNames.forEach(n -> {
                        this.nodeNameVsTimeRemoved.remove(n);
                        this.removeMarker((String)n);
                    });
                }
            }
            this.lastLiveNodes = new HashSet<String>(newLiveNodes);
        }
        catch (RuntimeException e) {
            log.error("Unexpected exception in NodeLostTrigger", (Throwable)e);
        }
    }

    private void removeMarker(String nodeName) {
        String path = "/autoscaling/nodeLost/" + nodeName;
        try {
            if (this.stateManager.hasData(path)) {
                this.stateManager.removeData(path, -1);
            }
        }
        catch (NoSuchElementException noSuchElementException) {
        }
        catch (Exception e) {
            log.warn("Exception removing nodeLost marker " + nodeName, (Throwable)e);
        }
    }

    public static class NodeLostEvent
    extends TriggerEvent {
        public NodeLostEvent(TriggerEventType eventType, String source, List<Long> times, List<String> nodeNames) {
            super(eventType, source, times.get(0), null);
            this.properties.put("nodeNames", nodeNames);
            this.properties.put("eventTimes", times);
        }
    }
}

