/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud.api.collections;

import java.lang.invoke.MethodHandles;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.solr.client.solrj.cloud.autoscaling.PolicyHelper;
import org.apache.solr.cloud.Overseer;
import org.apache.solr.cloud.ZkDistributedQueue;
import org.apache.solr.cloud.api.collections.Assign;
import org.apache.solr.cloud.api.collections.OverseerCollectionMessageHandler;
import org.apache.solr.cloud.overseer.OverseerAction;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.ImplicitDocRouter;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.ReplicaPosition;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.params.CollectionParams;
import org.apache.solr.common.params.CoreAdminParams;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.common.util.Utils;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.backup.BackupManager;
import org.apache.solr.core.backup.repository.BackupRepository;
import org.apache.solr.handler.component.ShardHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestoreCmd
implements OverseerCollectionMessageHandler.Cmd {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final OverseerCollectionMessageHandler ocmh;

    public RestoreCmd(OverseerCollectionMessageHandler ocmh) {
        this.ocmh = ocmh;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void call(ClusterState state, ZkNodeProps message, NamedList results) throws Exception {
        String restoreCollectionName = message.getStr("collection");
        String backupName = message.getStr("name");
        ShardHandler shardHandler = this.ocmh.shardHandlerFactory.getShardHandler();
        String asyncId = message.getStr("async");
        String repo = message.getStr("repository");
        HashMap<String, String> requestMap = new HashMap<String, String>();
        CoreContainer cc = this.ocmh.overseer.getCoreContainer();
        BackupRepository repository = cc.newBackupRepository(Optional.ofNullable(repo));
        URI location = repository.createURI(message.getStr("location"));
        URI backupPath = repository.resolve(location, backupName);
        ZkStateReader zkStateReader = this.ocmh.zkStateReader;
        BackupManager backupMgr = new BackupManager(repository, zkStateReader);
        Properties properties = backupMgr.readBackupProperties(location, backupName);
        String backupCollection = properties.getProperty("collection");
        DocCollection backupCollectionState = backupMgr.readCollectionState(location, backupName, backupCollection);
        List<String> nodeList = Assign.getLiveOrLiveAndCreateNodeSetList(zkStateReader.getClusterState().getLiveNodes(), message, OverseerCollectionMessageHandler.RANDOM);
        int numShards = backupCollectionState.getActiveSlices().size();
        int numNrtReplicas = this.getInt(message, "nrtReplicas", backupCollectionState.getNumNrtReplicas(), 0);
        if (numNrtReplicas == 0) {
            numNrtReplicas = this.getInt(message, "replicationFactor", backupCollectionState.getReplicationFactor(), 0);
        }
        int numTlogReplicas = this.getInt(message, "tlogReplicas", backupCollectionState.getNumTlogReplicas(), 0);
        int numPullReplicas = this.getInt(message, "pullReplicas", backupCollectionState.getNumPullReplicas(), 0);
        int totalReplicasPerShard = numNrtReplicas + numTlogReplicas + numPullReplicas;
        int maxShardsPerNode = message.getInt("maxShardsPerNode", Integer.valueOf(backupCollectionState.getMaxShardsPerNode()));
        int availableNodeCount = nodeList.size();
        if (numShards * totalReplicasPerShard > availableNodeCount * maxShardsPerNode) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, String.format(Locale.ROOT, "Solr cloud with available number of nodes:%d is insufficient for restoring a collection with %d shards, total replicas per shard %d and maxShardsPerNode %d. Consider increasing maxShardsPerNode value OR number of available nodes.", availableNodeCount, numShards, totalReplicasPerShard, maxShardsPerNode));
        }
        String configName = (String)properties.get("collection.configName");
        String restoreConfigName = message.getStr("collection.configName", configName);
        if (zkStateReader.getConfigManager().configExists(restoreConfigName).booleanValue()) {
            log.info("Using existing config {}", (Object)restoreConfigName);
        } else {
            log.info("Uploading config {}", (Object)restoreConfigName);
            backupMgr.uploadConfigDir(location, backupName, configName, restoreConfigName);
        }
        log.info("Starting restore into collection={} with backup_name={} at location={}", new Object[]{restoreCollectionName, backupName, location});
        HashMap<String, Object> propMap = new HashMap<String, Object>();
        propMap.put("operation", CollectionParams.CollectionAction.CREATE.toString());
        propMap.put("fromApi", "true");
        if (properties.get("stateFormat") == null) {
            propMap.put("stateFormat", "2");
        }
        for (String string : OverseerCollectionMessageHandler.COLL_PROPS.keySet()) {
            Object object = message.getProperties().getOrDefault(string, backupCollectionState.get(string));
            if (object == null) continue;
            propMap.put(string, object);
        }
        propMap.put("name", restoreCollectionName);
        propMap.put("createNodeSet", "EMPTY");
        propMap.put("collection.configName", restoreConfigName);
        Map routerProps = (Map)backupCollectionState.getProperties().get("router");
        for (Map.Entry entry : routerProps.entrySet()) {
            propMap.put("router." + (String)entry.getKey(), entry.getValue());
        }
        Set set = backupCollectionState.getActiveSlicesMap().keySet();
        if (backupCollectionState.getRouter() instanceof ImplicitDocRouter) {
            propMap.put("shards", StrUtils.join(set, (char)','));
        } else {
            propMap.put("numShards", set.size());
            Collection collection = backupCollectionState.getActiveSlices();
            LinkedHashMap<String, Slice> newSlices = new LinkedHashMap<String, Slice>(collection.size());
            for (Slice backupSlice : collection) {
                newSlices.put(backupSlice.getName(), new Slice(backupSlice.getName(), Collections.emptyMap(), backupSlice.getProperties()));
            }
            propMap.put("shards", newSlices);
        }
        this.ocmh.commandMap.get(CollectionParams.CollectionAction.CREATE).call(zkStateReader.getClusterState(), new ZkNodeProps(propMap), new NamedList());
        backupMgr.uploadCollectionProperties(location, backupName, restoreCollectionName);
        DocCollection restoreCollection = zkStateReader.getClusterState().getCollection(restoreCollectionName);
        ZkDistributedQueue inQueue = Overseer.getStateUpdateQueue(zkStateReader.getZkClient());
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("operation", OverseerAction.UPDATESHARDSTATE.toLower());
        for (Slice shard : restoreCollection.getSlices()) {
            hashMap.put(shard.getName(), Slice.State.CONSTRUCTION.toString());
        }
        hashMap.put("collection", restoreCollectionName);
        inQueue.offer(Utils.toJSON((Object)new ZkNodeProps(hashMap)));
        ClusterState clusterState = zkStateReader.getClusterState();
        ArrayList<String> arrayList = new ArrayList<String>();
        restoreCollection.getSlices().forEach(x -> sliceNames2.add(x.getName()));
        PolicyHelper.SessionWrapper sessionWrapper = null;
        CountDownLatch countDownLatch = new CountDownLatch(restoreCollection.getSlices().size());
        try {
            List<ReplicaPosition> replicaPositions = Assign.identifyNodes(this.ocmh.cloudManager, clusterState, nodeList, restoreCollectionName, message, arrayList, numNrtReplicas, numTlogReplicas, numPullReplicas);
            sessionWrapper = PolicyHelper.getLastSessionWrapper((boolean)true);
            for (Slice slice : restoreCollection.getSlices()) {
                log.debug("Adding replica for shard={} collection={} ", (Object)slice.getName(), (Object)restoreCollection);
                Iterator propMap3 = new HashMap<String, Object>();
                ((HashMap)((Object)propMap3)).put("operation", CollectionParams.CollectionAction.CREATESHARD);
                ((HashMap)((Object)propMap3)).put("collection", restoreCollectionName);
                ((HashMap)((Object)propMap3)).put("shard", slice.getName());
                if (numNrtReplicas >= 1) {
                    ((HashMap)((Object)propMap3)).put("type", Replica.Type.NRT.name());
                } else if (numTlogReplicas >= 1) {
                    ((HashMap)((Object)propMap3)).put("type", Replica.Type.TLOG.name());
                } else {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unexpected number of replicas, replicationFactor, " + Replica.Type.NRT + " or " + Replica.Type.TLOG + " must be greater than 0");
                }
                for (ReplicaPosition replicaPosition : replicaPositions) {
                    if (!Objects.equals(replicaPosition.shard, slice.getName())) continue;
                    String node = replicaPosition.node;
                    ((HashMap)((Object)propMap3)).put("node", node);
                    replicaPositions.remove(replicaPosition);
                    break;
                }
                if (asyncId != null) {
                    ((HashMap)((Object)propMap3)).put("async", asyncId);
                }
                this.ocmh.addPropertyParams(message, (Map<String, Object>)((Object)propMap3));
                NamedList addResult = new NamedList();
                this.ocmh.addReplica(clusterState, new ZkNodeProps(propMap3), addResult, () -> {
                    countDownLatch.countDown();
                    Object addResultFailure = addResult.get("failure");
                    if (addResultFailure != null) {
                        SimpleOrderedMap failure = (SimpleOrderedMap)results.get("failure");
                        if (failure == null) {
                            failure = new SimpleOrderedMap();
                            results.add("failure", (Object)failure);
                        }
                        failure.addAll((NamedList)addResultFailure);
                    } else {
                        SimpleOrderedMap success = (SimpleOrderedMap)results.get("success");
                        if (success == null) {
                            success = new SimpleOrderedMap();
                            results.add("success", (Object)success);
                        }
                        success.addAll((NamedList)addResult.get("success"));
                    }
                });
            }
            boolean allIsDone = countDownLatch.await(10L, TimeUnit.MINUTES);
            if (!allIsDone) {
                throw new TimeoutException("Initial replicas were not created within 10 minutes. Timing out.");
            }
            Object failures = results.get("failure");
            if (failures != null && ((SimpleOrderedMap)failures).size() > 0) {
                log.error("Restore failed to create initial replicas.");
                this.ocmh.cleanupCollection(restoreCollectionName, new NamedList());
                return;
            }
            restoreCollection = zkStateReader.getClusterState().getCollection(restoreCollectionName);
            for (Slice slice : restoreCollection.getSlices()) {
                ModifiableSolrParams params = new ModifiableSolrParams();
                params.set("action", new String[]{CoreAdminParams.CoreAdminAction.RESTORECORE.toString()});
                params.set("name", new String[]{"snapshot." + slice.getName()});
                params.set("location", new String[]{backupPath.toASCIIString()});
                params.set("repository", new String[]{repo});
                this.ocmh.sliceCmd(clusterState, params, null, slice, shardHandler, asyncId, requestMap);
            }
            this.ocmh.processResponses(new NamedList(), shardHandler, true, "Could not restore core", asyncId, requestMap);
            for (Object s : restoreCollection.getSlices()) {
                for (Replica r : s.getReplicas()) {
                    String nodeName = r.getNodeName();
                    String coreNodeName = r.getCoreName();
                    Replica.State stateRep = r.getState();
                    log.debug("Calling REQUESTAPPLYUPDATES on: nodeName={}, coreNodeName={}, state={}", new Object[]{nodeName, coreNodeName, stateRep.name()});
                    ModifiableSolrParams params = new ModifiableSolrParams();
                    params.set("action", new String[]{CoreAdminParams.CoreAdminAction.REQUESTAPPLYUPDATES.toString()});
                    params.set("name", new String[]{coreNodeName});
                    this.ocmh.sendShardRequest(nodeName, params, shardHandler, asyncId, requestMap);
                }
                this.ocmh.processResponses(new NamedList(), shardHandler, true, "REQUESTAPPLYUPDATES calls did not succeed", asyncId, requestMap);
            }
            HashMap<String, String> propMap2 = new HashMap<String, String>();
            propMap2.put("operation", OverseerAction.UPDATESHARDSTATE.toLower());
            propMap2.put("collection", restoreCollectionName);
            for (Slice shard : restoreCollection.getSlices()) {
                propMap2.put(shard.getName(), Slice.State.ACTIVE.toString());
            }
            inQueue.offer(Utils.toJSON((Object)new ZkNodeProps(propMap2)));
            if (totalReplicasPerShard > 1) {
                log.info("Adding replicas to restored collection={}", (Object)restoreCollection);
                for (Slice slice : restoreCollection.getSlices()) {
                    int createdNrtReplicas = 0;
                    int createdTlogReplicas = 0;
                    int createdPullReplicas = 0;
                    if (numNrtReplicas > 0) {
                        ++createdNrtReplicas;
                    } else if (createdTlogReplicas > 0) {
                        ++createdTlogReplicas;
                    }
                    for (int i = 1; i < totalReplicasPerShard; ++i) {
                        Replica.Type typeToCreate;
                        if (createdNrtReplicas < numNrtReplicas) {
                            ++createdNrtReplicas;
                            typeToCreate = Replica.Type.NRT;
                        } else if (createdTlogReplicas < numTlogReplicas) {
                            ++createdTlogReplicas;
                            typeToCreate = Replica.Type.TLOG;
                        } else {
                            typeToCreate = Replica.Type.PULL;
                            assert (++createdPullReplicas <= numPullReplicas) : "Unexpected number of replicas";
                        }
                        log.debug("Adding replica for shard={} collection={} of type {} ", new Object[]{slice.getName(), restoreCollection, typeToCreate});
                        HashMap<String, Object> propMap4 = new HashMap<String, Object>();
                        propMap4.put("collection", restoreCollectionName);
                        propMap4.put("shard", slice.getName());
                        propMap4.put("type", typeToCreate.name());
                        for (ReplicaPosition replicaPosition : replicaPositions) {
                            if (!Objects.equals(replicaPosition.shard, slice.getName())) continue;
                            String node = replicaPosition.node;
                            propMap4.put("node", node);
                            replicaPositions.remove(replicaPosition);
                            break;
                        }
                        if (asyncId != null) {
                            propMap4.put("async", asyncId);
                        }
                        this.ocmh.addPropertyParams(message, propMap4);
                        this.ocmh.addReplica(zkStateReader.getClusterState(), new ZkNodeProps(propMap4), results, null);
                    }
                }
            }
            log.info("Completed restoring collection={} backupName={}", (Object)restoreCollection, (Object)backupName);
        }
        finally {
            if (sessionWrapper != null) {
                sessionWrapper.release();
            }
        }
    }

    private int getInt(ZkNodeProps message, String propertyName, Integer count, int defaultValue) {
        Integer value = message.getInt(propertyName, count);
        return value != null ? value : defaultValue;
    }
}

