/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud.api.collections;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.solr.client.solrj.cloud.SolrCloudManager;
import org.apache.solr.client.solrj.cloud.autoscaling.PolicyHelper;
import org.apache.solr.cloud.ActiveReplicaWatcher;
import org.apache.solr.cloud.api.collections.Assign;
import org.apache.solr.cloud.api.collections.DeleteNodeCmd;
import org.apache.solr.cloud.api.collections.LeaderRecoveryWatcher;
import org.apache.solr.cloud.api.collections.OverseerCollectionMessageHandler;
import org.apache.solr.common.SolrCloseable;
import org.apache.solr.common.SolrCloseableLatch;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.CollectionStateWatcher;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.util.NamedList;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplaceNodeCmd
implements OverseerCollectionMessageHandler.Cmd {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final OverseerCollectionMessageHandler ocmh;

    public ReplaceNodeCmd(OverseerCollectionMessageHandler ocmh) {
        this.ocmh = ocmh;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void call(ClusterState state, ZkNodeProps message, NamedList results) throws Exception {
        ZkStateReader zkStateReader = this.ocmh.zkStateReader;
        String source = message.getStr("sourceNode", message.getStr("source"));
        String target = message.getStr("targetNode", message.getStr("target"));
        boolean waitForFinalState = message.getBool("waitForFinalState", false);
        if (source == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "sourceNode is a required param");
        }
        String async = message.getStr("async");
        int timeout = message.getInt("timeout", Integer.valueOf(600));
        boolean parallel = message.getBool("parallel", false);
        ClusterState clusterState = zkStateReader.getClusterState();
        if (!clusterState.liveNodesContain(source)) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Source Node: " + source + " is not live");
        }
        if (target != null && !clusterState.liveNodesContain(target)) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Target Node: " + target + " is not live");
        }
        List<ZkNodeProps> sourceReplicas = ReplaceNodeCmd.getReplicasOfNode(source, clusterState);
        int numLeaders = 0;
        for (ZkNodeProps props : sourceReplicas) {
            if (!props.getBool("leader", false) && !waitForFinalState) continue;
            ++numLeaders;
        }
        HashMap<String, ActiveReplicaWatcher> watchers = new HashMap<String, ActiveReplicaWatcher>();
        ArrayList<ZkNodeProps> createdReplicas = new ArrayList<ZkNodeProps>();
        AtomicBoolean anyOneFailed = new AtomicBoolean(false);
        SolrCloseableLatch countDownLatch = new SolrCloseableLatch(sourceReplicas.size(), (SolrCloseable)this.ocmh);
        SolrCloseableLatch replicasToRecover = new SolrCloseableLatch(numLeaders, (SolrCloseable)this.ocmh);
        AtomicReference<PolicyHelper.SessionWrapper> sessionWrapperRef = new AtomicReference<PolicyHelper.SessionWrapper>();
        try {
            for (ZkNodeProps zkNodeProps : sourceReplicas) {
                ZkNodeProps addedReplica;
                NamedList nl = new NamedList();
                log.info("Going to create replica for collection={} shard={} on node={}", new Object[]{zkNodeProps.getStr("collection"), zkNodeProps.getStr("shard"), target});
                String targetNode = target;
                if (targetNode == null) {
                    Replica.Type replicaType = Replica.Type.get((String)zkNodeProps.getStr("type"));
                    targetNode = Assign.identifyNodes((SolrCloudManager)this.ocmh.cloudManager, (ClusterState)clusterState, new ArrayList<String>(this.ocmh.cloudManager.getClusterStateProvider().getLiveNodes()), (String)zkNodeProps.getStr((String)"collection"), (ZkNodeProps)message, Collections.singletonList(zkNodeProps.getStr((String)"shard")), (int)(replicaType == Replica.Type.NRT ? 1 : 0), (int)(replicaType == Replica.Type.TLOG ? 1 : 0), (int)(replicaType == Replica.Type.PULL ? 1 : 0)).get((int)0).node;
                    sessionWrapperRef.set(PolicyHelper.getLastSessionWrapper((boolean)true));
                }
                ZkNodeProps msg = zkNodeProps.plus("parallel", (Object)String.valueOf(parallel)).plus("node", (Object)targetNode);
                if (async != null) {
                    msg.getProperties().put("async", async);
                }
                if ((addedReplica = this.ocmh.addReplica(clusterState, msg, nl, () -> {
                    countDownLatch.countDown();
                    if (nl.get("failure") != null) {
                        String errorString = String.format(Locale.ROOT, "Failed to create replica for collection=%s shard=%s on node=%s", sourceReplica.getStr("collection"), sourceReplica.getStr("shard"), target);
                        log.warn(errorString);
                        NamedList namedList = results;
                        synchronized (namedList) {
                            results.add("failure", (Object)errorString);
                            anyOneFailed.set(true);
                        }
                    } else {
                        log.debug("Successfully created replica for collection={} shard={} on node={}", new Object[]{sourceReplica.getStr("collection"), sourceReplica.getStr("shard"), target});
                    }
                })) == null) continue;
                createdReplicas.add(addedReplica);
                if (zkNodeProps.getBool("leader", false) || waitForFinalState) {
                    String shardName = zkNodeProps.getStr("shard");
                    String replicaName = zkNodeProps.getStr("replica");
                    String collectionName = zkNodeProps.getStr("collection");
                    String key = collectionName + "_" + replicaName;
                    Object watcher = waitForFinalState ? new ActiveReplicaWatcher(collectionName, null, Collections.singletonList(addedReplica.getStr("core")), replicasToRecover) : new LeaderRecoveryWatcher(collectionName, shardName, replicaName, addedReplica.getStr("core"), replicasToRecover);
                    watchers.put(key, (ActiveReplicaWatcher)watcher);
                    log.debug("--- adding " + key + ", " + watcher);
                    zkStateReader.registerCollectionStateWatcher(collectionName, (CollectionStateWatcher)watcher);
                    continue;
                }
                log.debug("--- not waiting for " + addedReplica);
            }
            log.debug("Waiting for replicas to be added");
            if (!countDownLatch.await((long)timeout, TimeUnit.SECONDS)) {
                log.info("Timed out waiting for replicas to be added");
                anyOneFailed.set(true);
            } else {
                log.debug("Finished waiting for replicas to be added");
            }
        }
        finally {
            PolicyHelper.SessionWrapper sw = (PolicyHelper.SessionWrapper)sessionWrapperRef.get();
            if (sw != null) {
                sw.release();
            }
        }
        log.debug("Waiting for " + numLeaders + " leader replicas to recover");
        if (!replicasToRecover.await((long)timeout, TimeUnit.SECONDS)) {
            log.info("Timed out waiting for " + replicasToRecover.getCount() + " leader replicas to recover");
            anyOneFailed.set(true);
        } else {
            log.debug("Finished waiting for leader replicas to recover");
        }
        for (Map.Entry entry : watchers.entrySet()) {
            zkStateReader.removeCollectionStateWatcher((String)entry.getKey(), (CollectionStateWatcher)entry.getValue());
        }
        if (anyOneFailed.get()) {
            log.info("Failed to create some replicas. Cleaning up all replicas on target node");
            SolrCloseableLatch cleanupLatch = new SolrCloseableLatch(createdReplicas.size(), (SolrCloseable)this.ocmh);
            for (ZkNodeProps createdReplica : createdReplicas) {
                NamedList deleteResult = new NamedList();
                try {
                    this.ocmh.deleteReplica(zkStateReader.getClusterState(), createdReplica.plus("parallel", (Object)"true"), deleteResult, () -> {
                        cleanupLatch.countDown();
                        if (deleteResult.get("failure") != null) {
                            NamedList namedList = results;
                            synchronized (namedList) {
                                results.add("failure", (Object)("Could not cleanup, because of : " + deleteResult.get("failure")));
                            }
                        }
                    });
                }
                catch (KeeperException e) {
                    cleanupLatch.countDown();
                    log.warn("Error deleting replica ", (Throwable)e);
                }
                catch (Exception e) {
                    log.warn("Error deleting replica ", (Throwable)e);
                    cleanupLatch.countDown();
                    throw e;
                }
            }
            cleanupLatch.await(5L, TimeUnit.MINUTES);
            return;
        }
        DeleteNodeCmd.cleanupReplicas(results, state, sourceReplicas, this.ocmh, source, async);
        results.add("success", (Object)("REPLACENODE action completed successfully from  : " + source + " to : " + target));
    }

    static List<ZkNodeProps> getReplicasOfNode(String source, ClusterState state) {
        ArrayList<ZkNodeProps> sourceReplicas = new ArrayList<ZkNodeProps>();
        for (Map.Entry e : state.getCollectionsMap().entrySet()) {
            for (Slice slice : ((DocCollection)e.getValue()).getSlices()) {
                for (Replica replica : slice.getReplicas()) {
                    if (!source.equals(replica.getNodeName())) continue;
                    ZkNodeProps props = new ZkNodeProps(new String[]{"collection", (String)e.getKey(), "shard", slice.getName(), "core", replica.getCoreName(), "replica", replica.getName(), "type", replica.getType().name(), "leader", String.valueOf(replica.equals((Object)slice.getLeader())), "node", source});
                    sourceReplicas.add(props);
                }
            }
        }
        return sourceReplicas;
    }
}

