/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.SocketTimeoutException;
import java.nio.channels.ClosedChannelException;
import java.util.concurrent.TimeoutException;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HBaseIOException;
import org.apache.hadoop.hbase.exceptions.ConnectionClosedException;
import org.apache.hadoop.hbase.exceptions.ConnectionClosingException;
import org.apache.hadoop.hbase.exceptions.TimeoutIOException;
import org.apache.hadoop.hbase.ipc.Call;
import org.apache.hadoop.hbase.ipc.CallCancelledException;
import org.apache.hadoop.hbase.ipc.CallTimeoutException;
import org.apache.hadoop.hbase.ipc.FatalConnectionException;
import org.apache.hadoop.hbase.ipc.RemoteWithExtrasException;
import org.apache.hadoop.hbase.ipc.ServerTooBusyException;
import org.apache.hadoop.hbase.shaded.protobuf.generated.RPCProtos;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hbase.thirdparty.com.google.common.base.Preconditions;
import org.apache.hbase.thirdparty.com.google.protobuf.CodedOutputStream;
import org.apache.hbase.thirdparty.com.google.protobuf.Message;
import org.apache.hbase.thirdparty.io.netty.buffer.ByteBuf;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
class IPCUtil {
    IPCUtil() {
    }

    public static int write(OutputStream dos, Message header, Message param, ByteBuf cellBlock) throws IOException {
        int totalSize = IPCUtil.getTotalSizeWhenWrittenDelimited(header, param);
        if (cellBlock != null) {
            totalSize += cellBlock.readableBytes();
        }
        return IPCUtil.write(dos, header, param, cellBlock, totalSize);
    }

    private static int write(OutputStream dos, Message header, Message param, ByteBuf cellBlock, int totalSize) throws IOException {
        dos.write(Bytes.toBytes((int)totalSize));
        header.writeDelimitedTo(dos);
        if (param != null) {
            param.writeDelimitedTo(dos);
        }
        if (cellBlock != null) {
            cellBlock.readBytes(dos, cellBlock.readableBytes());
        }
        dos.flush();
        return totalSize;
    }

    public static int getTotalSizeWhenWrittenDelimited(Message ... messages) {
        int totalSize = 0;
        for (Message m : messages) {
            if (m == null) continue;
            totalSize += m.getSerializedSize();
            totalSize += CodedOutputStream.computeUInt32SizeNoTag((int)m.getSerializedSize());
        }
        Preconditions.checkArgument((totalSize < Integer.MAX_VALUE ? 1 : 0) != 0);
        return totalSize;
    }

    static RPCProtos.RequestHeader buildRequestHeader(Call call, RPCProtos.CellBlockMeta cellBlockMeta) {
        RPCProtos.RequestHeader.Builder builder = RPCProtos.RequestHeader.newBuilder();
        builder.setCallId(call.id);
        builder.setMethodName(call.md.getName());
        builder.setRequestParam(call.param != null);
        if (cellBlockMeta != null) {
            builder.setCellBlockMeta(cellBlockMeta);
        }
        if (call.priority != -1) {
            builder.setPriority(call.priority);
        }
        builder.setTimeout(call.timeout);
        return builder.build();
    }

    static RemoteException createRemoteException(RPCProtos.ExceptionResponse e) {
        String innerExceptionClassName = e.getExceptionClassName();
        boolean doNotRetry = e.getDoNotRetry();
        return e.hasHostname() ? new RemoteWithExtrasException(innerExceptionClassName, e.getStackTrace(), e.getHostname(), e.getPort(), doNotRetry) : new RemoteWithExtrasException(innerExceptionClassName, e.getStackTrace(), doNotRetry);
    }

    static boolean isFatalConnectionException(RPCProtos.ExceptionResponse e) {
        return e.getExceptionClassName().equals(FatalConnectionException.class.getName());
    }

    static IOException toIOE(Throwable t) {
        if (t instanceof IOException) {
            return (IOException)t;
        }
        return new IOException(t);
    }

    static IOException wrapException(InetSocketAddress addr, Throwable error) {
        if (error instanceof ConnectException) {
            return (IOException)new ConnectException("Call to " + addr + " failed on connection exception: " + error).initCause(error);
        }
        if (error instanceof SocketTimeoutException) {
            return (IOException)new SocketTimeoutException("Call to " + addr + " failed because " + error).initCause(error);
        }
        if (error instanceof ConnectionClosingException) {
            return (IOException)new ConnectionClosingException("Call to " + addr + " failed on local exception: " + error).initCause(error);
        }
        if (error instanceof ServerTooBusyException) {
            return (IOException)error;
        }
        if (error instanceof DoNotRetryIOException) {
            try {
                return (IOException)error.getClass().asSubclass(DoNotRetryIOException.class).getConstructor(String.class).newInstance("Call to " + addr + " failed on local exception: " + error).initCause(error);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
                return (IOException)new DoNotRetryIOException("Call to " + addr + " failed on local exception: " + error).initCause(error);
            }
        }
        if (error instanceof ConnectionClosedException) {
            return (IOException)new ConnectionClosedException("Call to " + addr + " failed on local exception: " + error).initCause(error);
        }
        if (error instanceof CallTimeoutException) {
            return (IOException)new CallTimeoutException("Call to " + addr + " failed on local exception: " + error).initCause(error);
        }
        if (error instanceof ClosedChannelException) {
            return (IOException)error;
        }
        if (error instanceof TimeoutException) {
            return (IOException)new TimeoutIOException("Call to " + addr + " failed on local exception: " + error).initCause(error);
        }
        if (error instanceof IOException) {
            try {
                return (IOException)error.getClass().asSubclass(IOException.class).getConstructor(String.class).newInstance("Call to " + addr + " failed on local exception: " + error).initCause(error);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
                // empty catch block
            }
        }
        return (IOException)new HBaseIOException("Call to " + addr + " failed on local exception: " + error).initCause(error);
    }

    static void setCancelled(Call call) {
        call.setException((IOException)((Object)new CallCancelledException("Call id=" + call.id + ", waitTime=" + (EnvironmentEdgeManager.currentTime() - call.getStartTime()) + ", rpcTimeout=" + call.timeout)));
    }
}

