/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.component;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Multimap;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.handler.component.CachingUserAttributeSource;
import org.apache.solr.handler.component.DocAuthorizationComponent;
import org.apache.solr.handler.component.FieldToAttributeMapping;
import org.apache.solr.handler.component.ResponseBuilder;
import org.apache.solr.handler.component.UserAttributeSource;
import org.apache.solr.handler.component.UserAttributeSourceParams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolrAttrBasedFilter
extends DocAuthorizationComponent {
    private static final Logger LOG = LoggerFactory.getLogger(SolrAttrBasedFilter.class);
    public static final String CACHE_ENABLED_PROP = "cache_enabled";
    public static final boolean CACHE_ENABLED_DEFAULT = false;
    public static final String CACHE_TTL_PROP = "cache_ttl_seconds";
    public static final long CACHE_TTL_DEFAULT = 30L;
    public static final String CACHE_MAX_SIZE_PROP = "cache_max_size";
    public static final long CACHE_MAX_SIZE_DEFAULT = 1000L;
    public static final String ENABLED_PROP = "enabled";
    public static final String FIELD_ATTR_MAPPINGS = "field_attr_mappings";
    public static final String USER_ATTRIBUTE_SOURCE_CLASSNAME = "userAttributeSource";
    public static final String USER_ATTRIBUTE_SOURCE_CLASSNAME_DEFAULT = "org.apache.solr.handler.component.LdapUserAttributeSource";
    public static final String FIELD_FILTER_TYPE = "filter_type";
    public static final String ATTR_NAMES = "attr_names";
    public static final String PERMIT_EMPTY_VALUES = "permit_empty";
    public static final String ALL_USERS_VALUE = "all_users_value";
    public static final String ATTRIBUTE_FILTER_REGEX = "value_filter_regex";
    public static final String AND_OP_QPARSER = "andQParser";
    public static final String EXTRA_OPTS = "extra_opts";
    private List<FieldToAttributeMapping> fieldAttributeMappings = new LinkedList<FieldToAttributeMapping>();
    private String andQParserName;
    private UserAttributeSource userAttributeSource;
    private boolean enabled = false;

    public void init(NamedList args) {
        LOG.debug("Initializing {}", (Object)((Object)((Object)this)).getClass().getSimpleName());
        SolrParams solrParams = args.toSolrParams();
        if (args.getBooleanArg(ENABLED_PROP) != null) {
            this.enabled = args.getBooleanArg(ENABLED_PROP);
        }
        NamedList mappings = (NamedList)this.checkAndGet(args, FIELD_ATTR_MAPPINGS);
        for (Map.Entry entry : mappings) {
            String solrFieldName = (String)entry.getKey();
            String attributeNames = (String)this.checkAndGet((NamedList)entry.getValue(), ATTR_NAMES);
            String filterType = (String)this.checkAndGet((NamedList)entry.getValue(), FIELD_FILTER_TYPE);
            boolean acceptEmpty = false;
            if (((NamedList)entry.getValue()).getBooleanArg(PERMIT_EMPTY_VALUES) != null) {
                acceptEmpty = ((NamedList)entry.getValue()).getBooleanArg(PERMIT_EMPTY_VALUES);
            }
            String allUsersValue = this.getWithDefault((NamedList)entry.getValue(), ALL_USERS_VALUE, "");
            String regex = this.getWithDefault((NamedList)entry.getValue(), ATTRIBUTE_FILTER_REGEX, "");
            String extraOpts = this.getWithDefault((NamedList)entry.getValue(), EXTRA_OPTS, "");
            FieldToAttributeMapping mapping = new FieldToAttributeMapping(solrFieldName, attributeNames, filterType, acceptEmpty, allUsersValue, regex, extraOpts);
            this.fieldAttributeMappings.add(mapping);
        }
        if (this.userAttributeSource == null) {
            this.userAttributeSource = solrParams.getBool(CACHE_ENABLED_PROP, false) ? new CachingUserAttributeSource(this.buildUserAttributeSource(solrParams), solrParams.getLong(CACHE_TTL_PROP, 30L), solrParams.getLong(CACHE_MAX_SIZE_PROP, 1000L)) : this.buildUserAttributeSource(solrParams);
        }
        this.andQParserName = ((String)this.checkAndGet(args, AND_OP_QPARSER)).trim();
    }

    private UserAttributeSource buildUserAttributeSource(SolrParams solrParams) {
        LinkedList<String> combinedAttributes = new LinkedList<String>();
        for (FieldToAttributeMapping mapping : this.fieldAttributeMappings) {
            combinedAttributes.addAll(mapping.getAttributes());
        }
        String userAttributeSourceClassname = solrParams.get(USER_ATTRIBUTE_SOURCE_CLASSNAME, USER_ATTRIBUTE_SOURCE_CLASSNAME_DEFAULT);
        try {
            Class<?> userAttributeSoureClass = Class.forName(userAttributeSourceClassname);
            UserAttributeSource attributeSource = (UserAttributeSource)userAttributeSoureClass.newInstance();
            Class<? extends UserAttributeSourceParams> attributeSourceParamsClass = attributeSource.getParamsClass();
            UserAttributeSourceParams uaParams = attributeSourceParamsClass.newInstance();
            uaParams.init(solrParams);
            attributeSource.init(uaParams, combinedAttributes);
            return attributeSource;
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "User Attribute Source Class misconfigured", (Throwable)e);
        }
    }

    @Override
    public void prepare(ResponseBuilder rb, String userName) throws IOException {
        ModifiableSolrParams params = new ModifiableSolrParams(rb.req.getParams());
        Multimap<String, String> userAttributes = this.userAttributeSource.getAttributesForUser(userName);
        for (FieldToAttributeMapping mapping : this.fieldAttributeMappings) {
            String filterQuery = this.buildFilterQueryString(userAttributes, mapping);
            LOG.debug("Adding filter clause : {}", (Object)filterQuery);
            params.add("fq", new String[]{filterQuery});
        }
        rb.req.setParams((SolrParams)params);
    }

    private String buildFilterQueryString(Multimap<String, String> userAttributes, FieldToAttributeMapping mapping) {
        String fieldName = mapping.getFieldName();
        Collection<String> attributeValues = SolrAttrBasedFilter.getUserAttributesForField(userAttributes, mapping);
        switch (mapping.getFilterType()) {
            case OR: {
                return this.buildSimpleORFilterQuery(fieldName, attributeValues, mapping.getAcceptEmpty(), mapping.getAllUsersValue(), mapping.getExtraOpts());
            }
            case AND: {
                return this.buildSubsetFilterQuery(fieldName, attributeValues, mapping.getAcceptEmpty(), mapping.getAllUsersValue(), mapping.getExtraOpts());
            }
            case GTE: {
                return this.buildGreaterThanFilterQuery(fieldName, attributeValues, mapping.getAcceptEmpty(), mapping.getAllUsersValue(), mapping.getExtraOpts());
            }
            case LTE: {
                return this.buildLessThanFilterQuery(fieldName, attributeValues, mapping.getAcceptEmpty(), mapping.getAllUsersValue(), mapping.getExtraOpts());
            }
        }
        return null;
    }

    @VisibleForTesting
    static Collection<String> getUserAttributesForField(Multimap<String, String> userAttributes, FieldToAttributeMapping mapping) {
        HashSet<String> userAttributesSubset = new HashSet<String>();
        Pattern regex = mapping.getAttrValueRegex();
        for (String attributeName : mapping.getAttributes()) {
            if (regex != null && regex.pattern().length() > 0) {
                for (String value : userAttributes.get((Object)attributeName)) {
                    String group = null;
                    Matcher matcher = regex.matcher(value);
                    if (matcher.find()) {
                        for (int i = matcher.groupCount(); i >= 0 && (group = matcher.group(i)) == null; --i) {
                        }
                    }
                    if (group == null) continue;
                    userAttributesSubset.add(group);
                }
                continue;
            }
            userAttributesSubset.addAll(userAttributes.get((Object)attributeName));
        }
        return userAttributesSubset;
    }

    private String buildSimpleORFilterQuery(String fieldName, Collection<String> attributeValues, boolean allowEmptyField, String allUsersValue, String extraOpts) {
        StringBuilder s = new StringBuilder();
        for (String attributeValue : attributeValues) {
            s.append(fieldName).append(":\"").append(attributeValue).append("\" ");
        }
        if (allUsersValue != null && !allUsersValue.equals("")) {
            s.append(fieldName).append(":\"").append(allUsersValue).append("\" ");
        }
        if (allowEmptyField) {
            s.append("(*:* AND -").append(fieldName).append(":*) ");
        }
        if (extraOpts != null && !extraOpts.equals("")) {
            s.append(extraOpts + " ");
        }
        s.deleteCharAt(s.length() - 1);
        return s.toString();
    }

    private String buildSubsetFilterQuery(String fieldName, Collection<String> attributeValues, boolean allowEmptyField, String allUsersValue, String extraOpts) {
        StringBuilder s = new StringBuilder();
        s.append("{!").append(this.andQParserName).append(" set_field=").append(fieldName).append(" set_value=").append(Joiner.on((char)',').join(attributeValues));
        if (allUsersValue != null && !allUsersValue.equals("")) {
            s.append(" wildcard_token=").append(allUsersValue);
        }
        if (allowEmptyField) {
            s.append(" allow_missing_val=true");
        } else {
            s.append(" allow_missing_val=false");
        }
        if (extraOpts != null && !extraOpts.equals("")) {
            s.append(" " + extraOpts);
        }
        s.append("}");
        return s.toString();
    }

    private String buildGreaterThanFilterQuery(String fieldName, Collection<String> attributeValues, boolean allowEmptyField, String allUsersValue, String extraOpts) {
        String value;
        if (attributeValues.size() == 1) {
            value = attributeValues.iterator().next();
        } else if (allUsersValue != null && !allUsersValue.equals("")) {
            value = allUsersValue;
        } else {
            throw new IllegalArgumentException("Greater Than Filter Query cannot be built for field " + fieldName);
        }
        StringBuilder extraClause = new StringBuilder();
        if (allowEmptyField) {
            extraClause.append(" (*:* AND -").append(fieldName).append(":*)");
        }
        if (extraOpts != null && !extraOpts.equals("")) {
            extraClause.append(" ").append(extraOpts);
        }
        return fieldName + ":[" + value + " TO *]" + extraClause.toString();
    }

    private String buildLessThanFilterQuery(String fieldName, Collection<String> attributeValues, boolean allowEmptyField, String allUsersValue, String extraOpts) {
        String value;
        if (attributeValues.size() == 1) {
            value = attributeValues.iterator().next();
        } else if (allUsersValue != null && !allUsersValue.equals("")) {
            value = allUsersValue;
        } else {
            throw new IllegalArgumentException("Less Than Filter Query cannot be built for field " + fieldName);
        }
        StringBuilder extraClause = new StringBuilder();
        if (allowEmptyField) {
            extraClause.append(" (*:* AND -").append(fieldName).append(":*)");
        }
        if (extraOpts != null && !extraOpts.equals("")) {
            extraClause.append(" ").append(extraOpts);
        }
        return fieldName + ":[* TO " + value + "]" + extraClause.toString();
    }

    public void process(ResponseBuilder rb) throws IOException {
    }

    public String getDescription() {
        return "Handle Query Document Authorization based on user attributes";
    }

    public String getSource() {
        return "$URL$";
    }

    private <T> T checkAndGet(NamedList args, String key) {
        return (T)Preconditions.checkNotNull((Object)args.get(key));
    }

    private <T> T getWithDefault(NamedList args, String key, T defaultValue) {
        Object value = args.get(key);
        if (value == null) {
            return defaultValue;
        }
        return (T)value;
    }

    @Override
    public boolean getEnabled() {
        return this.enabled;
    }
}

