/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.component;

import com.google.common.base.Joiner;
import java.io.IOException;
import java.util.Set;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.handler.component.DocAuthorizationComponent;
import org.apache.solr.handler.component.ResponseBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryDocAuthorizationComponent
extends DocAuthorizationComponent {
    private static final Logger LOG = LoggerFactory.getLogger(QueryDocAuthorizationComponent.class);
    public static final String AUTH_FIELD_PROP = "sentryAuthField";
    public static final String DEFAULT_AUTH_FIELD = "sentry_auth";
    public static final String ALL_ROLES_TOKEN_PROP = "allRolesToken";
    public static final String ENABLED_PROP = "enabled";
    public static final String MODE_PROP = "matchMode";
    public static final String DEFAULT_MODE_PROP = MatchType.DISJUNCTIVE.toString();
    public static final String ALLOW_MISSING_VAL_PROP = "allow_missing_val";
    public static final String TOKEN_COUNT_PROP = "tokenCountField";
    public static final String DEFAULT_TOKEN_COUNT_FIELD_PROP = "sentry_auth_count";
    public static final String QPARSER_PROP = "qParser";
    private String authField;
    private String allRolesToken;
    private boolean enabled;
    private MatchType matchMode;
    private String tokenCountField;
    private boolean allowMissingValue;
    private String qParserName;

    public void init(NamedList args) {
        SolrParams params = args.toSolrParams();
        this.authField = params.get(AUTH_FIELD_PROP, DEFAULT_AUTH_FIELD);
        LOG.info("QueryDocAuthorizationComponent authField: {}", (Object)this.authField);
        this.allRolesToken = params.get(ALL_ROLES_TOKEN_PROP, "");
        LOG.info("QueryDocAuthorizationComponent allRolesToken: {}", (Object)this.allRolesToken);
        this.enabled = params.getBool(ENABLED_PROP, false);
        LOG.info("QueryDocAuthorizationComponent enabled: {}", (Object)this.enabled);
        this.matchMode = MatchType.valueOf(params.get(MODE_PROP, DEFAULT_MODE_PROP).toUpperCase());
        LOG.info("QueryDocAuthorizationComponent matchType: {}", (Object)this.matchMode);
        if (this.matchMode == MatchType.CONJUNCTIVE) {
            this.qParserName = params.get(QPARSER_PROP, "subset").trim();
            LOG.debug("QueryDocAuthorizationComponent qParserName: {}", (Object)this.qParserName);
            this.allowMissingValue = params.getBool(ALLOW_MISSING_VAL_PROP, false);
            LOG.debug("QueryDocAuthorizationComponent allowMissingValue: {}", (Object)this.allowMissingValue);
            this.tokenCountField = params.get(TOKEN_COUNT_PROP, DEFAULT_TOKEN_COUNT_FIELD_PROP);
            LOG.debug("QueryDocAuthorizationComponent tokenCountField: {}", (Object)this.tokenCountField);
        }
    }

    private void addDisjunctiveRawClause(StringBuilder builder, String value) {
        builder.append(" {!raw f=").append(this.authField).append(" v=").append(value).append("}");
    }

    public String getDisjunctiveFilterQueryStr(Set<String> roles) {
        if (roles != null && !roles.isEmpty()) {
            StringBuilder builder = new StringBuilder();
            for (String role : roles) {
                this.addDisjunctiveRawClause(builder, role);
            }
            if (this.allRolesToken != null && !this.allRolesToken.isEmpty()) {
                this.addDisjunctiveRawClause(builder, this.allRolesToken);
            }
            return builder.toString();
        }
        return null;
    }

    @Override
    public void prepare(ResponseBuilder rb, String userName) throws IOException {
        Set<String> roles = this.getRoles(rb.req, userName);
        if (roles != null && !roles.isEmpty()) {
            String filterQuery = this.matchMode == MatchType.DISJUNCTIVE ? this.getDisjunctiveFilterQueryStr(roles) : this.getConjunctiveFilterQueryStr(roles);
            ModifiableSolrParams newParams = new ModifiableSolrParams(rb.req.getParams());
            newParams.add("fq", new String[]{filterQuery});
            rb.req.setParams((SolrParams)newParams);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Adding filter query {} for user {} with roles {}", new Object[]{filterQuery, userName, roles});
            }
        } else {
            throw new SolrException(SolrException.ErrorCode.UNAUTHORIZED, "Request from user: " + userName + " rejected because user is not associated with any roles");
        }
    }

    private String getConjunctiveFilterQueryStr(Set<String> roles) {
        StringBuilder filterQuery = new StringBuilder();
        filterQuery.append(" {!").append(this.qParserName).append(" set_field=\"").append(this.authField).append("\"").append(" set_value=\"").append(Joiner.on((char)',').join(roles.iterator())).append("\"").append(" count_field=\"").append(this.tokenCountField).append("\"");
        if (this.allRolesToken != null && !this.allRolesToken.equals("")) {
            filterQuery.append(" wildcard_token=\"").append(this.allRolesToken).append("\"");
        }
        filterQuery.append(" allow_missing_val=").append(this.allowMissingValue).append(" }");
        return filterQuery.toString();
    }

    public void process(ResponseBuilder rb) throws IOException {
    }

    public String getDescription() {
        return "Handle Query Document Authorization";
    }

    @Override
    public boolean getEnabled() {
        return this.enabled;
    }

    private static enum MatchType {
        DISJUNCTIVE,
        CONJUNCTIVE;

    }
}

