/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.component;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.handler.component.UserAttributeSourceParams;

public class LdapUserAttributeSourceParams
implements UserAttributeSourceParams {
    private String baseDn;
    private String userFilter;
    private String serverUrl;
    private String authType;
    private String username;
    private String password;
    private boolean enableStartTls;
    private boolean disableHostNameVerification;
    private boolean doNestedQuery;
    private String recursiveAttribute;
    private int maxRecurseDepth;
    private long groupCacheTtl;
    private long groupCacheMaxSize;
    public static final String LDAP_ADMIN_USER = "ldapAdminUser";
    public static final String LDAP_ADMIN_PASSWORD = "ldapAdminPassword";
    public static final String LDAP_AUTH_TYPE = "ldapAuthType";
    public static final String LDAP_AUTH_TYPE_DEFAULT = "none";
    public static final String LDAP_BASE_DN = "ldapBaseDN";
    public static final String LDAP_TLS_ENABLED = "ldapTlsEnabled";
    public static final boolean LDAP_TLS_ENABLED_DEFAULT = false;
    public static final String LDAP_TLS_DISABLE_HOSTNAME_VERIFICATION = "ldapTlsDisableHostnameVerification";
    public static final boolean LDAP_TLS_DISABLE_HOSTNAME_VERIFICATION_DEFAULT = false;
    public static final String LDAP_USER_SEARCH_FILTER = "ldapUserSearchFilter";
    public static final String LDAP_USER_SEARCH_FILTER_DEFAULT = "(uid={0})";
    public static final String LDAP_PROVIDER_URL = "ldapProviderUrl";
    public static final String LDAP_NESTED_GROUPS_ENABLED = "ldapNestedGroupsEnabled";
    public static final boolean LDAP_NESTED_GROUPS_ENABLED_DEFAULT = false;
    public static final String LDAP_RECURSIVE_ATTRIBUTE = "ldapRecursiveAttribute";
    public static final String LDAP_RECURSIVE_ATTRIBUTE_DEFAULT = "memberOf";
    public static final String LDAP_MAX_RECURSE_DEPTH = "ldapMaxRecurseDepth";
    public static final int LDAP_MAX_RECURSE_DEPTH_DEFAULT = 5;
    public static final String LDAP_GROUP_CACHE_TTL_SECONDS = "ldapGroupCacheTtlSeconds";
    public static final long LDAP_GROUP_CACHE_TTL_SECONDS_DEFAULT = 30L;
    public static final String LDAP_GROUP_CACHE_MAX_SIZE = "ldapGroupCacheMaxSize";
    public static final long LDAP_GROUP_CACHE_MAX_SIZE_DEFAULT = 1000L;

    public String getAuthType() {
        return this.authType;
    }

    public void setAuthType(String authType) {
        Preconditions.checkNotNull((Object)authType);
        this.authType = authType;
    }

    public String getBaseDn() {
        return this.baseDn;
    }

    public void setBaseDn(String baseDn) {
        Preconditions.checkNotNull((Object)baseDn);
        this.baseDn = baseDn;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getServerUrl() {
        return this.serverUrl;
    }

    public void setServerUrl(String serverUrl) {
        Preconditions.checkNotNull((Object)serverUrl);
        this.serverUrl = serverUrl;
    }

    public String getUserFilter() {
        return this.userFilter;
    }

    public void setUserFilter(String userFilter) {
        Preconditions.checkNotNull((Object)userFilter);
        this.userFilter = userFilter;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public boolean isHostNameVerificationDisabled() {
        return this.disableHostNameVerification;
    }

    public void setDisableHostNameVerification(boolean disableHostNameVerification) {
        this.disableHostNameVerification = disableHostNameVerification;
    }

    public boolean isStartTlsEnabled() {
        return this.enableStartTls;
    }

    public void setEnableStartTls(boolean enableStartTls) {
        this.enableStartTls = enableStartTls;
    }

    public boolean isNestedQueryEnabled() {
        return this.doNestedQuery;
    }

    public void setNestedQueryEnabled(boolean doNestedQuery) {
        this.doNestedQuery = doNestedQuery;
    }

    public String getRecursiveAttribute() {
        return this.recursiveAttribute;
    }

    public void setRecursiveAttribute(String attr) {
        this.recursiveAttribute = attr;
    }

    public int getMaxRecurseDepth() {
        return this.maxRecurseDepth;
    }

    public void setMaxRecurseDepth(int maxDepth) {
        this.maxRecurseDepth = maxDepth;
    }

    public long getGroupCacheTtl() {
        return this.groupCacheTtl;
    }

    public void setGroupCacheTtl(long groupCacheTtl) {
        this.groupCacheTtl = groupCacheTtl;
    }

    public long getGroupCacheMaxSize() {
        return this.groupCacheMaxSize;
    }

    public void setGroupCacheMaxSize(long groupCacheMaxSize) {
        this.groupCacheMaxSize = groupCacheMaxSize;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LdapUserAttributeSourceParams that = (LdapUserAttributeSourceParams)o;
        return Objects.equal((Object)this.baseDn, (Object)that.baseDn) && Objects.equal((Object)this.userFilter, (Object)that.userFilter) && Objects.equal((Object)this.serverUrl, (Object)that.serverUrl) && Objects.equal((Object)this.authType, (Object)that.authType) && Objects.equal((Object)this.username, (Object)that.username) && Objects.equal((Object)this.password, (Object)that.password);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.baseDn, this.userFilter, this.serverUrl, this.authType, this.username, this.password});
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("authType", (Object)this.authType).add("baseDn", (Object)this.baseDn).add("userFilter", (Object)this.userFilter).add("serverUrl", (Object)this.serverUrl).add("username", (Object)this.username).add("password", (Object)"***").toString();
    }

    @Override
    public void init(SolrParams solrParams) {
        this.setServerUrl(solrParams.get(LDAP_PROVIDER_URL));
        this.setBaseDn(solrParams.get(LDAP_BASE_DN));
        this.setUserFilter(solrParams.get(LDAP_USER_SEARCH_FILTER, LDAP_USER_SEARCH_FILTER_DEFAULT));
        this.setAuthType(solrParams.get(LDAP_AUTH_TYPE, LDAP_AUTH_TYPE_DEFAULT));
        this.setUsername(solrParams.get(LDAP_ADMIN_USER));
        this.setPassword(solrParams.get(LDAP_ADMIN_PASSWORD));
        this.setEnableStartTls(solrParams.getBool(LDAP_TLS_ENABLED, false));
        this.setDisableHostNameVerification(solrParams.getBool(LDAP_TLS_DISABLE_HOSTNAME_VERIFICATION, false));
        this.setNestedQueryEnabled(solrParams.getBool(LDAP_NESTED_GROUPS_ENABLED, false));
        this.setRecursiveAttribute(solrParams.get(LDAP_RECURSIVE_ATTRIBUTE, LDAP_RECURSIVE_ATTRIBUTE_DEFAULT));
        this.setMaxRecurseDepth(solrParams.getInt(LDAP_MAX_RECURSE_DEPTH, 5));
        this.setGroupCacheMaxSize(solrParams.getLong(LDAP_GROUP_CACHE_MAX_SIZE, 1000L));
        this.setGroupCacheTtl(solrParams.getLong(LDAP_GROUP_CACHE_TTL_SECONDS, 30L));
    }
}

