/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.hdfs;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.sentry.hdfs.PathsUpdate;
import org.apache.sentry.hdfs.PermissionsUpdate;
import org.apache.sentry.hdfs.SentryHdfsMetricsUtil;
import org.apache.sentry.hdfs.SentryPlugin;
import org.apache.sentry.hdfs.service.thrift.SentryHDFSService;
import org.apache.sentry.hdfs.service.thrift.TAuthzUpdateRequest;
import org.apache.sentry.hdfs.service.thrift.TAuthzUpdateResponse;
import org.apache.sentry.hdfs.service.thrift.TPathsUpdate;
import org.apache.sentry.hdfs.service.thrift.TPermissionsUpdate;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sentry.com.codahale.metrics.Timer;

public class SentryHDFSServiceProcessor
implements SentryHDFSService.Iface {
    private static final Logger LOGGER = LoggerFactory.getLogger(SentryHDFSServiceProcessor.class);
    private static final AtomicBoolean pathsRetrieverBusy = new AtomicBoolean(false);

    public TAuthzUpdateResponse get_all_authz_updates_from(long permSeqNum, long pathSeqNum) throws TException {
        throw new UnsupportedOperationException("get_all_authz_updates_from() is not supported due to known bugs. Use get_authz_updates() instead.");
    }

    public TAuthzUpdateResponse get_authz_updates(TAuthzUpdateRequest request) throws TException {
        TAuthzUpdateResponse retVal = new TAuthzUpdateResponse();
        if (SentryPlugin.instance == null) {
            LOGGER.error("SentryPlugin not initialized yet !!");
            retVal.setAuthzPathUpdate(Collections.emptyList());
            retVal.setAuthzPermUpdate(Collections.emptyList());
            return retVal;
        }
        try (Timer.Context timerContext = SentryHdfsMetricsUtil.getAllAuthzUpdatesTimer.time();){
            retVal.setAuthzPermUpdate(this.getPermissionsUpdatesFrom(request));
            retVal.setAuthzPathUpdate(this.getPathsUpdatesFrom(request));
        }
        catch (Exception e) {
            LOGGER.error("Error Sending updates to downstream Cache", (Throwable)e);
            throw new TException((Throwable)e);
        }
        return retVal;
    }

    private List<TPermissionsUpdate> getPermissionsUpdatesFrom(TAuthzUpdateRequest request) throws Exception {
        LOGGER.debug("PERMISSIONS updates requested from HDFS [SeqNum={}]", (Object)request.getPermSeqNum());
        List<PermissionsUpdate> permUpdates = SentryPlugin.instance.getAllPermsUpdatesFrom(request.getPermSeqNum());
        ArrayList<TPermissionsUpdate> retPermUpdates = new ArrayList<TPermissionsUpdate>(permUpdates.size());
        for (PermissionsUpdate update : permUpdates) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Sending PERM preUpdate seq [{}], [{}]", (Object)update.getSeqNum(), (Object)update.toThrift());
            }
            retPermUpdates.add(update.toThrift());
        }
        SentryHdfsMetricsUtil.getPermUpdateHistogram.update(permUpdates.size());
        return retPermUpdates;
    }

    private List<TPathsUpdate> getPathsUpdatesFrom(TAuthzUpdateRequest request) throws Exception {
        LOGGER.debug("PATHS updates requested from HDFS [ImgNum={}, SeqNum={}]", (Object)request.getPathImgNum(), (Object)request.getPathSeqNum());
        if (!pathsRetrieverBusy.compareAndSet(false, true)) {
            LOGGER.debug("PATHS updates are not available because another request is in progress.");
            return Collections.emptyList();
        }
        try {
            List<PathsUpdate> pathUpdates = SentryPlugin.instance.getAllPathsUpdatesFrom(request.getPathSeqNum(), request.getPathImgNum());
            ArrayList<TPathsUpdate> retPathUpdates = new ArrayList<TPathsUpdate>(pathUpdates.size());
            for (PathsUpdate update : pathUpdates) {
                LOGGER.debug("Sending PATH preUpdate seq [{}], [{}]", (Object)update.getSeqNum(), (Object)update.getImgNum());
                retPathUpdates.add(update.toThrift());
            }
            SentryHdfsMetricsUtil.getPathUpdateHistogram.update(pathUpdates.size());
            ArrayList<TPathsUpdate> arrayList = retPathUpdates;
            return arrayList;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            pathsRetrieverBusy.set(false);
        }
    }

    public void handle_hms_notification(TPathsUpdate update) throws TException {
        throw new UnsupportedOperationException("handle_hms_notification");
    }

    public long check_hms_seq_num(long pathSeqNum) throws TException {
        throw new UnsupportedOperationException("check_hms_seq_num");
    }

    public Map<String, List<String>> get_all_related_paths(String arg0, boolean arg1) throws TException {
        return null;
    }
}

