/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.hdfs;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.sentry.hdfs.DBUpdateForwarder;
import org.apache.sentry.hdfs.ImageRetriever;
import org.apache.sentry.hdfs.PermissionsUpdate;
import org.apache.sentry.hdfs.SentryHdfsMetricsUtil;
import org.apache.sentry.hdfs.service.thrift.TPermissionsUpdate;
import org.apache.sentry.hdfs.service.thrift.TPrivilegeChanges;
import org.apache.sentry.hdfs.service.thrift.TRoleChanges;
import org.apache.sentry.provider.db.service.persistent.PermissionsImage;
import org.apache.sentry.provider.db.service.persistent.SentryStoreInterface;
import sentry.com.codahale.metrics.Timer;

@ThreadSafe
public class PermImageRetriever
implements ImageRetriever<PermissionsUpdate> {
    private final SentryStoreInterface sentryStore;

    PermImageRetriever(SentryStoreInterface sentryStore) {
        this.sentryStore = sentryStore;
    }

    public PermissionsUpdate retrieveFullImage() throws Exception {
        try (Timer.Context timerContext = SentryHdfsMetricsUtil.getRetrievePermFullImageTimer.time();){
            PermissionsImage permImage = this.sentryStore.retrieveFullPermssionsImage();
            long curSeqNum = permImage.getCurSeqNum();
            Map privilegeImage = permImage.getPrivilegeImage();
            Map roleImage = permImage.getRoleImage();
            TPermissionsUpdate tPermUpdate = new TPermissionsUpdate(true, curSeqNum, new HashMap(), new HashMap());
            for (Map.Entry privEnt : privilegeImage.entrySet()) {
                String authzObj = (String)privEnt.getKey();
                Map privMap = (Map)privEnt.getValue();
                DBUpdateForwarder.translateOwnerPrivileges(privMap);
                tPermUpdate.putToPrivilegeChanges(authzObj, new TPrivilegeChanges(authzObj, privMap, new HashMap()));
            }
            for (Map.Entry privEnt : roleImage.entrySet()) {
                String role = (String)privEnt.getKey();
                List groups = (List)privEnt.getValue();
                tPermUpdate.putToRoleChanges(role, new TRoleChanges(role, groups, new ArrayList()));
            }
            PermissionsUpdate permissionsUpdate = new PermissionsUpdate(tPermUpdate);
            SentryHdfsMetricsUtil.getPrivilegeChangesHistogram.update(tPermUpdate.getPrivilegeChangesSize());
            SentryHdfsMetricsUtil.getRoleChangesHistogram.update(tPermUpdate.getRoleChangesSize());
            PermissionsUpdate permissionsUpdate2 = permissionsUpdate;
            return permissionsUpdate2;
        }
    }

    public long getLatestImageID() throws Exception {
        return -1L;
    }
}

