/*
 * Decompiled with CFR 0.152.
 */
package sentry.org.apache.sentry.core.common.utils;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.text.StrSubstitutor;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PathUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(PathUtils.class);
    private static final String LOCAL_FILE_SCHEMA = "file";
    private static final String AUTHORITY_PREFIX = "://";
    private static final Configuration CONF = new Configuration();

    private PathUtils() {
    }

    @VisibleForTesting
    public static Configuration getConfiguration() {
        return CONF;
    }

    public static boolean impliesURI(URI privilegeURI, URI requestURI) throws URISyntaxException {
        return PathUtils._impliesURI(privilegeURI.toString(), requestURI.toString());
    }

    private static boolean _impliesURI(String privilege, String request) {
        URI requestURI;
        URI privilegeURI;
        try {
            privilegeURI = PathUtils.makeFullQualifiedURI(privilege);
            if (privilegeURI == null) {
                LOGGER.warn("Privilege URI " + privilege + " is not valid. Path is not absolute.");
                return false;
            }
            requestURI = PathUtils.makeFullQualifiedURI(request);
            if (requestURI == null) {
                LOGGER.warn("Request URI " + request + " is not valid. Path is not absolute.");
                return false;
            }
        }
        catch (IOException e) {
            LOGGER.warn("Unable to get the configured filesystem implementation", (Throwable)e);
            return false;
        }
        if (privilegeURI.getScheme() == null || privilegeURI.getPath() == null) {
            LOGGER.warn("Privilege URI " + request + " is not valid. Missing scheme or path.");
            return false;
        }
        if (requestURI.getScheme() == null || requestURI.getPath() == null) {
            LOGGER.warn("Request URI " + request + " is not valid. Missing scheme or path.");
            return false;
        }
        if (privilegeURI.getScheme() != null && !privilegeURI.getScheme().equals(requestURI.getScheme())) {
            return false;
        }
        String requestPath = PathUtils.ensureEndsWithSeparator(requestURI.getPath()).replace("//", "/");
        String privilegePath = PathUtils.ensureEndsWithSeparator(privilegeURI.getPath()).replace("//", "/");
        return requestURI.getPath().equals(requestURI.normalize().getPath()) && requestPath.startsWith(privilegePath) && Strings.nullToEmpty((String)privilegeURI.getAuthority()).equals(Strings.nullToEmpty((String)requestURI.getAuthority()));
    }

    private static URI makeFullQualifiedURI(String uriName) throws IOException {
        Path uriPath = new Path(uriName);
        if (PathUtils.isNormalized(uriName) && uriPath.isUriPathAbsolute()) {
            if (uriPath.toUri().getScheme() == null || uriPath.toUri().getAuthority() == null) {
                URI defaultUri = FileSystem.getDefaultUri((Configuration)CONF);
                uriPath = uriPath.makeQualified(defaultUri, uriPath);
            }
            return uriPath.toUri();
        }
        return null;
    }

    private static boolean isNormalized(String uriName) {
        URI uri = URI.create(uriName);
        return uri.getPath().equals(uri.normalize().getPath());
    }

    public static boolean impliesURI(String privilege, String request) {
        return PathUtils._impliesURI(new StrSubstitutor((Map)System.getProperties()).replace(privilege), request);
    }

    private static String ensureEndsWithSeparator(String path) {
        if (path.endsWith(File.separator)) {
            return path;
        }
        return path + File.separator;
    }

    public static String parseDFSURI(String warehouseDir, String uri) throws URISyntaxException {
        return PathUtils.parseURI(warehouseDir, uri, false);
    }

    public static String parseURI(String warehouseDir, String uri, boolean isLocal) throws URISyntaxException {
        String uriAuthority;
        String uriScheme;
        Path warehouseDirPath = new Path(warehouseDir);
        Path uriPath = new Path(uri);
        if (uriPath.isAbsolute()) {
            if (uriPath.isAbsoluteAndSchemeAuthorityNull()) {
                uriPath = uriPath.makeQualified(warehouseDirPath.toUri(), warehouseDirPath);
            }
            uriScheme = uriPath.toUri().getScheme();
            uriAuthority = uriPath.toUri().getAuthority();
            if (StringUtils.isEmpty((String)uriScheme) || isLocal) {
                uriScheme = LOCAL_FILE_SCHEMA;
                uriAuthority = "";
            }
        } else {
            throw new IllegalArgumentException("Invalid URI " + uri + ".");
        }
        uriPath = new Path(uriScheme + AUTHORITY_PREFIX + StringUtils.trimToEmpty((String)uriAuthority) + Path.getPathWithoutSchemeAndAuthority((Path)uriPath));
        return uriPath.toUri().toString();
    }

    public static String parseLocalURI(String uri) throws URISyntaxException {
        Path uriPath = new Path(uri);
        if (!uriPath.isAbsolute()) {
            throw new IllegalArgumentException("Parse URI does not work on relative URI: " + uri);
        }
        uriPath = new Path("file://" + StringUtils.trimToEmpty((String)uriPath.toUri().getAuthority()) + Path.getPathWithoutSchemeAndAuthority((Path)uriPath));
        return uriPath.toUri().toString();
    }

    public static String[] splitPath(String path) {
        path = path.replaceAll("(^/+)|(/+$)", "");
        return path.split("/+");
    }
}

