/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.hdfs;

import java.util.List;
import org.apache.sentry.hdfs.PathsUpdate;
import org.apache.sentry.hdfs.PermissionsUpdate;

public class SentryAuthzUpdate {
    private final List<PermissionsUpdate> permUpdates;
    private final List<PathsUpdate> pathUpdates;

    public SentryAuthzUpdate(List<PermissionsUpdate> permUpdates, List<PathsUpdate> pathUpdates) {
        this.permUpdates = permUpdates;
        this.pathUpdates = pathUpdates;
    }

    public List<PermissionsUpdate> getPermUpdates() {
        return this.permUpdates;
    }

    public List<PathsUpdate> getPathUpdates() {
        return this.pathUpdates;
    }

    public String dumpContent() {
        StringBuffer sb = new StringBuffer(this.getClass().getSimpleName());
        if (this.permUpdates != null && !this.permUpdates.isEmpty()) {
            sb.append(", Permission Updates[").append(this.permUpdates.size()).append(']').append(this.permUpdates);
        }
        if (this.pathUpdates != null && !this.pathUpdates.isEmpty()) {
            sb.append(", Path Updates[").append(this.pathUpdates.size()).append(']').append(this.pathUpdates);
        }
        return sb.toString();
    }

    public boolean isEmpty() {
        return !(this.permUpdates != null && !this.permUpdates.isEmpty() || this.pathUpdates != null && !this.pathUpdates.isEmpty());
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.getClass().getSimpleName());
        if (this.permUpdates != null && !this.permUpdates.isEmpty()) {
            sb.append(", perms[").append(this.permUpdates.size()).append(']');
        }
        if (this.pathUpdates != null && !this.pathUpdates.isEmpty()) {
            sb.append(", paths[").append(this.pathUpdates.size()).append(']');
        }
        return sb.toString();
    }
}

