/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.shell;

import com.budhash.cliche.Command;
import com.budhash.cliche.Param;
import com.budhash.cliche.Shell;
import com.budhash.cliche.ShellDependent;
import com.budhash.cliche.ShellFactory;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.sentry.api.generic.thrift.SentryGenericServiceClient;
import org.apache.sentry.api.service.thrift.SentryPolicyServiceClient;
import org.apache.sentry.api.tools.GenericPrivilegeConverter;
import org.apache.sentry.api.tools.TSentryPrivilegeConverter;
import org.apache.sentry.cli.tools.ShellCommand;
import org.apache.sentry.cli.tools.command.GenericShellCommand;
import org.apache.sentry.cli.tools.command.hive.HiveShellCommand;
import org.apache.sentry.core.common.exception.SentryUserException;
import org.apache.sentry.shell.GroupShell;
import org.apache.sentry.shell.PrivsShell;
import org.apache.sentry.shell.RolesShell;

public class TopLevelShell
implements ShellDependent,
Runnable {
    private final Shell topShell;
    private ShellCommand shellCommand;
    private Shell shell;
    private final String authUser;
    private final SentryPolicyServiceClient sentryClient;
    private final SentryGenericServiceClient sentryGenericClient;

    TopLevelShell(SentryPolicyServiceClient sentryClient, SentryGenericServiceClient sentryGenericClient, String authUser) {
        this.authUser = authUser;
        this.sentryClient = sentryClient;
        this.sentryGenericClient = sentryGenericClient;
        this.shellCommand = new HiveShellCommand(sentryClient);
        this.topShell = ShellFactory.createConsoleShell((String)"sentry", (String)"sentry shell\nEnter ?l to list available commands.", (Object)this);
    }

    @Command(description="list, create and remove roles")
    public void roles() throws IOException {
        ShellFactory.createSubshell((String)"roles", (Shell)this.shell, (String)"roles commands", (Object)new RolesShell(this.shellCommand, this.authUser)).commandLoop();
    }

    @Command(description="list, create and remove groups")
    public void groups() throws IOException {
        ShellFactory.createSubshell((String)"groups", (Shell)this.shell, (String)"groups commands", (Object)new GroupShell(this.shellCommand, this.authUser)).commandLoop();
    }

    @Command(description="list, create and remove privileges")
    public void privileges() throws IOException {
        ShellFactory.createSubshell((String)"privileges", (Shell)this.shell, (String)"privileges commands", (Object)new PrivsShell(this.shellCommand, this.authUser)).commandLoop();
    }

    @Command(description="List sentry roles. shows all available roles.")
    public List<String> listRoles() {
        try {
            List<String> result = this.shellCommand.listRoles(this.authUser, null);
            Collections.sort(result);
            return result;
        }
        catch (SentryUserException e) {
            System.out.printf("failed to list roles: %s\n", e.toString());
            return Collections.emptyList();
        }
    }

    @Command(description="List sentry roles by group")
    public List<String> listRoles(@Param(name="groupName") String group) {
        try {
            List<String> result = this.shellCommand.listRoles(this.authUser, group);
            Collections.sort(result);
            return result;
        }
        catch (SentryUserException e) {
            System.out.printf("failed to list roles with group %s: %s\n", group, e.toString());
            return Collections.emptyList();
        }
    }

    @Command(abbrev="lg", header="[groups]", description="list groups and their roles")
    public List<String> listGroups() {
        try {
            return this.shellCommand.listGroupRoles(this.authUser);
        }
        catch (SentryUserException e) {
            System.out.printf("failed to list the groups and roles: %s\n", e.toString());
            return Collections.emptyList();
        }
    }

    @Command(description="Grant role to groups")
    public void grantRole(@Param(name="roleName") String roleName, String ... groups) {
        try {
            HashSet<String> groupsSet = new HashSet<String>(Arrays.asList(groups));
            this.shellCommand.grantRoleToGroups(this.authUser, roleName, groupsSet);
        }
        catch (SentryUserException e) {
            System.out.printf("Failed to gran role %s to groups: %s\n", roleName, e.toString());
        }
    }

    @Command(abbrev="grm", description="Revoke role from groups")
    public void revokeRole(@Param(name="roleName") String roleName, String ... groups) {
        try {
            HashSet<String> groupsSet = new HashSet<String>(Arrays.asList(groups));
            this.shellCommand.revokeRoleFromGroups(this.authUser, roleName, groupsSet);
        }
        catch (SentryUserException e) {
            System.out.printf("Failed to revoke role %s to groups: %s\n", roleName, e.toString());
        }
    }

    @Command(description="Create Sentry role(s).")
    public void createRole(String ... roles) {
        for (String role : roles) {
            try {
                this.shellCommand.createRole(this.authUser, role);
            }
            catch (SentryUserException e) {
                System.out.printf("failed to create role %s: %s\n", role, e.toString());
            }
        }
    }

    @Command(abbrev="dr", description="drop Sentry role(s).")
    public void dropRole(String ... roles) {
        for (String role : roles) {
            try {
                this.shellCommand.dropRole(this.authUser, role);
            }
            catch (SentryUserException e) {
                System.out.printf("failed to drop role %s: %s\n", role, e.toString());
            }
        }
    }

    @Command(description="list Sentry privileges")
    public List<String> listPrivileges(@Param(name="roleName") String roleName) {
        try {
            return this.shellCommand.listPrivileges(this.authUser, roleName);
        }
        catch (SentryUserException e) {
            System.out.println("Failed to list privileges: " + e.toString());
            return Collections.emptyList();
        }
    }

    @Command(description="Grant privilege to role")
    public void grantPrivilege(@Param(name="roleName") String roleName, @Param(name="privilege", description="privilege string, e.g. server=s1->db=foo") String privilege) {
        try {
            this.shellCommand.grantPrivilegeToRole(this.authUser, roleName, privilege);
        }
        catch (SentryUserException e) {
            System.out.println("Error granting privilege: " + e.toString());
        }
    }

    @Command
    public void revokePrivilege(@Param(name="roleName") String roleName, @Param(name="privilege", description="privilege string, e.g. server=s1->db=foo") String privilege) {
        try {
            this.shellCommand.revokePrivilegeFromRole(this.authUser, roleName, privilege);
        }
        catch (SentryUserException e) {
            System.out.println("failed to revoke privilege: " + e.toString());
        }
    }

    @Command(description="Set the type: hive, kafka, sqoop, solr, etc.")
    public void type(@Param(name="type", description="the type to set: hive, kafka, sqoop, solr, etc.") String type) {
        try {
            TYPE parsedType = this.parseType(type);
            if (parsedType == TYPE.HIVE) {
                this.shellCommand = new HiveShellCommand(this.sentryClient);
            } else {
                String component = this.getComponent(parsedType);
                String service = this.getService(parsedType);
                GenericPrivilegeConverter converter = new GenericPrivilegeConverter(component, service);
                this.shellCommand = new GenericShellCommand(this.sentryGenericClient, component, service, (TSentryPrivilegeConverter)converter);
            }
        }
        catch (IllegalArgumentException ex) {
            System.out.printf("%s is not an accepted type value\n", type);
        }
    }

    @Command(description="Set the type: hive, kafka, sqoop, solr, etc.")
    public void type(@Param(name="type", description="the type to set: hive, kafka, sqoop, solr, etc.") String type, @Param(name="service", description="the service name") String service) {
        try {
            TYPE parsedType = this.parseType(type);
            if (parsedType == TYPE.HIVE) {
                this.shellCommand = new HiveShellCommand(this.sentryClient);
            } else {
                String component = this.getComponent(parsedType);
                GenericPrivilegeConverter converter = new GenericPrivilegeConverter(component, service);
                this.shellCommand = new GenericShellCommand(this.sentryGenericClient, component, service, (TSentryPrivilegeConverter)converter);
            }
        }
        catch (IllegalArgumentException ex) {
            System.out.printf("%s is not an accepted type value\n", type);
        }
    }

    public void cliSetShell(Shell theShell) {
        this.shell = theShell;
    }

    @Override
    public void run() {
        try {
            this.topShell.commandLoop();
        }
        catch (IOException e) {
            System.out.println("error: " + e.toString());
        }
    }

    private String getComponent(TYPE type) {
        switch (type) {
            case KAFKA: {
                return "kafka";
            }
            case SOLR: {
                return "SOLR";
            }
            case SQOOP: {
                return "sqoop";
            }
        }
        throw new IllegalArgumentException("Invalid type specified for SentryShellGeneric: " + (Object)((Object)type));
    }

    private String getService(TYPE type) {
        switch (type) {
            case KAFKA: {
                return "kafka";
            }
            case SOLR: {
                return "service1";
            }
            case SQOOP: {
                return "sqoopServer1";
            }
        }
        throw new IllegalArgumentException("Invalid type specified for SentryShellGeneric: " + (Object)((Object)type));
    }

    private TYPE parseType(String typeStr) {
        for (TYPE type : TYPE.values()) {
            if (!type.name().equalsIgnoreCase(typeStr)) continue;
            return type;
        }
        throw new IllegalArgumentException("Invalid type specified for SentryShellGeneric: " + typeStr);
    }

    public static enum TYPE {
        KAFKA,
        HIVE,
        SOLR,
        SQOOP;

    }
}

