/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.shell;

import com.budhash.cliche.Command;
import com.budhash.cliche.Param;
import com.budhash.cliche.Shell;
import com.budhash.cliche.ShellDependent;
import java.util.Collections;
import java.util.List;
import org.apache.sentry.cli.tools.ShellCommand;
import org.apache.sentry.core.common.exception.SentryUserException;

public class RolesShell
implements ShellDependent {
    private final ShellCommand shellCommand;
    private final String authUser;
    Shell shell;

    public RolesShell(ShellCommand shellCommand, String authUser) {
        this.shellCommand = shellCommand;
        this.authUser = authUser;
    }

    @Command(description="List sentry roles. shows all available roles.")
    public List<String> list() {
        try {
            List<String> result = this.shellCommand.listRoles(this.authUser, null);
            Collections.sort(result);
            return result;
        }
        catch (SentryUserException e) {
            System.out.printf("failed to list roles: %s\n", e.toString());
            return Collections.emptyList();
        }
    }

    @Command(description="List sentry roles by group")
    public List<String> list(@Param(name="groupName", description="group name for roles") String group) {
        try {
            List<String> result = this.shellCommand.listRoles(this.authUser, group);
            Collections.sort(result);
            return result;
        }
        catch (SentryUserException e) {
            System.out.printf("failed to list roles with group %s: %s\n", group, e.toString());
            return Collections.emptyList();
        }
    }

    @Command(description="Create Sentry role(s).")
    public void create(String ... roles) {
        for (String role : roles) {
            try {
                this.shellCommand.createRole(this.authUser, role);
            }
            catch (SentryUserException e) {
                System.out.printf("failed to create role %s: %s\n", role, e.toString());
            }
        }
    }

    @Command(description="drop Sentry role(s).")
    public void drop(String ... roles) {
        for (String role : roles) {
            try {
                this.shellCommand.dropRole(this.authUser, role);
            }
            catch (SentryUserException e) {
                System.out.printf("failed to drop role %s: %s\n", role, e.toString());
            }
        }
    }

    public void cliSetShell(Shell theShell) {
        this.shell = theShell;
    }
}

