/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.shell;

import com.budhash.cliche.Command;
import com.budhash.cliche.Param;
import com.budhash.cliche.Shell;
import com.budhash.cliche.ShellDependent;
import java.util.Collections;
import java.util.List;
import org.apache.sentry.cli.tools.ShellCommand;
import org.apache.sentry.core.common.exception.SentryUserException;

public class PrivsShell
implements ShellDependent {
    private final ShellCommand shellCommand;
    private final String authUser;
    Shell shell;

    public PrivsShell(ShellCommand shellCommand, String authUser) {
        this.shellCommand = shellCommand;
        this.authUser = authUser;
    }

    @Command(description="Grant privilege to role")
    public void grant(@Param(name="roleName") String roleName, @Param(name="privilege", description="privilege string, e.g. server=s1->db=foo") String privilege) {
        try {
            this.shellCommand.grantPrivilegeToRole(this.authUser, roleName, privilege);
        }
        catch (SentryUserException e) {
            System.out.println("Error granting privilege: " + e.toString());
        }
    }

    @Command
    public List<String> list(@Param(name="roleName") String roleName) {
        try {
            return this.shellCommand.listPrivileges(this.authUser, roleName);
        }
        catch (SentryUserException e) {
            System.out.println("Failed to list privileges: " + e.toString());
            return Collections.emptyList();
        }
    }

    @Command
    public void revoke(@Param(name="roleName") String roleName, @Param(name="privilege", description="privilege string, e.g. server=s1->db=foo") String privilege) {
        try {
            this.shellCommand.revokePrivilegeFromRole(this.authUser, roleName, privilege);
        }
        catch (SentryUserException e) {
            System.out.println("failed to revoke privilege: " + e.toString());
        }
    }

    public void cliSetShell(Shell theShell) {
        this.shell = theShell;
    }
}

