/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.cli.tools;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.hadoop.conf.Configuration;
import org.apache.sentry.cli.tools.SentryConfigToolIndexer;
import org.apache.sentry.cli.tools.SentryShellGeneric;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SentryShellIndexer
extends SentryShellGeneric {
    protected boolean isMigration = false;
    private static final Logger LOGGER = LoggerFactory.getLogger(SentryShellIndexer.class);
    private final SentryConfigToolIndexer configTool = new SentryConfigToolIndexer();

    @Override
    protected void setupOptions(Options simpleShellOptions) {
        super.setupOptions(simpleShellOptions);
        this.configTool.setupOptions(simpleShellOptions);
    }

    @Override
    protected void parseOptions(CommandLine cmd) throws ParseException {
        super.parseOptions(cmd);
        this.configTool.parseOptions(cmd);
        for (Option opt : cmd.getOptions()) {
            if (!opt.getOpt().equals("mgr")) continue;
            this.isMigration = true;
        }
    }

    @Override
    protected OptionGroup getMainOptions() {
        OptionGroup mainOptions = super.getMainOptions();
        Option mgrOpt = new Option("mgr", "migrate", false, "Migrate ini file to Sentry service");
        mgrOpt.setRequired(false);
        mainOptions.addOption(mgrOpt);
        return mainOptions;
    }

    @Override
    public void run() throws Exception {
        if (this.isMigration) {
            this.configTool.run();
            return;
        }
        super.run();
    }

    @Override
    protected String getComponent() throws Exception {
        return "hbaseindexer";
    }

    @Override
    protected String getService(Configuration conf) throws Exception {
        String service = conf.get("sentry.provider.backend.generic.service-name", this.serviceName);
        if (service == null) {
            throw new IllegalArgumentException("Service was not defined. Please, use -s command option, or sentry.provider.backend.generic.service-name configuration entry.");
        }
        return service;
    }

    public static void main(String[] args) throws Exception {
        SentryShellIndexer sentryShell = new SentryShellIndexer();
        try {
            sentryShell.executeShell(args);
        }
        catch (Exception e) {
            Throwable current;
            LOGGER.error(e.getMessage(), (Throwable)e);
            for (current = e; current != null && current.getMessage() == null; current = current.getCause()) {
            }
            System.out.println("The operation failed." + (current.getMessage() == null ? "" : "  Message: " + current.getMessage()));
            System.exit(1);
        }
    }
}

