/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.cli.tools;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.sentry.api.generic.thrift.SentryGenericServiceClient;
import org.apache.sentry.api.generic.thrift.SentryGenericServiceClientFactory;
import org.apache.sentry.api.tools.GenericPrivilegeConverter;
import org.apache.sentry.cli.tools.SentryConfigToolCommon;
import org.apache.sentry.core.common.exception.SentryConfigurationException;
import org.apache.sentry.core.common.utils.KeyValue;
import org.apache.sentry.core.common.utils.SentryConstants;
import org.apache.sentry.core.model.solr.SolrPrivilegeModel;
import org.apache.sentry.provider.common.ProviderBackend;
import org.apache.sentry.provider.common.ProviderBackendContext;
import org.apache.sentry.provider.file.SimpleFileProviderBackend;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SentryConfigToolSolr
extends SentryConfigToolCommon {
    private static final Logger LOGGER = LoggerFactory.getLogger(SentryConfigToolSolr.class);
    public static final String SOLR_SERVICE_NAME = "sentry.service.client.solr.service.name";

    @Override
    public void run() throws Exception {
        String component = "SOLR";
        Configuration conf = this.getSentryConf();
        String service = conf.get(SOLR_SERVICE_NAME, "service1");
        try (SentryGenericServiceClient client = SentryGenericServiceClientFactory.create((Configuration)conf);){
            UserGroupInformation ugi = UserGroupInformation.getLoginUser();
            String requestorName = ugi.getShortUserName();
            this.convertINIToSentryServiceCmds(component, service, requestorName, conf, client, this.getPolicyFile(), this.getValidate(), this.getImportPolicy(), this.getCheckCompat());
        }
    }

    private Configuration getSentryConf() {
        Configuration conf = new Configuration();
        conf.addResource(new Path(this.getConfPath()), true);
        return conf;
    }

    private void convertINIToSentryServiceCmds(String component, String service, String requestorName, Configuration conf, SentryGenericServiceClient client, String policyFile, boolean validate, boolean importPolicy, boolean checkCompat) throws Exception {
        LOGGER.info("Reading policy file at: " + policyFile);
        SimpleFileProviderBackend policyFileBackend = new SimpleFileProviderBackend(conf, policyFile);
        ProviderBackendContext context = new ProviderBackendContext();
        context.setValidators(SolrPrivilegeModel.getInstance().getPrivilegeValidators());
        policyFileBackend.initialize(context);
        if (validate) {
            this.validatePolicy((ProviderBackend)policyFileBackend);
        }
        if (checkCompat) {
            this.checkCompat(policyFileBackend);
        }
        HashSet roles = Sets.newHashSet();
        Table groupRolePrivilegeTable = policyFileBackend.getGroupRolePrivilegeTable();
        GenericPrivilegeConverter converter = new GenericPrivilegeConverter(component, service, false);
        for (String groupName : groupRolePrivilegeTable.rowKeySet()) {
            for (String roleName : groupRolePrivilegeTable.columnKeySet()) {
                Set privileges;
                if (!roles.contains(roleName)) {
                    LOGGER.info(this.dryRunMessage(importPolicy) + "Creating role: " + roleName.toLowerCase(Locale.US));
                    if (importPolicy) {
                        client.createRoleIfNotExist(requestorName, roleName, component);
                    }
                    roles.add(roleName);
                }
                if ((privileges = (Set)groupRolePrivilegeTable.get((Object)groupName, (Object)roleName)) == null) continue;
                LOGGER.info(this.dryRunMessage(importPolicy) + "Adding role: " + roleName.toLowerCase(Locale.US) + " to group: " + groupName);
                if (importPolicy) {
                    client.grantRoleToGroups(requestorName, roleName, component, (Set)Sets.newHashSet((Object[])new String[]{groupName}));
                }
                for (String permission : privileges) {
                    String action = null;
                    for (String authorizable : SentryConstants.AUTHORIZABLE_SPLITTER.trimResults().split((CharSequence)permission)) {
                        KeyValue kv = new KeyValue(authorizable);
                        String key = kv.getKey();
                        String value = kv.getValue();
                        if (!"action".equalsIgnoreCase(key)) continue;
                        action = value;
                    }
                    if (action == null) {
                        permission = permission + "->action=*";
                    }
                    LOGGER.info(this.dryRunMessage(importPolicy) + "Adding permission: " + permission + " to role: " + roleName.toLowerCase(Locale.US));
                    if (!importPolicy) continue;
                    client.grantPrivilege(requestorName, roleName, component, converter.fromString(permission));
                }
            }
        }
    }

    private void validatePolicy(ProviderBackend backend) throws Exception {
        try {
            backend.validatePolicy(true);
        }
        catch (SentryConfigurationException e) {
            this.printConfigErrorsWarnings(e);
            throw e;
        }
    }

    private void printConfigErrorsWarnings(SentryConfigurationException configException) {
        System.out.println(" *** Found configuration problems *** ");
        for (String errMsg : configException.getConfigErrors()) {
            System.out.println("ERROR: " + errMsg);
        }
        for (String warnMsg : configException.getConfigWarnings()) {
            System.out.println("Warning: " + warnMsg);
        }
    }

    private void checkCompat(SimpleFileProviderBackend backend) throws Exception {
        HashMap<String, HashSet> rolesCaseMapping = new HashMap<String, HashSet>();
        Table groupRolePrivilegeTable = backend.getGroupRolePrivilegeTable();
        for (String roleName : groupRolePrivilegeTable.columnKeySet()) {
            String roleNameLower;
            if (roleName.equals(roleNameLower = roleName.toLowerCase(Locale.US))) continue;
            if (!rolesCaseMapping.containsKey(roleNameLower)) {
                rolesCaseMapping.put(roleNameLower, Sets.newHashSet((Object[])new String[]{roleName}));
                continue;
            }
            ((Set)rolesCaseMapping.get(roleNameLower)).add(roleName);
        }
        LinkedList<String> errors = new LinkedList<String>();
        StringBuilder warningString = new StringBuilder();
        if (!rolesCaseMapping.isEmpty()) {
            warningString.append("The following roles names will be lower cased when added to the Sentry Service.\n");
            warningString.append("This will cause document-level security to fail to match the role tokens.\n");
            warningString.append("Role names: ");
        }
        boolean firstWarning = true;
        for (Map.Entry entry : rolesCaseMapping.entrySet()) {
            Set caseMapping = (Set)entry.getValue();
            if (caseMapping.size() > 1) {
                StringBuilder errorString = new StringBuilder();
                errorString.append("The following (cased) roles map to the same role in the sentry service: ");
                boolean first = true;
                for (String casedRole : caseMapping) {
                    errorString.append(first ? "" : ", ");
                    errorString.append(casedRole);
                    first = false;
                }
                errorString.append(".  Role in service: ").append((String)entry.getKey());
                errors.add(errorString.toString());
            }
            for (String casedRole : caseMapping) {
                warningString.append(firstWarning ? "" : ", ");
                warningString.append(casedRole);
                firstWarning = false;
            }
        }
        for (String error : errors) {
            System.out.println("ERROR: " + error);
        }
        System.out.println("\n");
        System.out.println("Warning: " + warningString.toString());
        if (errors.size() > 0) {
            SentryConfigurationException ex = new SentryConfigurationException("Compatibility check failure");
            ex.setConfigErrors(errors);
            ex.setConfigWarnings(Lists.asList((Object)warningString.toString(), (Object[])new String[0]));
            throw ex;
        }
    }

    private String dryRunMessage(boolean importPolicy) {
        if (importPolicy) {
            return "";
        }
        return "[Dry Run] ";
    }

    public static void main(String[] args) throws Exception {
        SentryConfigToolSolr solrTool = new SentryConfigToolSolr();
        try {
            solrTool.executeConfigTool(args);
        }
        catch (Exception e) {
            Throwable current;
            LOGGER.error(e.getMessage(), (Throwable)e);
            for (current = e; current != null && current.getMessage() == null; current = current.getCause()) {
            }
            String error = "";
            if (current != null && current.getMessage() != null) {
                error = "Message: " + current.getMessage();
            }
            System.out.println("The operation failed. " + error);
            System.exit(1);
        }
    }
}

