/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.cli.tools;

import com.google.common.annotations.VisibleForTesting;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public abstract class SentryConfigToolCommon {
    private String policyFile;
    private boolean validate;
    private boolean importPolicy;
    private boolean checkCompat;
    private String confPath;

    protected boolean parseArgs(String[] args) {
        Options options = new Options();
        Option globalPolicyPath = new Option("p", "policy_ini", true, "Policy file path");
        globalPolicyPath.setRequired(true);
        options.addOption(globalPolicyPath);
        Option validateOpt = new Option("v", "validate", false, "Validate policy file");
        validateOpt.setRequired(false);
        options.addOption(validateOpt);
        Option checkCompatOpt = new Option("c", "checkcompat", false, "Check compatibility with Sentry Service");
        checkCompatOpt.setRequired(false);
        options.addOption(checkCompatOpt);
        Option importOpt = new Option("i", "import", false, "Import policy file");
        importOpt.setRequired(false);
        options.addOption(importOpt);
        Option sentrySitePathOpt = new Option("conf", "sentry_conf", true, "sentry-site file path");
        sentrySitePathOpt.setRequired(true);
        options.addOption(sentrySitePathOpt);
        Option helpOpt = new Option("h", "help", false, "Shell usage");
        helpOpt.setRequired(false);
        options.addOption(helpOpt);
        Options helpOptions = new Options();
        helpOptions.addOption(helpOpt);
        try {
            GnuParser parser = new GnuParser();
            CommandLine cmd = parser.parse(helpOptions, args, true);
            for (Option opt : cmd.getOptions()) {
                if (!opt.getOpt().equals("h")) continue;
                this.usage(options);
                return false;
            }
            cmd = parser.parse(options, args);
            for (Option opt : cmd.getOptions()) {
                if (opt.getOpt().equals("p")) {
                    this.policyFile = opt.getValue();
                    continue;
                }
                if (opt.getOpt().equals("v")) {
                    this.validate = true;
                    continue;
                }
                if (opt.getOpt().equals("i")) {
                    this.importPolicy = true;
                    continue;
                }
                if (opt.getOpt().equals("c")) {
                    this.checkCompat = true;
                    continue;
                }
                if (!opt.getOpt().equals("conf")) continue;
                this.confPath = opt.getValue();
            }
            if (!this.validate && !this.importPolicy) {
                throw new IllegalArgumentException("No action specified; at least one of action or import must be specified");
            }
        }
        catch (ParseException pe) {
            System.out.println(pe.getMessage());
            this.usage(options);
            return false;
        }
        return true;
    }

    private void usage(Options sentryOptions) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("sentryConfigTool", sentryOptions);
    }

    public abstract void run() throws Exception;

    @VisibleForTesting
    public boolean executeConfigTool(String[] args) throws Exception {
        boolean result = true;
        if (this.parseArgs(args)) {
            this.run();
        } else {
            result = false;
        }
        return result;
    }

    public String getPolicyFile() {
        return this.policyFile;
    }

    public boolean getValidate() {
        return this.validate;
    }

    public boolean getImportPolicy() {
        return this.importPolicy;
    }

    public boolean getCheckCompat() {
        return this.checkCompat;
    }

    public String getConfPath() {
        return this.confPath;
    }
}

