/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.cli.tools;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.apache.hadoop.conf.Configuration;
import org.apache.sentry.cli.tools.PermissionsMigrationToolCommon;
import org.apache.sentry.core.model.solr.validator.SolrPrivilegeValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PermissionsMigrationToolSolr
extends PermissionsMigrationToolCommon {
    private static final Logger LOGGER = LoggerFactory.getLogger(PermissionsMigrationToolSolr.class);

    @Override
    protected String getComponent(Configuration conf) {
        return "SOLR";
    }

    @Override
    protected String getServiceName(Configuration conf) {
        return conf.get("sentry.service.client.solr.service.name", "service1");
    }

    @Override
    protected Collection<String> transformPrivileges(Collection<String> privileges) {
        ArrayList<String> result = new ArrayList<String>();
        boolean migrated = false;
        if (this.getSourceVersion().major == 1) {
            for (String p : privileges) {
                SolrPrivilegeValidator v = new SolrPrivilegeValidator();
                v.validate(p, false);
                if ("collection".equalsIgnoreCase(v.getEntityType()) && "admin".equalsIgnoreCase(v.getEntityName())) {
                    result.add(this.getPermissionStr("admin", "collections", v.getActionName()));
                    result.add(this.getPermissionStr("admin", "cores", v.getActionName()));
                    migrated = true;
                    continue;
                }
                if ("collection".equalsIgnoreCase(v.getEntityType()) && "*".equals(v.getEntityName())) {
                    result.add(this.getPermissionStr("admin", "collections", v.getActionName()));
                    result.add(this.getPermissionStr("admin", "cores", v.getActionName()));
                    result.add(p);
                    migrated = true;
                    continue;
                }
                result.add(p);
            }
        }
        return migrated ? result : Collections.emptyList();
    }

    private String getPermissionStr(String entityType, String entityName, String action) {
        StringBuilder builder = new StringBuilder();
        builder.append(entityType);
        builder.append("=");
        builder.append(entityName);
        if (action != null) {
            builder.append("->");
            builder.append("action");
            builder.append("=");
            builder.append(action);
        }
        return builder.toString();
    }

    public static void main(String[] args) throws Exception {
        PermissionsMigrationToolSolr solrTool = new PermissionsMigrationToolSolr();
        try {
            solrTool.executeConfigTool(args);
        }
        catch (Exception e) {
            Throwable current;
            LOGGER.error(e.getMessage(), (Throwable)e);
            for (current = e; current != null && current.getMessage() == null; current = current.getCause()) {
            }
            String error = "";
            if (current != null && current.getMessage() != null) {
                error = "Message: " + current.getMessage();
            }
            System.out.println("The operation failed. " + error);
            System.exit(1);
        }
    }
}

