/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.hbase;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hive.metastore.hbase.HBaseConnection;
import org.apache.hadoop.hive.metastore.hbase.HBaseUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VanillaHBaseConnection
implements HBaseConnection {
    private static final Logger LOG = LoggerFactory.getLogger((String)VanillaHBaseConnection.class.getName());
    protected Connection conn;
    protected Map<String, Table> tables = new HashMap<String, Table>();
    protected Configuration conf;

    VanillaHBaseConnection() {
    }

    @Override
    public void connect() throws IOException {
        if (this.conf == null) {
            throw new RuntimeException("Must call getConf before connect");
        }
        this.conn = ConnectionFactory.createConnection((Configuration)this.conf);
    }

    @Override
    public void close() throws IOException {
        for (Table htab : this.tables.values()) {
            htab.close();
        }
        if (this.conn != null) {
            this.conn.close();
        }
    }

    @Override
    public void beginTransaction() throws IOException {
    }

    @Override
    public void commitTransaction() throws IOException {
    }

    @Override
    public void rollbackTransaction() throws IOException {
    }

    @Override
    public void flush(Table htab) throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createHBaseTable(String tableName, List<byte[]> columnFamilies) throws IOException {
        try (Object admin = null;){
            this.conn.getAdmin();
            LOG.info("Creating HBase table " + tableName);
            admin.createTable((TableDescriptor)this.buildDescriptor(tableName, columnFamilies));
        }
    }

    protected HTableDescriptor buildDescriptor(String tableName, List<byte[]> columnFamilies) throws IOException {
        HTableDescriptor tableDesc = new HTableDescriptor(TableName.valueOf((String)tableName));
        for (byte[] cf : columnFamilies) {
            tableDesc.addFamily(new HColumnDescriptor(cf));
        }
        return tableDesc;
    }

    @Override
    public Table getHBaseTable(String tableName) throws IOException {
        return this.getHBaseTable(tableName, false);
    }

    @Override
    public Table getHBaseTable(String tableName, boolean force) throws IOException {
        Table htab = this.tables.get(tableName);
        if (htab == null) {
            LOG.debug("Trying to connect to table " + tableName);
            try {
                htab = this.conn.getTable(TableName.valueOf((String)tableName));
                if (force) {
                    htab.get(new Get("nosuchkey".getBytes(HBaseUtils.ENCODING)));
                }
            }
            catch (IOException e) {
                LOG.info("Caught exception when table was missing");
                return null;
            }
            this.tables.put(tableName, htab);
        }
        return htab;
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    public Configuration getConf() {
        return this.conf;
    }
}

