/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.hbase;

import co.cask.tephra.TransactionAware;
import co.cask.tephra.TransactionContext;
import co.cask.tephra.TransactionFailureException;
import co.cask.tephra.TransactionManager;
import co.cask.tephra.TransactionSystemClient;
import co.cask.tephra.distributed.ThreadLocalClientProvider;
import co.cask.tephra.distributed.ThriftClientProvider;
import co.cask.tephra.distributed.TransactionServiceClient;
import co.cask.tephra.hbase10.coprocessor.TransactionProcessor;
import co.cask.tephra.inmemory.InMemoryTxSystemClient;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.hbase.HBaseReadWrite;
import org.apache.hadoop.hive.metastore.hbase.VanillaHBaseConnection;
import org.apache.twill.discovery.DiscoveryServiceClient;
import org.apache.twill.discovery.InMemoryDiscoveryService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TephraHBaseConnection
extends VanillaHBaseConnection {
    private static final Logger LOG = LoggerFactory.getLogger((String)TephraHBaseConnection.class.getName());
    private Map<String, TransactionAware> txnTables = new HashMap<String, TransactionAware>();
    private TransactionContext txn;
    private TransactionSystemClient txnClient;

    TephraHBaseConnection() {
    }

    @Override
    public void connect() throws IOException {
        super.connect();
        if (HiveConf.getBoolVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_IN_TEST)) {
            LOG.debug("Using an in memory client transaction system for testing");
            TransactionManager txnMgr = new TransactionManager(this.conf);
            txnMgr.startAndWait();
            this.txnClient = new InMemoryTxSystemClient(txnMgr);
        } else {
            LOG.debug("Using real client transaction system for production");
            this.txnClient = new TransactionServiceClient(this.conf, (ThriftClientProvider)new ThreadLocalClientProvider(this.conf, (DiscoveryServiceClient)new InMemoryDiscoveryService()));
        }
        for (String string : HBaseReadWrite.tableNames) {
        }
        this.txn = new TransactionContext(this.txnClient, this.txnTables.values());
    }

    @Override
    public void beginTransaction() throws IOException {
        try {
            this.txn.start();
            LOG.debug("Started txn in tephra");
        }
        catch (TransactionFailureException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void commitTransaction() throws IOException {
        try {
            this.txn.finish();
            LOG.debug("Finished txn in tephra");
        }
        catch (TransactionFailureException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void rollbackTransaction() throws IOException {
        try {
            this.txn.abort();
            LOG.debug("Aborted txn in tephra");
        }
        catch (TransactionFailureException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void flush(Table htab) throws IOException {
    }

    @Override
    protected HTableDescriptor buildDescriptor(String tableName, List<byte[]> columnFamilies) throws IOException {
        HTableDescriptor tableDesc = super.buildDescriptor(tableName, columnFamilies);
        tableDesc.addCoprocessor(TransactionProcessor.class.getName());
        return tableDesc;
    }

    @Override
    public Table getHBaseTable(String tableName, boolean force) throws IOException {
        return super.getHBaseTable(tableName, force);
    }
}

