/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedExpressions;
import org.apache.hadoop.hive.ql.exec.vector.expressions.PosModDoubleToDouble;
import org.apache.hadoop.hive.ql.exec.vector.expressions.PosModLongToLong;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFBaseNumeric;
import org.apache.hadoop.hive.serde2.io.ByteWritable;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.io.ShortWritable;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;

@Description(name="pmod", value="a _FUNC_ b - Compute the positive modulo")
@VectorizedExpressions(value={PosModLongToLong.class, PosModDoubleToDouble.class})
public class GenericUDFPosMod
extends GenericUDFBaseNumeric {
    public GenericUDFPosMod() {
        this.opDisplayName = "pmod";
    }

    @Override
    protected ByteWritable evaluate(ByteWritable left, ByteWritable right) {
        if (right.get() == 0) {
            return null;
        }
        this.byteWritable.set((byte)((left.get() % right.get() + right.get()) % right.get()));
        return this.byteWritable;
    }

    @Override
    protected ShortWritable evaluate(ShortWritable left, ShortWritable right) {
        if (right.get() == 0) {
            return null;
        }
        this.shortWritable.set((short)((left.get() % right.get() + right.get()) % right.get()));
        return this.shortWritable;
    }

    @Override
    protected IntWritable evaluate(IntWritable left, IntWritable right) {
        if (right.get() == 0) {
            return null;
        }
        this.intWritable.set((left.get() % right.get() + right.get()) % right.get());
        return this.intWritable;
    }

    @Override
    protected LongWritable evaluate(LongWritable left, LongWritable right) {
        if (right.get() == 0L) {
            return null;
        }
        this.longWritable.set((left.get() % right.get() + right.get()) % right.get());
        return this.longWritable;
    }

    @Override
    protected FloatWritable evaluate(FloatWritable left, FloatWritable right) {
        if (right.get() == 0.0f) {
            return null;
        }
        this.floatWritable.set((left.get() % right.get() + right.get()) % right.get());
        return this.floatWritable;
    }

    @Override
    protected DoubleWritable evaluate(DoubleWritable left, DoubleWritable right) {
        if (right.get() == 0.0) {
            return null;
        }
        this.doubleWritable.set((left.get() % right.get() + right.get()) % right.get());
        return this.doubleWritable;
    }

    @Override
    protected HiveDecimalWritable evaluate(HiveDecimal left, HiveDecimal right) {
        if (right.compareTo(HiveDecimal.ZERO) == 0) {
            return null;
        }
        HiveDecimal dec = left.remainder(right).add(right).remainder(right);
        if (dec == null) {
            return null;
        }
        this.decimalWritable.set(dec);
        return this.decimalWritable;
    }

    @Override
    protected DecimalTypeInfo deriveResultDecimalTypeInfo(int prec1, int scale1, int prec2, int scale2) {
        int scale = Math.max(scale1, scale2);
        int prec = Math.min(38, Math.max(prec1 - scale1, prec2 - scale2) + scale);
        return TypeInfoFactory.getDecimalTypeInfo(prec, scale);
    }
}

