/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan.ptf;

import org.apache.hadoop.hive.ql.parse.WindowingSpec;
import org.apache.hadoop.hive.ql.plan.ptf.BoundaryDef;
import org.apache.hadoop.hive.ql.plan.ptf.OrderDef;
import org.apache.hadoop.hive.ql.plan.ptf.OrderExpressionDef;

public class ValueBoundaryDef
extends BoundaryDef {
    private OrderDef orderDef;
    private final int amt;
    private final int relativeOffset;

    public ValueBoundaryDef(WindowingSpec.Direction direction, int amt) {
        this.direction = direction;
        this.amt = amt;
        this.orderDef = new OrderDef();
        switch (this.direction) {
            case PRECEDING: {
                this.relativeOffset = -amt;
                break;
            }
            case FOLLOWING: {
                this.relativeOffset = amt;
                break;
            }
            default: {
                this.relativeOffset = 0;
            }
        }
    }

    public int compareTo(BoundaryDef other) {
        int c = this.getDirection().compareTo(other.getDirection());
        if (c != 0) {
            return c;
        }
        ValueBoundaryDef vb = (ValueBoundaryDef)other;
        return this.direction == WindowingSpec.Direction.PRECEDING ? vb.amt - this.amt : this.amt - vb.amt;
    }

    public OrderDef getOrderDef() {
        return this.orderDef;
    }

    public void addOrderExpressionDef(OrderExpressionDef expressionDef) {
        this.orderDef.addExpression(expressionDef);
    }

    @Override
    public int getAmt() {
        return this.amt;
    }

    @Override
    public int getRelativeOffset() {
        return this.relativeOffset;
    }

    @Override
    public boolean isPreceding() {
        return this.direction == WindowingSpec.Direction.PRECEDING;
    }

    @Override
    public boolean isFollowing() {
        return this.direction == WindowingSpec.Direction.FOLLOWING;
    }
}

