/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import java.util.HashMap;
import org.antlr.runtime.tree.Tree;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.CalcitePlanner;
import org.apache.hadoop.hive.ql.parse.ColumnStatsSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.DDLSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ExplainSQRewriteSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ExplainSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ExportSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.FunctionSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ImportSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.LoadSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.MacroSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.UpdateDeleteSemanticAnalyzer;
import org.apache.hadoop.hive.ql.plan.HiveOperation;

public final class SemanticAnalyzerFactory {
    static HashMap<Integer, HiveOperation> commandType = new HashMap();
    static HashMap<Integer, HiveOperation[]> tablePartitionCommandType = new HashMap();

    public static BaseSemanticAnalyzer get(QueryState queryState, ASTNode tree) throws SemanticException {
        if (tree.getToken() == null) {
            throw new RuntimeException("Empty Syntax Tree");
        }
        HiveOperation opType = commandType.get(tree.getType());
        queryState.setCommandType(opType);
        switch (tree.getType()) {
            case 751: {
                return new ExplainSemanticAnalyzer(queryState);
            }
            case 752: {
                return new ExplainSQRewriteSemanticAnalyzer(queryState);
            }
            case 812: {
                return new LoadSemanticAnalyzer(queryState);
            }
            case 754: {
                return new ExportSemanticAnalyzer(queryState);
            }
            case 781: {
                return new ImportSemanticAnalyzer(queryState);
            }
            case 660: {
                Tree child = tree.getChild(1);
                switch (child.getType()) {
                    case 661: 
                    case 662: 
                    case 663: 
                    case 664: 
                    case 669: 
                    case 670: 
                    case 671: 
                    case 672: 
                    case 676: 
                    case 677: 
                    case 678: 
                    case 679: 
                    case 680: 
                    case 682: 
                    case 685: 
                    case 687: 
                    case 688: 
                    case 690: {
                        queryState.setCommandType(commandType.get(child.getType()));
                        return new DDLSemanticAnalyzer(queryState);
                    }
                }
                opType = tablePartitionCommandType.get(child.getType())[tree.getChildCount() > 2 ? 1 : 0];
                queryState.setCommandType(opType);
                return new DDLSemanticAnalyzer(queryState);
            }
            case 692: {
                Tree child = tree.getChild(1);
                switch (child.getType()) {
                    case 693: 
                    case 694: 
                    case 695: 
                    case 696: 
                    case 697: {
                        opType = commandType.get(child.getType());
                        queryState.setCommandType(opType);
                        return new DDLSemanticAnalyzer(queryState);
                    }
                }
                assert (child.getType() == 875);
                queryState.setCommandType(HiveOperation.ALTERVIEW_AS);
                return new SemanticAnalyzer(queryState);
            }
            case 651: 
            case 655: 
            case 656: 
            case 657: 
            case 658: 
            case 659: 
            case 667: 
            case 704: 
            case 712: 
            case 714: 
            case 717: 
            case 734: 
            case 735: 
            case 736: 
            case 743: 
            case 745: 
            case 747: 
            case 748: 
            case 749: 
            case 766: 
            case 768: 
            case 813: 
            case 814: 
            case 818: 
            case 886: 
            case 887: 
            case 903: 
            case 904: 
            case 905: 
            case 906: 
            case 907: 
            case 908: 
            case 909: 
            case 910: 
            case 911: 
            case 912: 
            case 913: 
            case 914: 
            case 915: 
            case 916: 
            case 917: 
            case 918: 
            case 919: 
            case 920: 
            case 921: 
            case 922: 
            case 941: 
            case 983: 
            case 991: 
            case 992: {
                return new DDLSemanticAnalyzer(queryState);
            }
            case 713: 
            case 744: 
            case 879: {
                return new FunctionSemanticAnalyzer(queryState);
            }
            case 698: {
                return new ColumnStatsSemanticAnalyzer(queryState);
            }
            case 716: 
            case 746: {
                return new MacroSemanticAnalyzer(queryState);
            }
            case 733: 
            case 993: {
                return new UpdateDeleteSemanticAnalyzer(queryState);
            }
        }
        SemanticAnalyzer semAnalyzer = HiveConf.getBoolVar(queryState.getConf(), HiveConf.ConfVars.HIVE_CBO_ENABLED) ? new CalcitePlanner(queryState) : new SemanticAnalyzer(queryState);
        return semAnalyzer;
    }

    private SemanticAnalyzerFactory() {
    }

    static HiveOperation getOperation(int hiveParserToken) {
        return commandType.get(hiveParserToken);
    }

    static {
        commandType.put(751, HiveOperation.EXPLAIN);
        commandType.put(812, HiveOperation.LOAD);
        commandType.put(754, HiveOperation.EXPORT);
        commandType.put(781, HiveOperation.IMPORT);
        commandType.put(712, HiveOperation.CREATEDATABASE);
        commandType.put(743, HiveOperation.DROPDATABASE);
        commandType.put(941, HiveOperation.SWITCHDATABASE);
        commandType.put(718, HiveOperation.CREATETABLE);
        commandType.put(983, HiveOperation.TRUNCATETABLE);
        commandType.put(748, HiveOperation.DROPTABLE);
        commandType.put(736, HiveOperation.DESCTABLE);
        commandType.put(735, HiveOperation.DESCFUNCTION);
        commandType.put(818, HiveOperation.MSCK);
        commandType.put(661, HiveOperation.ALTERTABLE_ADDCOLS);
        commandType.put(682, HiveOperation.ALTERTABLE_REPLACECOLS);
        commandType.put(680, HiveOperation.ALTERTABLE_RENAMECOL);
        commandType.put(679, HiveOperation.ALTERTABLE_RENAME);
        commandType.put(670, HiveOperation.ALTERTABLE_DROPPARTS);
        commandType.put(663, HiveOperation.ALTERTABLE_ADDPARTS);
        commandType.put(687, HiveOperation.ALTERTABLE_TOUCH);
        commandType.put(664, HiveOperation.ALTERTABLE_ARCHIVE);
        commandType.put(688, HiveOperation.ALTERTABLE_UNARCHIVE);
        commandType.put(678, HiveOperation.ALTERTABLE_PROPERTIES);
        commandType.put(671, HiveOperation.ALTERTABLE_PROPERTIES);
        commandType.put(672, HiveOperation.ALTERTABLE_EXCHANGEPARTITION);
        commandType.put(669, HiveOperation.ALTERTABLE_DROPCONSTRAINT);
        commandType.put(662, HiveOperation.ALTERTABLE_ADDCONSTRAINT);
        commandType.put(690, HiveOperation.ALTERTABLE_UPDATECOLUMNS);
        commandType.put(905, HiveOperation.SHOWDATABASES);
        commandType.put(911, HiveOperation.SHOWTABLES);
        commandType.put(903, HiveOperation.SHOWCOLUMNS);
        commandType.put(920, HiveOperation.SHOW_TABLESTATUS);
        commandType.put(921, HiveOperation.SHOW_TBLPROPERTIES);
        commandType.put(913, HiveOperation.SHOW_CREATEDATABASE);
        commandType.put(914, HiveOperation.SHOW_CREATETABLE);
        commandType.put(907, HiveOperation.SHOWFUNCTIONS);
        commandType.put(908, HiveOperation.SHOWINDEXES);
        commandType.put(910, HiveOperation.SHOWPARTITIONS);
        commandType.put(909, HiveOperation.SHOWLOCKS);
        commandType.put(906, HiveOperation.SHOWLOCKS);
        commandType.put(904, HiveOperation.SHOWCONF);
        commandType.put(713, HiveOperation.CREATEFUNCTION);
        commandType.put(744, HiveOperation.DROPFUNCTION);
        commandType.put(879, HiveOperation.RELOADFUNCTION);
        commandType.put(716, HiveOperation.CREATEMACRO);
        commandType.put(746, HiveOperation.DROPMACRO);
        commandType.put(719, HiveOperation.CREATEVIEW);
        commandType.put(749, HiveOperation.DROPVIEW);
        commandType.put(714, HiveOperation.CREATEINDEX);
        commandType.put(745, HiveOperation.DROPINDEX);
        commandType.put(659, HiveOperation.ALTERINDEX_REBUILD);
        commandType.put(658, HiveOperation.ALTERINDEX_PROPS);
        commandType.put(696, HiveOperation.ALTERVIEW_PROPERTIES);
        commandType.put(695, HiveOperation.ALTERVIEW_PROPERTIES);
        commandType.put(693, HiveOperation.ALTERTABLE_ADDPARTS);
        commandType.put(694, HiveOperation.ALTERTABLE_DROPPARTS);
        commandType.put(676, HiveOperation.ALTERTABLE_OWNER);
        commandType.put(697, HiveOperation.ALTERVIEW_RENAME);
        commandType.put(692, HiveOperation.ALTERVIEW_AS);
        commandType.put(875, HiveOperation.QUERY);
        commandType.put(814, HiveOperation.LOCKTABLE);
        commandType.put(992, HiveOperation.UNLOCKTABLE);
        commandType.put(813, HiveOperation.LOCKDB);
        commandType.put(991, HiveOperation.UNLOCKDB);
        commandType.put(717, HiveOperation.CREATEROLE);
        commandType.put(747, HiveOperation.DROPROLE);
        commandType.put(766, HiveOperation.GRANT_PRIVILEGE);
        commandType.put(886, HiveOperation.REVOKE_PRIVILEGE);
        commandType.put(915, HiveOperation.SHOW_GRANT);
        commandType.put(768, HiveOperation.GRANT_ROLE);
        commandType.put(887, HiveOperation.REVOKE_ROLE);
        commandType.put(916, HiveOperation.SHOW_ROLES);
        commandType.put(919, HiveOperation.SHOW_ROLES);
        commandType.put(918, HiveOperation.SHOW_ROLE_PRINCIPALS);
        commandType.put(917, HiveOperation.SHOW_ROLE_GRANT);
        commandType.put(657, HiveOperation.ALTERDATABASE);
        commandType.put(656, HiveOperation.ALTERDATABASE_OWNER);
        commandType.put(655, HiveOperation.ALTERDATABASE_LOCATION);
        commandType.put(734, HiveOperation.DESCDATABASE);
        commandType.put(685, HiveOperation.ALTERTABLE_SKEWED);
        commandType.put(698, HiveOperation.ANALYZE_TABLE);
        commandType.put(704, HiveOperation.CACHE_METADATA);
        commandType.put(677, HiveOperation.ALTERTABLE_PARTCOLTYPE);
        commandType.put(912, HiveOperation.SHOW_COMPACTIONS);
        commandType.put(922, HiveOperation.SHOW_TRANSACTIONS);
        commandType.put(651, HiveOperation.ABORT_TRANSACTIONS);
        commandType.put(928, HiveOperation.START_TRANSACTION);
        commandType.put(711, HiveOperation.COMMIT);
        commandType.put(890, HiveOperation.ROLLBACK);
        commandType.put(901, HiveOperation.SET_AUTOCOMMIT);
        tablePartitionCommandType.put(673, new HiveOperation[]{HiveOperation.ALTERTABLE_FILEFORMAT, HiveOperation.ALTERPARTITION_FILEFORMAT});
        tablePartitionCommandType.put(674, new HiveOperation[]{HiveOperation.ALTERTABLE_LOCATION, HiveOperation.ALTERPARTITION_LOCATION});
        tablePartitionCommandType.put(675, new HiveOperation[]{HiveOperation.ALTERTABLE_MERGEFILES, HiveOperation.ALTERPARTITION_MERGEFILES});
        tablePartitionCommandType.put(684, new HiveOperation[]{HiveOperation.ALTERTABLE_SERIALIZER, HiveOperation.ALTERPARTITION_SERIALIZER});
        tablePartitionCommandType.put(683, new HiveOperation[]{HiveOperation.ALTERTABLE_SERDEPROPERTIES, HiveOperation.ALTERPARTITION_SERDEPROPERTIES});
        tablePartitionCommandType.put(681, new HiveOperation[]{null, HiveOperation.ALTERTABLE_RENAMEPART});
        tablePartitionCommandType.put(668, new HiveOperation[]{HiveOperation.ALTERTABLE_COMPACT, HiveOperation.ALTERTABLE_COMPACT});
        tablePartitionCommandType.put(686, new HiveOperation[]{HiveOperation.ALTERTBLPART_SKEWED_LOCATION, HiveOperation.ALTERTBLPART_SKEWED_LOCATION});
        tablePartitionCommandType.put(665, new HiveOperation[]{HiveOperation.ALTERTABLE_BUCKETNUM, HiveOperation.ALTERPARTITION_BUCKETNUM});
        tablePartitionCommandType.put(667, new HiveOperation[]{HiveOperation.ALTERTABLE_CLUSTER_SORT, HiveOperation.ALTERTABLE_CLUSTER_SORT});
        tablePartitionCommandType.put(689, new HiveOperation[]{HiveOperation.ALTERTABLE_UPDATETABLESTATS, HiveOperation.ALTERTABLE_UPDATEPARTSTATS});
        tablePartitionCommandType.put(691, new HiveOperation[]{HiveOperation.ALTERTABLE_UPDATETABLESTATS, HiveOperation.ALTERTABLE_UPDATEPARTSTATS});
    }
}

