/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.mapjoin;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.CompilationOpContext;
import org.apache.hadoop.hive.ql.HashTableLoaderFactory;
import org.apache.hadoop.hive.ql.exec.HashTableLoader;
import org.apache.hadoop.hive.ql.exec.MapJoinOperator;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorColumnMapping;
import org.apache.hadoop.hive.ql.exec.vector.VectorColumnOutputMapping;
import org.apache.hadoop.hive.ql.exec.vector.VectorColumnSourceMapping;
import org.apache.hadoop.hive.ql.exec.vector.VectorCopyRow;
import org.apache.hadoop.hive.ql.exec.vector.VectorDeserializeRow;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizationContext;
import org.apache.hadoop.hive.ql.exec.vector.VectorizationContextRegion;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedBatchUtil;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast.VectorMapJoinFastHashTableLoader;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.hashtable.VectorMapJoinHashTable;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.hashtable.VectorMapJoinTableContainer;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.optimized.VectorMapJoinOptimizedCreateHashTable;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.MapJoinDesc;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.VectorMapJoinDesc;
import org.apache.hadoop.hive.ql.plan.VectorMapJoinInfo;
import org.apache.hadoop.hive.ql.plan.api.OperatorType;
import org.apache.hadoop.hive.serde2.lazybinary.fast.LazyBinaryDeserializeRead;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class VectorMapJoinCommonOperator
extends MapJoinOperator
implements VectorizationContextRegion {
    private static final long serialVersionUID = 1L;
    private static final String CLASS_NAME = VectorMapJoinCommonOperator.class.getName();
    private static final Logger LOG = LoggerFactory.getLogger((String)CLASS_NAME);
    protected transient String loggingPrefix;
    protected VectorMapJoinDesc vectorDesc;
    protected VectorMapJoinInfo vectorMapJoinInfo;
    protected boolean isOuterJoin;
    protected byte posSingleVectorMapJoinSmallTable;
    protected VectorizationContext vContext;
    protected VectorizationContext vOutContext;
    protected int[] outputProjection;
    protected TypeInfo[] outputTypeInfos;
    protected VectorExpression[] bigTableFilterExpressions;
    protected VectorExpression[] bigTableKeyExpressions;
    protected VectorExpression[] bigTableValueExpressions;
    protected int[] bigTableKeyColumnMap;
    protected String[] bigTableKeyColumnNames;
    protected TypeInfo[] bigTableKeyTypeInfos;
    protected int[] bigTableValueColumnMap;
    protected String[] bigTableValueColumnNames;
    protected TypeInfo[] bigTableValueTypeInfos;
    protected VectorColumnOutputMapping bigTableRetainedMapping;
    protected VectorColumnOutputMapping bigTableOuterKeyMapping;
    protected VectorColumnSourceMapping smallTableMapping;
    protected VectorColumnSourceMapping projectionMapping;
    protected int[] smallTableOutputVectorColumns;
    protected int[] bigTableOuterKeyOutputVectorColumns;
    protected int[] bigTableByteColumnVectorColumns;
    protected int[] smallTableByteColumnVectorColumns;
    protected transient boolean useOverflowRepeatedThreshold;
    protected transient int overflowRepeatedThreshold;
    protected transient VectorCopyRow bigTableRetainedVectorCopy;
    protected transient VectorCopyRow bigTableVectorCopyOuterKeys;
    protected transient VectorDeserializeRow<LazyBinaryDeserializeRead> smallTableVectorDeserializeRow;
    protected transient VectorizedRowBatch overflowBatch;
    protected transient VectorizedRowBatch spillReplayBatch;
    protected transient boolean needCommonSetup;
    protected transient boolean needHashTableSetup;
    protected transient VectorMapJoinHashTable vectorMapJoinHashTable;

    protected abstract String getLoggingPrefix();

    protected String getLoggingPrefix(String className) {
        if (this.loggingPrefix == null) {
            this.initLoggingPrefix(className);
        }
        return this.loggingPrefix;
    }

    protected void initLoggingPrefix(String className) {
        this.loggingPrefix = className;
    }

    protected VectorMapJoinCommonOperator() {
    }

    public VectorMapJoinCommonOperator(CompilationOpContext ctx) {
        super(ctx);
    }

    public VectorMapJoinCommonOperator(CompilationOpContext ctx, VectorizationContext vContext, OperatorDesc conf) throws HiveException {
        super(ctx);
        MapJoinDesc desc = (MapJoinDesc)conf;
        this.conf = desc;
        this.vectorDesc = (VectorMapJoinDesc)desc.getVectorDesc();
        this.vectorMapJoinInfo = this.vectorDesc.getVectorMapJoinInfo();
        Preconditions.checkState(this.vectorMapJoinInfo != null);
        this.vContext = vContext;
        this.vOutContext = new VectorizationContext(this.getName(), this.vContext);
        this.order = desc.getTagOrder();
        this.posBigTable = (byte)desc.getPosBigTable();
        this.posSingleVectorMapJoinSmallTable = this.order[0] == this.posBigTable ? this.order[1] : this.order[0];
        this.isOuterJoin = !desc.getNoOuterJoin();
        Map<Byte, List<ExprNodeDesc>> filterExpressions = desc.getFilters();
        this.bigTableFilterExpressions = vContext.getVectorExpressions(filterExpressions.get(this.posBigTable), VectorExpressionDescriptor.Mode.FILTER);
        this.bigTableKeyColumnMap = this.vectorMapJoinInfo.getBigTableKeyColumnMap();
        this.bigTableKeyColumnNames = this.vectorMapJoinInfo.getBigTableKeyColumnNames();
        this.bigTableKeyTypeInfos = this.vectorMapJoinInfo.getBigTableKeyTypeInfos();
        this.bigTableKeyExpressions = this.vectorMapJoinInfo.getBigTableKeyExpressions();
        this.bigTableValueColumnMap = this.vectorMapJoinInfo.getBigTableValueColumnMap();
        this.bigTableValueColumnNames = this.vectorMapJoinInfo.getBigTableValueColumnNames();
        this.bigTableValueTypeInfos = this.vectorMapJoinInfo.getBigTableValueTypeInfos();
        this.bigTableValueExpressions = this.vectorMapJoinInfo.getBigTableValueExpressions();
        this.bigTableRetainedMapping = this.vectorMapJoinInfo.getBigTableRetainedMapping();
        this.bigTableOuterKeyMapping = this.vectorMapJoinInfo.getBigTableOuterKeyMapping();
        this.smallTableMapping = this.vectorMapJoinInfo.getSmallTableMapping();
        this.projectionMapping = this.vectorMapJoinInfo.getProjectionMapping();
        this.determineCommonInfo(this.isOuterJoin);
    }

    protected void determineCommonInfo(boolean isOuter) throws HiveException {
        this.bigTableOuterKeyOutputVectorColumns = this.bigTableOuterKeyMapping.getOutputColumns();
        this.smallTableOutputVectorColumns = this.smallTableMapping.getOutputColumns();
        this.bigTableByteColumnVectorColumns = this.getByteColumnVectorColumns(this.bigTableOuterKeyMapping);
        this.smallTableByteColumnVectorColumns = this.getByteColumnVectorColumns(this.smallTableMapping);
        this.outputProjection = this.projectionMapping.getOutputColumns();
        this.outputTypeInfos = this.projectionMapping.getTypeInfos();
        if (LOG.isDebugEnabled()) {
            int[] orderDisplayable = new int[this.order.length];
            for (int i = 0; i < this.order.length; ++i) {
                orderDisplayable[i] = this.order[i].byteValue();
            }
            LOG.debug(this.getLoggingPrefix() + " VectorMapJoinCommonOperator constructor order " + Arrays.toString(orderDisplayable));
            LOG.debug(this.getLoggingPrefix() + " VectorMapJoinCommonOperator constructor posBigTable " + this.posBigTable);
            LOG.debug(this.getLoggingPrefix() + " VectorMapJoinCommonOperator constructor posSingleVectorMapJoinSmallTable " + this.posSingleVectorMapJoinSmallTable);
            LOG.debug(this.getLoggingPrefix() + " VectorMapJoinCommonOperator constructor bigTableKeyColumnMap " + Arrays.toString(this.bigTableKeyColumnMap));
            LOG.debug(this.getLoggingPrefix() + " VectorMapJoinCommonOperator constructor bigTableKeyColumnNames " + Arrays.toString(this.bigTableKeyColumnNames));
            LOG.debug(this.getLoggingPrefix() + " VectorMapJoinCommonOperator constructor bigTableKeyTypeInfos " + Arrays.toString(this.bigTableKeyTypeInfos));
            LOG.debug(this.getLoggingPrefix() + " VectorMapJoinCommonOperator constructor bigTableValueColumnMap " + Arrays.toString(this.bigTableValueColumnMap));
            LOG.debug(this.getLoggingPrefix() + " VectorMapJoinCommonOperator constructor bigTableValueColumnNames " + Arrays.toString(this.bigTableValueColumnNames));
            LOG.debug(this.getLoggingPrefix() + " VectorMapJoinCommonOperator constructor bigTableValueTypeNames " + Arrays.toString(this.bigTableValueTypeInfos));
            LOG.debug(this.getLoggingPrefix() + " VectorMapJoinCommonOperator constructor bigTableRetainedMapping " + this.bigTableRetainedMapping.toString());
            LOG.debug(this.getLoggingPrefix() + " VectorMapJoinCommonOperator constructor bigTableOuterKeyMapping " + this.bigTableOuterKeyMapping.toString());
            LOG.debug(this.getLoggingPrefix() + " VectorMapJoinCommonOperator constructor smallTableMapping " + this.smallTableMapping.toString());
            LOG.debug(this.getLoggingPrefix() + " VectorMapJoinCommonOperator constructor bigTableByteColumnVectorColumns " + Arrays.toString(this.bigTableByteColumnVectorColumns));
            LOG.debug(this.getLoggingPrefix() + " VectorMapJoinCommonOperator constructor smallTableByteColumnVectorColumns " + Arrays.toString(this.smallTableByteColumnVectorColumns));
            LOG.debug(this.getLoggingPrefix() + " VectorMapJoinCommonOperator constructor outputProjection " + Arrays.toString(this.outputProjection));
            LOG.debug(this.getLoggingPrefix() + " VectorMapJoinCommonOperator constructor outputTypeInfos " + Arrays.toString(this.outputTypeInfos));
        }
        this.setupVOutContext(((MapJoinDesc)this.conf).getOutputColumnNames());
    }

    private int[] getByteColumnVectorColumns(VectorColumnMapping mapping) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        int count = mapping.getCount();
        int[] outputColumns = mapping.getOutputColumns();
        TypeInfo[] typeInfos = mapping.getTypeInfos();
        for (int i = 0; i < count; ++i) {
            int outputColumn = outputColumns[i];
            String typeName = typeInfos[i].getTypeName();
            if (!VectorizationContext.isStringFamily(typeName)) continue;
            list.add(outputColumn);
        }
        return ArrayUtils.toPrimitive(list.toArray(new Integer[0]));
    }

    protected void setupVOutContext(List<String> outputColumnNames) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(this.getLoggingPrefix() + " VectorMapJoinCommonOperator constructor outputColumnNames " + outputColumnNames);
        }
        if (outputColumnNames.size() != this.outputProjection.length) {
            throw new RuntimeException("Output column names " + outputColumnNames + " length and output projection " + Arrays.toString(this.outputProjection) + " / " + Arrays.toString(this.outputTypeInfos) + " length mismatch");
        }
        this.vOutContext.resetProjectionColumns();
        for (int i = 0; i < outputColumnNames.size(); ++i) {
            String columnName = outputColumnNames.get(i);
            int outputColumn = this.outputProjection[i];
            this.vOutContext.addProjectionColumn(columnName, outputColumn);
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug(this.getLoggingPrefix() + " VectorMapJoinCommonOperator constructor addProjectionColumn " + i + " columnName " + columnName + " outputColumn " + outputColumn);
        }
    }

    @Override
    protected HashTableLoader getHashTableLoader(Configuration hconf) {
        HashTableLoader hashTableLoader;
        VectorMapJoinDesc vectorDesc = (VectorMapJoinDesc)((MapJoinDesc)this.conf).getVectorDesc();
        VectorMapJoinDesc.HashTableImplementationType hashTableImplementationType = vectorDesc.hashTableImplementationType();
        switch (vectorDesc.hashTableImplementationType()) {
            case OPTIMIZED: {
                hashTableLoader = HashTableLoaderFactory.getLoader(hconf);
                break;
            }
            case FAST: {
                hashTableLoader = HiveConf.getVar(hconf, HiveConf.ConfVars.HIVE_EXECUTION_ENGINE).equals("spark") ? HashTableLoaderFactory.getLoader(hconf) : new VectorMapJoinFastHashTableLoader();
                break;
            }
            default: {
                throw new RuntimeException("Unknown vector map join hash table implementation type " + hashTableImplementationType.name());
            }
        }
        return hashTableLoader;
    }

    @Override
    protected void initializeOp(Configuration hconf) throws HiveException {
        super.initializeOp(hconf);
        this.overflowRepeatedThreshold = HiveConf.getIntVar(hconf, HiveConf.ConfVars.HIVE_VECTORIZATION_MAPJOIN_NATIVE_OVERFLOW_REPEATED_THRESHOLD);
        boolean bl = this.useOverflowRepeatedThreshold = this.overflowRepeatedThreshold >= 0;
        if (this.smallTableMapping.getCount() > 0) {
            this.smallTableVectorDeserializeRow = new VectorDeserializeRow<LazyBinaryDeserializeRead>(new LazyBinaryDeserializeRead(this.smallTableMapping.getTypeInfos(), true));
            this.smallTableVectorDeserializeRow.init(this.smallTableMapping.getOutputColumns());
        }
        if (this.bigTableRetainedMapping.getCount() > 0) {
            this.bigTableRetainedVectorCopy = new VectorCopyRow();
            this.bigTableRetainedVectorCopy.init(this.bigTableRetainedMapping);
        }
        if (this.bigTableOuterKeyMapping.getCount() > 0) {
            this.bigTableVectorCopyOuterKeys = new VectorCopyRow();
            this.bigTableVectorCopyOuterKeys.init(this.bigTableOuterKeyMapping);
        }
        this.overflowBatch = this.setupOverflowBatch();
        this.needCommonSetup = true;
        this.needHashTableSetup = true;
        if (LOG.isDebugEnabled()) {
            int[] currentScratchColumns = this.vOutContext.currentScratchColumns();
            LOG.debug(this.getLoggingPrefix() + " VectorMapJoinCommonOperator initializeOp currentScratchColumns " + Arrays.toString(currentScratchColumns));
            StructObjectInspector structOutputObjectInspector = (StructObjectInspector)this.outputObjInspector;
            List<? extends StructField> fields = structOutputObjectInspector.getAllStructFieldRefs();
            int i = 0;
            for (StructField structField : fields) {
                LOG.debug(this.getLoggingPrefix() + " VectorMapJoinCommonOperator initializeOp " + i + " field " + structField.getFieldName() + " type " + structField.getFieldObjectInspector().getTypeName());
                ++i;
            }
        }
    }

    @Override
    protected void completeInitializationOp(Object[] os) throws HiveException {
        super.completeInitializationOp(os);
        VectorMapJoinDesc vectorDesc = (VectorMapJoinDesc)((MapJoinDesc)this.conf).getVectorDesc();
        VectorMapJoinDesc.HashTableImplementationType hashTableImplementationType = vectorDesc.hashTableImplementationType();
        switch (vectorDesc.hashTableImplementationType()) {
            case OPTIMIZED: {
                this.vectorMapJoinHashTable = VectorMapJoinOptimizedCreateHashTable.createHashTable((MapJoinDesc)this.conf, this.mapJoinTables[this.posSingleVectorMapJoinSmallTable]);
                break;
            }
            case FAST: {
                VectorMapJoinTableContainer vectorMapJoinTableContainer = (VectorMapJoinTableContainer)this.mapJoinTables[this.posSingleVectorMapJoinSmallTable];
                this.vectorMapJoinHashTable = vectorMapJoinTableContainer.vectorMapJoinHashTable();
                break;
            }
            default: {
                throw new RuntimeException("Unknown vector map join hash table implementation type " + hashTableImplementationType.name());
            }
        }
        LOG.info("Using " + this.vectorMapJoinHashTable.getClass().getSimpleName() + " from " + this.getClass().getSimpleName());
    }

    protected VectorizedRowBatch setupOverflowBatch() throws HiveException {
        int initialColumnCount = this.vContext.firstOutputColumnIndex();
        int totalNumColumns = initialColumnCount + this.vOutContext.getScratchColumnTypeNames().length;
        VectorizedRowBatch overflowBatch = new VectorizedRowBatch(totalNumColumns);
        for (int i = 0; i < this.outputProjection.length; ++i) {
            int outputColumn = this.outputProjection[i];
            String typeName = this.outputTypeInfos[i].getTypeName();
            this.allocateOverflowBatchColumnVector(overflowBatch, outputColumn, typeName);
        }
        int outputColumn = initialColumnCount;
        for (String typeName : this.vOutContext.getScratchColumnTypeNames()) {
            this.allocateOverflowBatchColumnVector(overflowBatch, outputColumn++, typeName);
        }
        overflowBatch.projectedColumns = this.outputProjection;
        overflowBatch.projectionSize = this.outputProjection.length;
        overflowBatch.reset();
        return overflowBatch;
    }

    private void allocateOverflowBatchColumnVector(VectorizedRowBatch overflowBatch, int outputColumn, String typeName) throws HiveException {
        if (overflowBatch.cols[outputColumn] == null) {
            typeName = VectorizationContext.mapTypeNameSynonyms(typeName);
            TypeInfo typeInfo = TypeInfoUtils.getTypeInfoFromTypeString(typeName);
            overflowBatch.cols[outputColumn] = VectorizedBatchUtil.createColumnVector(typeInfo);
            if (LOG.isDebugEnabled()) {
                LOG.debug(this.getLoggingPrefix() + " VectorMapJoinCommonOperator initializeOp overflowBatch outputColumn " + outputColumn + " class " + overflowBatch.cols[outputColumn].getClass().getSimpleName());
            }
        }
    }

    protected void commonSetup(VectorizedRowBatch batch) throws HiveException {
        BytesColumnVector bytesColumnVector;
        if (LOG.isDebugEnabled()) {
            LOG.debug("VectorMapJoinInnerCommonOperator commonSetup begin...");
            this.displayBatchColumns(batch, "batch");
            this.displayBatchColumns(this.overflowBatch, "overflowBatch");
        }
        for (int column : this.bigTableByteColumnVectorColumns) {
            bytesColumnVector = (BytesColumnVector)this.overflowBatch.cols[column];
            bytesColumnVector.initBuffer();
        }
        for (int column : this.smallTableByteColumnVectorColumns) {
            bytesColumnVector = (BytesColumnVector)batch.cols[column];
            bytesColumnVector.initBuffer();
            bytesColumnVector = (BytesColumnVector)this.overflowBatch.cols[column];
            bytesColumnVector.initBuffer();
        }
        this.spillReplayBatch = VectorizedBatchUtil.makeLike(batch);
    }

    protected void displayBatchColumns(VectorizedRowBatch batch, String batchName) {
        LOG.debug(this.getLoggingPrefix() + " VectorMapJoinCommonOperator commonSetup " + batchName + " column count " + batch.numCols);
        for (int column = 0; column < batch.numCols; ++column) {
            LOG.debug(this.getLoggingPrefix() + " VectorMapJoinCommonOperator commonSetup " + batchName + "     column " + column + " type " + (batch.cols[column] == null ? "NULL" : batch.cols[column].getClass().getSimpleName()));
        }
    }

    @Override
    public OperatorType getType() {
        return OperatorType.MAPJOIN;
    }

    @Override
    public VectorizationContext getOuputVectorizationContext() {
        return this.vOutContext;
    }
}

