/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.metadata.HiveException;

public class IfExprColumnNull
extends VectorExpression {
    private static final long serialVersionUID = 1L;
    private final int arg1Column;
    private final int arg2Column;
    private final int outputColumn;

    public IfExprColumnNull(int arg1Column, int arg2Column, int outputColumn) {
        this.arg1Column = arg1Column;
        this.arg2Column = arg2Column;
        this.outputColumn = outputColumn;
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) throws HiveException {
        if (this.childExpressions != null) {
            super.evaluateChildren(batch);
        }
        LongColumnVector arg1ColVector = (LongColumnVector)batch.cols[this.arg1Column];
        ColumnVector arg2ColVector = batch.cols[this.arg2Column];
        ColumnVector outputColVector = batch.cols[this.outputColumn];
        int[] sel = batch.selected;
        int n = batch.size;
        boolean[] null1 = arg1ColVector.isNull;
        long[] vector1 = arg1ColVector.vector;
        boolean[] isNull = outputColVector.isNull;
        if (n == 0) {
            return;
        }
        outputColVector.isRepeating = false;
        if (arg1ColVector.isRepeating) {
            if ((arg1ColVector.noNulls || !null1[0]) && vector1[0] == 1L) {
                arg2ColVector.copySelected(batch.selectedInUse, sel, n, outputColVector);
            } else {
                outputColVector.isRepeating = true;
                outputColVector.noNulls = false;
                isNull[0] = true;
            }
            return;
        }
        if (arg1ColVector.noNulls) {
            if (arg2ColVector.isRepeating) {
                if (batch.selectedInUse) {
                    for (int j = 0; j < n; ++j) {
                        int i = sel[j];
                        if (vector1[i] == 1L) {
                            isNull[i] = false;
                            outputColVector.setElement(i, 0, arg2ColVector);
                            continue;
                        }
                        isNull[i] = true;
                        outputColVector.noNulls = false;
                    }
                } else {
                    for (int i = 0; i < n; ++i) {
                        if (vector1[i] == 1L) {
                            isNull[i] = false;
                            outputColVector.setElement(i, 0, arg2ColVector);
                            continue;
                        }
                        isNull[i] = true;
                        outputColVector.noNulls = false;
                    }
                }
            } else if (batch.selectedInUse) {
                for (int j = 0; j < n; ++j) {
                    int i = sel[j];
                    if (vector1[i] == 1L) {
                        isNull[i] = false;
                        outputColVector.setElement(i, i, arg2ColVector);
                        continue;
                    }
                    isNull[i] = true;
                    outputColVector.noNulls = false;
                }
            } else {
                for (int i = 0; i < n; ++i) {
                    if (vector1[i] == 1L) {
                        isNull[i] = false;
                        outputColVector.setElement(i, i, arg2ColVector);
                        continue;
                    }
                    isNull[i] = true;
                    outputColVector.noNulls = false;
                }
            }
        } else if (arg2ColVector.isRepeating) {
            if (batch.selectedInUse) {
                for (int j = 0; j < n; ++j) {
                    int i = sel[j];
                    if (!null1[i] && vector1[i] == 1L) {
                        isNull[i] = false;
                        outputColVector.setElement(i, 0, arg2ColVector);
                        continue;
                    }
                    isNull[i] = true;
                    outputColVector.noNulls = false;
                }
            } else {
                for (int i = 0; i < n; ++i) {
                    if (!null1[i] && vector1[i] == 1L) {
                        isNull[i] = false;
                        outputColVector.setElement(i, 0, arg2ColVector);
                        continue;
                    }
                    isNull[i] = true;
                    outputColVector.noNulls = false;
                }
            }
        } else if (batch.selectedInUse) {
            for (int j = 0; j < n; ++j) {
                int i = sel[j];
                if (!null1[i] && vector1[i] == 1L) {
                    isNull[i] = false;
                    outputColVector.setElement(i, i, arg2ColVector);
                    continue;
                }
                isNull[i] = true;
                outputColVector.noNulls = false;
            }
        } else {
            for (int i = 0; i < n; ++i) {
                if (!null1[i] && vector1[i] == 1L) {
                    isNull[i] = false;
                    outputColVector.setElement(i, i, arg2ColVector);
                    continue;
                }
                isNull[i] = true;
                outputColVector.noNulls = false;
            }
        }
    }

    @Override
    public int getOutputColumn() {
        return this.outputColumn;
    }

    @Override
    public String vectorExpressionParameters() {
        return "col " + this.arg1Column + ", col " + this.arg2Column + ", null";
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        throw new UnsupportedOperationException("Undefined descriptor");
    }
}

