/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import java.sql.Timestamp;
import java.util.Arrays;
import org.apache.hadoop.hive.ql.exec.vector.IntervalDayTimeColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.NullUtil;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.util.DateTimeMath;
import org.apache.hadoop.hive.serde2.io.DateWritable;

public class DateColSubtractDateScalar
extends VectorExpression {
    private static final long serialVersionUID = 1L;
    private int colNum;
    private Timestamp value;
    private int outputColumn;
    private Timestamp scratchTimestamp1;
    private DateTimeMath dtm = new DateTimeMath();

    public DateColSubtractDateScalar(int colNum, long value, int outputColumn) {
        this.colNum = colNum;
        this.value = new Timestamp(0L);
        this.value.setTime(DateWritable.daysToMillis((int)value));
        this.outputColumn = outputColumn;
        this.scratchTimestamp1 = new Timestamp(0L);
    }

    public DateColSubtractDateScalar() {
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) throws HiveException {
        if (this.childExpressions != null) {
            super.evaluateChildren(batch);
        }
        LongColumnVector inputColVector1 = (LongColumnVector)batch.cols[this.colNum];
        IntervalDayTimeColumnVector outputColVector = (IntervalDayTimeColumnVector)batch.cols[this.outputColumn];
        int[] sel = batch.selected;
        boolean[] inputIsNull = inputColVector1.isNull;
        boolean[] outputIsNull = outputColVector.isNull;
        int n = batch.size;
        long[] vector1 = inputColVector1.vector;
        if (n == 0) {
            return;
        }
        outputColVector.isRepeating = false;
        if (inputColVector1.isRepeating) {
            if (inputColVector1.noNulls || !inputIsNull[0]) {
                outputIsNull[0] = false;
                this.scratchTimestamp1.setTime(DateWritable.daysToMillis((int)vector1[0]));
                this.dtm.subtract(this.scratchTimestamp1, this.value, outputColVector.getScratchIntervalDayTime());
                outputColVector.setFromScratchIntervalDayTime(0);
            } else {
                outputIsNull[0] = true;
                outputColVector.noNulls = false;
            }
            outputColVector.isRepeating = true;
            NullUtil.setNullOutputEntriesColScalar(outputColVector, batch.selectedInUse, sel, n);
            return;
        }
        if (inputColVector1.noNulls) {
            if (batch.selectedInUse) {
                if (!outputColVector.noNulls) {
                    for (int j = 0; j != n; ++j) {
                        int i = sel[j];
                        outputIsNull[i] = false;
                        this.scratchTimestamp1.setTime(DateWritable.daysToMillis((int)vector1[i]));
                        this.dtm.subtract(this.scratchTimestamp1, this.value, outputColVector.getScratchIntervalDayTime());
                        outputColVector.setFromScratchIntervalDayTime(i);
                    }
                } else {
                    for (int j = 0; j != n; ++j) {
                        int i = sel[j];
                        this.scratchTimestamp1.setTime(DateWritable.daysToMillis((int)vector1[i]));
                        this.dtm.subtract(this.scratchTimestamp1, this.value, outputColVector.getScratchIntervalDayTime());
                        outputColVector.setFromScratchIntervalDayTime(i);
                    }
                }
            } else {
                if (!outputColVector.noNulls) {
                    Arrays.fill(outputIsNull, false);
                    outputColVector.noNulls = true;
                }
                for (int i = 0; i != n; ++i) {
                    this.scratchTimestamp1.setTime(DateWritable.daysToMillis((int)vector1[i]));
                    this.dtm.subtract(this.scratchTimestamp1, this.value, outputColVector.getScratchIntervalDayTime());
                    outputColVector.setFromScratchIntervalDayTime(i);
                }
            }
        } else {
            outputColVector.noNulls = false;
            if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    outputIsNull[i] = inputIsNull[i];
                    this.scratchTimestamp1.setTime(DateWritable.daysToMillis((int)vector1[i]));
                    this.dtm.subtract(this.scratchTimestamp1, this.value, outputColVector.getScratchIntervalDayTime());
                    outputColVector.setFromScratchIntervalDayTime(i);
                }
            } else {
                System.arraycopy(inputIsNull, 0, outputIsNull, 0, n);
                for (int i = 0; i != n; ++i) {
                    this.scratchTimestamp1.setTime(DateWritable.daysToMillis((int)vector1[i]));
                    this.dtm.subtract(this.scratchTimestamp1, this.value, outputColVector.getScratchIntervalDayTime());
                    outputColVector.setFromScratchIntervalDayTime(i);
                }
            }
        }
        NullUtil.setNullOutputEntriesColScalar(outputColVector, batch.selectedInUse, sel, n);
    }

    @Override
    public int getOutputColumn() {
        return this.outputColumn;
    }

    @Override
    public String vectorExpressionParameters() {
        return "col " + this.colNum + ", val " + this.value;
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        return new VectorExpressionDescriptor.Builder().setMode(VectorExpressionDescriptor.Mode.PROJECTION).setNumArguments(2).setArgumentTypes(VectorExpressionDescriptor.ArgumentType.getType("date"), VectorExpressionDescriptor.ArgumentType.getType("date")).setInputExpressionTypes(VectorExpressionDescriptor.InputExpressionType.COLUMN, VectorExpressionDescriptor.InputExpressionType.SCALAR).build();
    }
}

