/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.core.common.utils;

import com.google.common.base.Preconditions;
import com.google.common.net.HostAndPort;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TSaslClientTransport;
import org.apache.thrift.transport.TSaslServerTransport;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ThriftUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(ThriftUtil.class);
    private static ThreadLocal<String> threadLocalIpAddress = new ThreadLocal<String>(){

        @Override
        protected synchronized String initialValue() {
            return "";
        }
    };
    private static ThreadLocal<String> threadLocalImpersonator = new ThreadLocal<String>(){

        @Override
        protected synchronized String initialValue() {
            return "";
        }
    };

    public static void setImpersonator(TProtocol in) {
        try {
            TTransport transport = in.getTransport();
            if (transport instanceof TSaslServerTransport) {
                String impersonator = ((TSaslServerTransport)transport).getSaslServer().getAuthorizationID();
                ThriftUtil.setImpersonator(impersonator);
            }
        }
        catch (Exception e) {
            LOGGER.warn("There is an error when get the impersonator:" + e.getMessage());
        }
    }

    public static void setIpAddress(TProtocol in) {
        try {
            TTransport transport = in.getTransport();
            TSocket tSocket = ThriftUtil.getUnderlyingSocketFromTransport(transport);
            if (tSocket != null) {
                ThriftUtil.setIpAddress(tSocket.getSocket().getInetAddress().toString());
            } else {
                LOGGER.warn("Unknown Transport, cannot determine ipAddress");
            }
        }
        catch (Exception e) {
            LOGGER.warn("There is an error when get the client's ip address:" + e.getMessage());
        }
    }

    private static TSocket getUnderlyingSocketFromTransport(TTransport transport) {
        Preconditions.checkNotNull((Object)transport);
        if (transport instanceof TSaslServerTransport) {
            return (TSocket)((TSaslServerTransport)transport).getUnderlyingTransport();
        }
        if (transport instanceof TSaslClientTransport) {
            return (TSocket)((TSaslClientTransport)transport).getUnderlyingTransport();
        }
        if (transport instanceof TSocket) {
            return (TSocket)transport;
        }
        return null;
    }

    public static void setIpAddress(String ipAddress) {
        threadLocalIpAddress.set(ipAddress);
    }

    public static String getIpAddress() {
        return threadLocalIpAddress.get();
    }

    public static void setImpersonator(String impersonator) {
        threadLocalImpersonator.set(impersonator);
    }

    public static String getImpersonator() {
        return threadLocalImpersonator.get();
    }

    private ThriftUtil() {
    }

    public static HostAndPort parseAddress(String address, int defaultPort) {
        return HostAndPort.fromString((String)address).withDefaultPort(defaultPort);
    }
}

