/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.core.common.transport;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.net.HostAndPort;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.security.PrivilegedExceptionAction;
import java.util.Map;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.SaslRpcServer;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.sentry.core.common.transport.SentryClientTransportConfigInterface;
import org.apache.sentry.core.common.transport.TTransportWrapper;
import org.apache.sentry.core.common.transport.TransportFactory;
import org.apache.thrift.transport.TSaslClientTransport;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class SentryTransportFactory
implements TransportFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(SentryTransportFactory.class);
    private final boolean useUgi;
    private final String serverPrincipal;
    private final int connectionTimeout;
    private final boolean isKerberosEnabled;
    private static final ImmutableMap<String, String> SASL_PROPERTIES = ImmutableMap.of((Object)"javax.security.sasl.server.authentication", (Object)"true", (Object)"javax.security.sasl.qop", (Object)"auth-conf");

    public SentryTransportFactory(Configuration conf, SentryClientTransportConfigInterface transportConfig) {
        Preconditions.checkNotNull((Object)conf, (Object)"Configuration object cannot be null");
        this.connectionTimeout = transportConfig.getServerRpcConnTimeoutInMs(conf);
        this.isKerberosEnabled = transportConfig.isKerberosEnabled(conf);
        if (this.isKerberosEnabled) {
            this.useUgi = transportConfig.useUserGroupInformation(conf);
            this.serverPrincipal = transportConfig.getSentryPrincipal(conf);
        } else {
            this.serverPrincipal = null;
            this.useUgi = false;
        }
    }

    @Override
    public TTransportWrapper getTransport(HostAndPort endpoint) throws Exception {
        return new TTransportWrapper(this.connectToServer(new InetSocketAddress(endpoint.getHostText(), endpoint.getPort())), endpoint);
    }

    private TTransport connectToServer(InetSocketAddress serverAddress) throws Exception {
        TTransport thriftTransport = this.createTransport(serverAddress);
        thriftTransport.open();
        LOGGER.debug("Successfully opened transport {} to {}", (Object)thriftTransport, (Object)serverAddress);
        return thriftTransport;
    }

    private TTransport createTransport(InetSocketAddress serverAddress) throws IOException {
        String hostName = serverAddress.getHostName();
        int port = serverAddress.getPort();
        TSocket socket = new TSocket(hostName, port, this.connectionTimeout);
        if (!this.isKerberosEnabled) {
            LOGGER.debug("created unprotected connection to {}:{} ", (Object)hostName, (Object)port);
            return socket;
        }
        String principal = SecurityUtil.getServerPrincipal((String)this.serverPrincipal, (InetAddress)serverAddress.getAddress());
        String[] serverPrincipalParts = SaslRpcServer.splitKerberosName((String)principal);
        if (serverPrincipalParts.length != 3) {
            throw new IOException("Kerberos principal should have 3 parts: " + principal);
        }
        UgiSaslClientTransport connection = new UgiSaslClientTransport(SaslRpcServer.AuthMethod.KERBEROS.getMechanismName(), serverPrincipalParts[0], serverPrincipalParts[1], (TTransport)socket, this.useUgi);
        LOGGER.debug("creating secured connection to {}:{} ", (Object)hostName, (Object)port);
        return connection;
    }

    private static class UgiSaslClientTransport
    extends TSaslClientTransport {
        private UserGroupInformation ugi = null;

        UgiSaslClientTransport(String mechanism, String protocol, String serverName, TTransport transport, boolean wrapUgi) throws IOException {
            super(mechanism, null, protocol, serverName, (Map)SASL_PROPERTIES, null, transport);
            if (wrapUgi) {
                this.ugi = UserGroupInformation.getLoginUser();
            }
        }

        public void open() throws TTransportException {
            if (this.ugi == null) {
                this.baseOpen();
            } else {
                try {
                    if (this.ugi.isFromKeytab()) {
                        this.ugi.checkTGTAndReloginFromKeytab();
                    }
                    this.ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                        @Override
                        public Void run() throws TTransportException {
                            this.baseOpen();
                            return null;
                        }
                    });
                }
                catch (IOException e) {
                    throw new TTransportException("Failed to open SASL transport: " + e.getMessage(), (Throwable)e);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new TTransportException("Interrupted while opening underlying transport: " + e.getMessage(), (Throwable)e);
                }
            }
        }

        private void baseOpen() throws TTransportException {
            super.open();
        }
    }
}

