/*
 * Decompiled with CFR 0.152.
 */
package org.cloudera.log4j2.redactor;

import java.io.IOException;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.rewrite.RewritePolicy;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.impl.Log4jLogEvent;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.SimpleMessage;
import org.cloudera.log4j.redactor.StringRedactor;

@Plugin(name="RedactorPolicy", category="Core", elementType="layout", printObject=true)
public class RedactorPolicy
implements RewritePolicy {
    private String rules;
    private StringRedactor redactor;

    @PluginFactory
    public static RedactorPolicy createPolicy(@PluginAttribute(value="name") String name, @PluginAttribute(value="rules") String rules) {
        return new RedactorPolicy(rules);
    }

    protected RedactorPolicy(String rules) {
        this.rules = rules;
        try {
            this.redactor = StringRedactor.createFromJsonFile(rules);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Problem with rules file " + rules, e);
        }
    }

    public LogEvent rewrite(LogEvent source) {
        String redacted;
        String original;
        Message msg;
        if (source != null && (msg = source.getMessage()) != null && (original = msg.getFormattedMessage()) != null && !(redacted = this.redactor.redact(original)).equals(original)) {
            source = new Log4jLogEvent.Builder(source).setMessage((Message)new SimpleMessage(redacted)).build();
        }
        return source;
    }
}

