/*
 * Decompiled with CFR 0.152.
 */
package org.cloudera.log4j.redactor;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.cloudera.log4j.redactor.RedactionPolicyParseException;

public class StringRedactor {
    private RedactionPolicy policy;

    private StringRedactor() {
    }

    public static StringRedactor createFromJsonFile(String fileName) throws IOException {
        RedactionPolicy policy;
        StringRedactor sr = new StringRedactor();
        if (fileName == null) {
            sr.policy = RedactionPolicy.emptyRedactionPolicy();
            return sr;
        }
        File file = new File(fileName);
        if (file.exists() && file.length() == 0L) {
            sr.policy = RedactionPolicy.emptyRedactionPolicy();
            return sr;
        }
        ObjectMapper mapper = new ObjectMapper();
        try {
            policy = (RedactionPolicy)mapper.readValue(file, RedactionPolicy.class);
        }
        catch (JsonProcessingException jpe) {
            throw new RedactionPolicyParseException(jpe.getMessage(), jpe.getCause());
        }
        policy.postProcess();
        sr.policy = policy;
        return sr;
    }

    public static StringRedactor createFromJsonString(String json) throws IOException {
        RedactionPolicy policy;
        StringRedactor sr = new StringRedactor();
        if (json == null || json.isEmpty()) {
            sr.policy = RedactionPolicy.emptyRedactionPolicy();
            return sr;
        }
        ObjectMapper mapper = new ObjectMapper();
        try {
            policy = (RedactionPolicy)mapper.readValue(json, RedactionPolicy.class);
        }
        catch (JsonProcessingException jpe) {
            throw new RedactionPolicyParseException(jpe.getMessage(), jpe.getCause());
        }
        policy.postProcess();
        sr.policy = policy;
        return sr;
    }

    public String redact(String msg) {
        return this.policy.redact(msg);
    }

    private static class RedactionPolicy {
        private int version = -1;
        private List<RedactionRule> rules;

        private RedactionPolicy() {
        }

        private static RedactionPolicy emptyRedactionPolicy() {
            RedactionPolicy policy = new RedactionPolicy();
            policy.version = 1;
            policy.rules = new ArrayList<RedactionRule>();
            return policy;
        }

        public void setVersion(int version) {
            this.version = version;
        }

        public void setRules(List<RedactionRule> rules) {
            this.rules = rules;
        }

        private void postProcess() throws RedactionPolicyParseException {
            if (this.version == -1) {
                throw new RedactionPolicyParseException("No version specified.");
            }
            if (this.version != 1) {
                throw new RedactionPolicyParseException("Unknown version " + this.version);
            }
            for (RedactionRule rule : this.rules) {
                rule.postProcess();
            }
        }

        private String redact(String msg) {
            if (msg == null) {
                return null;
            }
            String original = msg;
            boolean matched = false;
            for (RedactionRule rule : this.rules) {
                if (!rule.matchesTrigger(msg)) continue;
                Matcher m = (Matcher)rule.matcherTL.get();
                m.reset(msg);
                if (!m.find()) continue;
                msg = m.replaceAll(rule.replace);
                matched = true;
            }
            return matched ? msg : original;
        }
    }

    private static class RedactionRule {
        private String description;
        private boolean caseSensitive = true;
        private String trigger;
        private String search;
        private String replace;
        private Pattern pattern;
        private ThreadLocal<Matcher> matcherTL;

        private RedactionRule() {
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public void setCaseSensitive(boolean caseSensitive) {
            this.caseSensitive = caseSensitive;
        }

        public void setTrigger(String trigger) {
            this.trigger = trigger;
        }

        public void setSearch(String search) {
            this.search = search;
            Pattern thrownAway = Pattern.compile(search);
        }

        public void setReplace(String replace) {
            this.replace = replace;
        }

        private void postProcess() throws RedactionPolicyParseException {
            if (this.search == null || this.search.isEmpty()) {
                throw new RedactionPolicyParseException("The search regular expression cannot be empty.");
            }
            if (this.replace == null || this.replace.isEmpty()) {
                throw new RedactionPolicyParseException("The replacement text cannot be empty.");
            }
            this.pattern = this.caseSensitive ? Pattern.compile(this.search) : Pattern.compile(this.search, 2);
            this.matcherTL = new ThreadLocal<Matcher>(){

                @Override
                protected Matcher initialValue() {
                    return pattern.matcher("");
                }
            };
            try {
                String sampleString = "Hello, world";
                Matcher m = this.pattern.matcher(sampleString);
                sampleString = m.replaceAll(this.replace);
            }
            catch (Exception e) {
                throw new RedactionPolicyParseException("The replacement text \"" + this.replace + "\" is invalid", e);
            }
        }

        private boolean matchesTrigger(String msg) {
            if (this.trigger == null || this.trigger.isEmpty()) {
                return true;
            }
            if (this.caseSensitive) {
                return msg.contains(this.trigger);
            }
            int len = this.trigger.length();
            int max = msg.length() - len;
            for (int i = 0; i <= max; ++i) {
                if (!msg.regionMatches(true, i, this.trigger, 0, len)) continue;
                return true;
            }
            return false;
        }
    }
}

