/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.core.model.indexer.validator;

import org.apache.sentry.core.common.exception.SentryConfigurationException;
import org.apache.sentry.core.common.validator.PrivilegeValidatorContext;
import org.apache.sentry.core.model.indexer.Indexer;
import org.apache.sentry.core.model.indexer.IndexerModelAuthorizable;
import org.apache.sentry.core.model.indexer.validator.AbstractIndexerPrivilegeValidator;

public class IndexerRequiredInPrivilege
extends AbstractIndexerPrivilegeValidator {
    public void validate(PrivilegeValidatorContext context) throws SentryConfigurationException {
        String privilege = context.getPrivilege();
        Iterable<IndexerModelAuthorizable> authorizables = IndexerRequiredInPrivilege.parsePrivilege(privilege);
        boolean foundIndexerInAuthorizables = false;
        for (IndexerModelAuthorizable authorizable : authorizables) {
            if (!(authorizable instanceof Indexer)) continue;
            foundIndexerInAuthorizables = true;
            break;
        }
        if (!foundIndexerInAuthorizables) {
            String msg = "Missing indexer object in " + privilege;
            throw new SentryConfigurationException(msg);
        }
    }
}

