/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.core.model.indexer.validator;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import org.apache.sentry.core.common.utils.SentryConstants;
import org.apache.sentry.core.common.validator.PrivilegeValidator;
import org.apache.sentry.core.model.indexer.IndexerModelAuthorizable;
import org.apache.sentry.core.model.indexer.IndexerModelAuthorizables;
import org.apache.shiro.config.ConfigurationException;

public abstract class AbstractIndexerPrivilegeValidator
implements PrivilegeValidator {
    @VisibleForTesting
    public static Iterable<IndexerModelAuthorizable> parsePrivilege(String string) {
        ArrayList result = Lists.newArrayList();
        for (String section : SentryConstants.AUTHORIZABLE_SPLITTER.split((CharSequence)string)) {
            if (section.toLowerCase().startsWith(SentryConstants.PRIVILEGE_PREFIX)) continue;
            IndexerModelAuthorizable authorizable = IndexerModelAuthorizables.from(section);
            if (authorizable == null) {
                String msg = "No authorizable found for " + section;
                throw new ConfigurationException(msg);
            }
            result.add(authorizable);
        }
        return result;
    }
}

