/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.hadoop.codec;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CleanUtil {
    private static final Logger logger = LoggerFactory.getLogger(CleanUtil.class);
    private static final Field CLEANER_FIELD;
    private static final Method CLEAN_METHOD;

    public static void clean(ByteBuffer buffer) {
        if (CLEANER_FIELD == null || CLEAN_METHOD == null) {
            return;
        }
        try {
            Object cleaner = CLEANER_FIELD.get(buffer);
            CLEAN_METHOD.invoke(cleaner, new Object[0]);
        }
        catch (IllegalAccessException | NullPointerException | InvocationTargetException e) {
            logger.warn("Clean failed for buffer " + buffer.getClass().getSimpleName(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        ByteBuffer buf = null;
        Field cleanerField = null;
        Method cleanMethod = null;
        try {
            buf = ByteBuffer.allocateDirect(1);
            cleanerField = buf.getClass().getDeclaredField("cleaner");
            cleanerField.setAccessible(true);
            Object cleaner = cleanerField.get(buf);
            cleanMethod = cleaner.getClass().getDeclaredMethod("clean", new Class[0]);
        }
        catch (IllegalAccessException | NoSuchFieldException | NoSuchMethodException e) {
            logger.warn("Initialization failed for cleanerField or cleanMethod", (Throwable)e);
        }
        finally {
            CleanUtil.clean(buf);
        }
        CLEANER_FIELD = cleanerField;
        CLEAN_METHOD = cleanMethod;
    }
}

