/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.service.web;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import java.util.EventListener;
import java.util.HashSet;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.sentry.server.provider.webservice.AttributeDesc;
import org.apache.sentry.server.provider.webservice.FilterDesc;
import org.apache.sentry.server.provider.webservice.ServletDesc;
import org.apache.sentry.server.provider.webservice.WebServiceProvider;
import org.apache.sentry.server.provider.webservice.WebServiceProviderFactory;
import org.apache.sentry.service.common.ServiceConstants;
import org.apache.sentry.spi.ProviderManager;
import org.eclipse.jetty.security.ConstraintMapping;
import org.eclipse.jetty.security.ConstraintSecurityHandler;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.handler.DefaultHandler;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.util.security.Constraint;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SentryWebServer {
    private static final Logger LOGGER = LoggerFactory.getLogger(SentryWebServer.class);
    private Server server = new Server();

    public SentryWebServer(Configuration conf) {
        ServerConnector connector;
        int port = conf.getInt("sentry.service.web.port", 29000);
        if (conf.getBoolean("sentry.web.use.ssl", false)) {
            SslContextFactory sslContextFactory = new SslContextFactory();
            sslContextFactory.setKeyStorePath(conf.get("sentry.web.ssl.keystore.path", ""));
            sslContextFactory.setKeyStorePassword(conf.get("sentry.web.ssl.keystore.password", ""));
            sslContextFactory.setExcludeProtocols(ServiceConstants.ServerConfig.SENTRY_SSL_PROTOCOL_BLACKLIST_DEFAULT);
            HashSet moreExcludedSSLProtocols = Sets.newHashSet((Iterable)Splitter.on((String)",").trimResults().omitEmptyStrings().split((CharSequence)Strings.nullToEmpty((String)conf.get("sentry.ssl.protocol.blacklist"))));
            sslContextFactory.addExcludeProtocols(moreExcludedSSLProtocols.toArray(new String[moreExcludedSSLProtocols.size()]));
            HttpConfiguration httpConfiguration = new HttpConfiguration();
            httpConfiguration.setSecurePort(port);
            httpConfiguration.setSecureScheme("https");
            httpConfiguration.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer());
            connector = new ServerConnector(this.server, new ConnectionFactory[]{new SslConnectionFactory(sslContextFactory, "http/1.1"), new HttpConnectionFactory(httpConfiguration)});
            LOGGER.info("Now using SSL mode.");
        } else {
            connector = new ServerConnector(this.server, new ConnectionFactory[]{new HttpConnectionFactory()});
        }
        connector.setPort(port);
        this.server.setConnectors(new Connector[]{connector});
        ServletContextHandler contextHandler = new ServletContextHandler();
        List serviceProviderFactories = ProviderManager.getInstance().load("sentry-web-service");
        for (WebServiceProviderFactory providerFactory : serviceProviderFactories) {
            providerFactory.init(conf);
            WebServiceProvider provider = (WebServiceProvider)providerFactory.create();
            for (EventListener listener : provider.getListeners()) {
                contextHandler.addEventListener(listener);
            }
            for (AttributeDesc attributeEntry : provider.getAttributes()) {
                contextHandler.getServletContext().setAttribute(attributeEntry.getName(), attributeEntry.getAttribute());
            }
            for (ServletDesc servletEntry : provider.getServlets()) {
                contextHandler.addServlet(servletEntry.getServletHolder(), servletEntry.getPathSpec());
            }
            for (FilterDesc filterDesc : provider.getFilters()) {
                contextHandler.addFilter(filterDesc.getFilterHolder(), filterDesc.getPathSpec(), filterDesc.getDispatcherTypes());
            }
        }
        ContextHandlerCollection contextHandlerCollection = new ContextHandlerCollection();
        contextHandlerCollection.setHandlers(new Handler[]{contextHandler, new DefaultHandler()});
        this.server.setHandler(this.disableTraceMethod((Handler)contextHandlerCollection));
    }

    private Handler disableTraceMethod(Handler handler) {
        Constraint disableTraceConstraint = new Constraint();
        disableTraceConstraint.setName("Disable TRACE");
        disableTraceConstraint.setAuthenticate(true);
        ConstraintMapping mapping = new ConstraintMapping();
        mapping.setConstraint(disableTraceConstraint);
        mapping.setMethod("TRACE");
        mapping.setPathSpec("/");
        ConstraintSecurityHandler constraintSecurityHandler = new ConstraintSecurityHandler();
        constraintSecurityHandler.addConstraintMapping(mapping);
        constraintSecurityHandler.setHandler(handler);
        return constraintSecurityHandler;
    }

    public void start() throws Exception {
        this.server.start();
    }

    public void stop() throws Exception {
        this.server.stop();
    }

    public boolean isAlive() {
        return this.server != null && this.server.isStarted();
    }
}

