/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.service.web;

import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Set;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.security.authentication.server.AuthenticationFilter;
import org.apache.hadoop.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SentryAuthFilter
extends AuthenticationFilter {
    private static final Logger LOG = LoggerFactory.getLogger(SentryAuthFilter.class);
    public static final String ALLOW_WEB_CONNECT_USERS = "sentry.service.web.authentication.allow.connect.users";
    private Set<String> allowUsers;

    protected void doFilter(FilterChain filterChain, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String userName = request.getRemoteUser();
        LOG.debug("Authenticating user: " + userName + " from request.");
        if (!this.allowUsers.contains(userName)) {
            response.sendError(403, "Unauthorized user status code: 403");
            throw new ServletException(userName + " is unauthorized. status code: " + 403);
        }
        super.doFilter(filterChain, request, response);
    }

    protected Properties getConfiguration(String configPrefix, FilterConfig filterConfig) throws ServletException {
        Properties props = new Properties();
        Enumeration names = filterConfig.getInitParameterNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            if (!name.startsWith(configPrefix)) continue;
            String value = filterConfig.getInitParameter(name);
            if (ALLOW_WEB_CONNECT_USERS.equals(name)) {
                this.allowUsers = SentryAuthFilter.parseConnectUsersFromConf(value);
                continue;
            }
            props.put(name.substring(configPrefix.length()), value);
        }
        return props;
    }

    private static Set<String> parseConnectUsersFromConf(String value) {
        return Sets.newHashSet((Object[])StringUtils.getStrings((String)value));
    }
}

