/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.service.web;

import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.sentry.core.common.utils.PubSub;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PubSubServlet
extends HttpServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(PubSubServlet.class);
    private static final String FORM_GET = "<!DOCTYPE html><html><body><form><br><br><b>Topic:</b><br><br><select name='topic'/>%s</select><br><br><b>Message:</b><br><br><input type='text' size='50' name='message'/><br><br><input type='submit' value='Submit'/></form><br><br><b>Status:</b><br><br><textarea rows='4' cols='50'>%s</textarea></body></html>";

    private static String getParameter(ServletRequest request, String name) {
        String s = request.getParameter(name);
        if (s == null) {
            return null;
        }
        return (s = s.trim()).isEmpty() ? null : s;
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String topic = PubSubServlet.getParameter((ServletRequest)request, "topic");
        String message = PubSubServlet.getParameter((ServletRequest)request, "message");
        response.setContentType("text/html;charset=utf-8");
        response.setStatus(200);
        PrintWriter out = response.getWriter();
        String msg = "Topic is required, Message is optional.\nValid topics: " + PubSub.getInstance().getTopics();
        if (topic != null) {
            LOGGER.info("Submitting topic " + topic + ", message " + message);
            try {
                PubSub.getInstance().publish(PubSub.Topic.fromString((String)topic), message);
                msg = "Submitted topic " + topic + ", message " + message;
            }
            catch (Exception e) {
                msg = "Failed to submit topic " + topic + ", message " + message + " - " + e.getMessage();
                LOGGER.error(msg);
                response.sendError(400, msg);
                return;
            }
        }
        StringBuilder topics = new StringBuilder();
        for (PubSub.Topic t : PubSub.getInstance().getTopics()) {
            topics.append("<option>").append(t.getName()).append("</option>");
        }
        String output = String.format(FORM_GET, topics.toString(), StringEscapeUtils.escapeHtml((String)msg));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("HTML Page: " + output);
        }
        out.write(output);
        out.close();
        response.flushBuffer();
    }
}

