/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.service.web;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.hadoop.conf.Configuration;

public class ConfServlet
extends HttpServlet {
    public static final String CONF_CONTEXT_ATTRIBUTE = "sentry.conf";
    public static final String FORMAT_JSON = "json";
    public static final String FORMAT_XML = "xml";
    public static final String FORMAT_PARAM = "format";
    private static final long serialVersionUID = 1L;

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String format = request.getParameter(FORMAT_PARAM);
        if (format == null) {
            format = FORMAT_XML;
        }
        if (FORMAT_XML.equals(format)) {
            response.setContentType("text/xml; charset=utf-8");
        } else if (FORMAT_JSON.equals(format)) {
            response.setContentType("application/json; charset=utf-8");
        }
        Configuration conf = (Configuration)this.getServletContext().getAttribute(CONF_CONTEXT_ATTRIBUTE);
        assert (conf != null);
        PrintWriter out = response.getWriter();
        if (FORMAT_JSON.equals(format)) {
            Configuration.dumpConfiguration((Configuration)conf, (Writer)out);
        } else if (FORMAT_XML.equals(format)) {
            conf.writeXml((Writer)out);
        } else {
            response.sendError(400, "Bad format: " + StringEscapeUtils.escapeHtml((String)format));
        }
        ((Writer)out).close();
    }
}

