/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.hdfs.service.thrift;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.thrift.EncodingUtils;
import org.apache.thrift.TBase;
import org.apache.thrift.TBaseHelper;
import org.apache.thrift.TException;
import org.apache.thrift.TFieldIdEnum;
import org.apache.thrift.meta_data.FieldMetaData;
import org.apache.thrift.meta_data.FieldValueMetaData;
import org.apache.thrift.meta_data.ListMetaData;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TList;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolException;
import org.apache.thrift.protocol.TProtocolUtil;
import org.apache.thrift.protocol.TStruct;
import org.apache.thrift.protocol.TTupleProtocol;
import org.apache.thrift.scheme.IScheme;
import org.apache.thrift.scheme.SchemeFactory;
import org.apache.thrift.scheme.StandardScheme;
import org.apache.thrift.scheme.TupleScheme;
import org.apache.thrift.transport.TIOStreamTransport;
import org.apache.thrift.transport.TTransport;

public class TPathEntry
implements TBase<TPathEntry, _Fields>,
Serializable,
Cloneable,
Comparable<TPathEntry> {
    private static final TStruct STRUCT_DESC = new TStruct("TPathEntry");
    private static final TField TYPE_FIELD_DESC = new TField("type", 3, 1);
    private static final TField PATH_ELEMENT_FIELD_DESC = new TField("pathElement", 11, 2);
    private static final TField CHILDREN_FIELD_DESC = new TField("children", 15, 4);
    private static final TField AUTHZ_OBJS_FIELD_DESC = new TField("authzObjs", 15, 5);
    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    private byte type;
    private String pathElement;
    private List<Integer> children;
    private List<String> authzObjs;
    private static final int __TYPE_ISSET_ID = 0;
    private byte __isset_bitfield = 0;
    private static final _Fields[] optionals;
    public static final Map<_Fields, FieldMetaData> metaDataMap;

    public TPathEntry() {
    }

    public TPathEntry(byte type, String pathElement, List<Integer> children) {
        this();
        this.type = type;
        this.setTypeIsSet(true);
        this.pathElement = pathElement;
        this.children = children;
    }

    public TPathEntry(TPathEntry other) {
        this.__isset_bitfield = other.__isset_bitfield;
        this.type = other.type;
        if (other.isSetPathElement()) {
            this.pathElement = other.pathElement;
        }
        if (other.isSetChildren()) {
            ArrayList<Integer> __this__children = new ArrayList<Integer>(other.children);
            this.children = __this__children;
        }
        if (other.isSetAuthzObjs()) {
            ArrayList<String> __this__authzObjs = new ArrayList<String>(other.authzObjs);
            this.authzObjs = __this__authzObjs;
        }
    }

    public TPathEntry deepCopy() {
        return new TPathEntry(this);
    }

    public void clear() {
        this.setTypeIsSet(false);
        this.type = 0;
        this.pathElement = null;
        this.children = null;
        this.authzObjs = null;
    }

    public byte getType() {
        return this.type;
    }

    public void setType(byte type) {
        this.type = type;
        this.setTypeIsSet(true);
    }

    public void unsetType() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)0);
    }

    public boolean isSetType() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)0);
    }

    public void setTypeIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)0, (boolean)value);
    }

    public String getPathElement() {
        return this.pathElement;
    }

    public void setPathElement(String pathElement) {
        this.pathElement = pathElement;
    }

    public void unsetPathElement() {
        this.pathElement = null;
    }

    public boolean isSetPathElement() {
        return this.pathElement != null;
    }

    public void setPathElementIsSet(boolean value) {
        if (!value) {
            this.pathElement = null;
        }
    }

    public int getChildrenSize() {
        return this.children == null ? 0 : this.children.size();
    }

    public Iterator<Integer> getChildrenIterator() {
        return this.children == null ? null : this.children.iterator();
    }

    public void addToChildren(int elem) {
        if (this.children == null) {
            this.children = new ArrayList<Integer>();
        }
        this.children.add(elem);
    }

    public List<Integer> getChildren() {
        return this.children;
    }

    public void setChildren(List<Integer> children) {
        this.children = children;
    }

    public void unsetChildren() {
        this.children = null;
    }

    public boolean isSetChildren() {
        return this.children != null;
    }

    public void setChildrenIsSet(boolean value) {
        if (!value) {
            this.children = null;
        }
    }

    public int getAuthzObjsSize() {
        return this.authzObjs == null ? 0 : this.authzObjs.size();
    }

    public Iterator<String> getAuthzObjsIterator() {
        return this.authzObjs == null ? null : this.authzObjs.iterator();
    }

    public void addToAuthzObjs(String elem) {
        if (this.authzObjs == null) {
            this.authzObjs = new ArrayList<String>();
        }
        this.authzObjs.add(elem);
    }

    public List<String> getAuthzObjs() {
        return this.authzObjs;
    }

    public void setAuthzObjs(List<String> authzObjs) {
        this.authzObjs = authzObjs;
    }

    public void unsetAuthzObjs() {
        this.authzObjs = null;
    }

    public boolean isSetAuthzObjs() {
        return this.authzObjs != null;
    }

    public void setAuthzObjsIsSet(boolean value) {
        if (!value) {
            this.authzObjs = null;
        }
    }

    public void setFieldValue(_Fields field, Object value) {
        switch (field) {
            case TYPE: {
                if (value == null) {
                    this.unsetType();
                    break;
                }
                this.setType((Byte)value);
                break;
            }
            case PATH_ELEMENT: {
                if (value == null) {
                    this.unsetPathElement();
                    break;
                }
                this.setPathElement((String)value);
                break;
            }
            case CHILDREN: {
                if (value == null) {
                    this.unsetChildren();
                    break;
                }
                this.setChildren((List)value);
                break;
            }
            case AUTHZ_OBJS: {
                if (value == null) {
                    this.unsetAuthzObjs();
                    break;
                }
                this.setAuthzObjs((List)value);
            }
        }
    }

    public Object getFieldValue(_Fields field) {
        switch (field) {
            case TYPE: {
                return this.getType();
            }
            case PATH_ELEMENT: {
                return this.getPathElement();
            }
            case CHILDREN: {
                return this.getChildren();
            }
            case AUTHZ_OBJS: {
                return this.getAuthzObjs();
            }
        }
        throw new IllegalStateException();
    }

    public boolean isSet(_Fields field) {
        if (field == null) {
            throw new IllegalArgumentException();
        }
        switch (field) {
            case TYPE: {
                return this.isSetType();
            }
            case PATH_ELEMENT: {
                return this.isSetPathElement();
            }
            case CHILDREN: {
                return this.isSetChildren();
            }
            case AUTHZ_OBJS: {
                return this.isSetAuthzObjs();
            }
        }
        throw new IllegalStateException();
    }

    public boolean equals(Object that) {
        if (that == null) {
            return false;
        }
        if (that instanceof TPathEntry) {
            return this.equals((TPathEntry)that);
        }
        return false;
    }

    public boolean equals(TPathEntry that) {
        if (that == null) {
            return false;
        }
        boolean this_present_type = true;
        boolean that_present_type = true;
        if (this_present_type || that_present_type) {
            if (!this_present_type || !that_present_type) {
                return false;
            }
            if (this.type != that.type) {
                return false;
            }
        }
        boolean this_present_pathElement = this.isSetPathElement();
        boolean that_present_pathElement = that.isSetPathElement();
        if (this_present_pathElement || that_present_pathElement) {
            if (!this_present_pathElement || !that_present_pathElement) {
                return false;
            }
            if (!this.pathElement.equals(that.pathElement)) {
                return false;
            }
        }
        boolean this_present_children = this.isSetChildren();
        boolean that_present_children = that.isSetChildren();
        if (this_present_children || that_present_children) {
            if (!this_present_children || !that_present_children) {
                return false;
            }
            if (!this.children.equals(that.children)) {
                return false;
            }
        }
        boolean this_present_authzObjs = this.isSetAuthzObjs();
        boolean that_present_authzObjs = that.isSetAuthzObjs();
        if (this_present_authzObjs || that_present_authzObjs) {
            if (!this_present_authzObjs || !that_present_authzObjs) {
                return false;
            }
            if (!this.authzObjs.equals(that.authzObjs)) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        ArrayList<Object> list = new ArrayList<Object>();
        boolean present_type = true;
        list.add(present_type);
        if (present_type) {
            list.add(this.type);
        }
        boolean present_pathElement = this.isSetPathElement();
        list.add(present_pathElement);
        if (present_pathElement) {
            list.add(this.pathElement);
        }
        boolean present_children = this.isSetChildren();
        list.add(present_children);
        if (present_children) {
            list.add(this.children);
        }
        boolean present_authzObjs = this.isSetAuthzObjs();
        list.add(present_authzObjs);
        if (present_authzObjs) {
            list.add(this.authzObjs);
        }
        return list.hashCode();
    }

    @Override
    public int compareTo(TPathEntry other) {
        if (!this.getClass().equals(other.getClass())) {
            return this.getClass().getName().compareTo(other.getClass().getName());
        }
        int lastComparison = 0;
        lastComparison = Boolean.valueOf(this.isSetType()).compareTo(other.isSetType());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetType() && (lastComparison = TBaseHelper.compareTo((byte)this.type, (byte)other.type)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetPathElement()).compareTo(other.isSetPathElement());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetPathElement() && (lastComparison = TBaseHelper.compareTo((String)this.pathElement, (String)other.pathElement)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetChildren()).compareTo(other.isSetChildren());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetChildren() && (lastComparison = TBaseHelper.compareTo(this.children, other.children)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetAuthzObjs()).compareTo(other.isSetAuthzObjs());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetAuthzObjs() && (lastComparison = TBaseHelper.compareTo(this.authzObjs, other.authzObjs)) != 0) {
            return lastComparison;
        }
        return 0;
    }

    public _Fields fieldForId(int fieldId) {
        return _Fields.findByThriftId(fieldId);
    }

    public void read(TProtocol iprot) throws TException {
        schemes.get(iprot.getScheme()).getScheme().read(iprot, (TBase)this);
    }

    public void write(TProtocol oprot) throws TException {
        schemes.get(oprot.getScheme()).getScheme().write(oprot, (TBase)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("TPathEntry(");
        boolean first = true;
        sb.append("type:");
        sb.append(this.type);
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("pathElement:");
        if (this.pathElement == null) {
            sb.append("null");
        } else {
            sb.append(this.pathElement);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("children:");
        if (this.children == null) {
            sb.append("null");
        } else {
            sb.append(this.children);
        }
        first = false;
        if (this.isSetAuthzObjs()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("authzObjs:");
            if (this.authzObjs == null) {
                sb.append("null");
            } else {
                sb.append(this.authzObjs);
            }
            first = false;
        }
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
        if (!this.isSetType()) {
            throw new TProtocolException("Required field 'type' is unset! Struct:" + this.toString());
        }
        if (!this.isSetPathElement()) {
            throw new TProtocolException("Required field 'pathElement' is unset! Struct:" + this.toString());
        }
        if (!this.isSetChildren()) {
            throw new TProtocolException("Required field 'children' is unset! Struct:" + this.toString());
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            this.write((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((OutputStream)out)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.__isset_bitfield = 0;
            this.read((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((InputStream)in)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    static {
        schemes.put(StandardScheme.class, new TPathEntryStandardSchemeFactory());
        schemes.put(TupleScheme.class, new TPathEntryTupleSchemeFactory());
        optionals = new _Fields[]{_Fields.AUTHZ_OBJS};
        EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
        tmpMap.put(_Fields.TYPE, new FieldMetaData("type", 1, new FieldValueMetaData(3)));
        tmpMap.put(_Fields.PATH_ELEMENT, new FieldMetaData("pathElement", 1, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.CHILDREN, new FieldMetaData("children", 1, (FieldValueMetaData)new ListMetaData(15, new FieldValueMetaData(8))));
        tmpMap.put(_Fields.AUTHZ_OBJS, new FieldMetaData("authzObjs", 2, (FieldValueMetaData)new ListMetaData(15, new FieldValueMetaData(11))));
        metaDataMap = Collections.unmodifiableMap(tmpMap);
        FieldMetaData.addStructMetaDataMap(TPathEntry.class, metaDataMap);
    }

    private static class TPathEntryTupleScheme
    extends TupleScheme<TPathEntry> {
        private TPathEntryTupleScheme() {
        }

        public void write(TProtocol prot, TPathEntry struct) throws TException {
            TTupleProtocol oprot = (TTupleProtocol)prot;
            oprot.writeByte(struct.type);
            oprot.writeString(struct.pathElement);
            oprot.writeI32(struct.children.size());
            Iterator iterator = struct.children.iterator();
            while (iterator.hasNext()) {
                int _iter40 = (Integer)iterator.next();
                oprot.writeI32(_iter40);
            }
            BitSet optionals = new BitSet();
            if (struct.isSetAuthzObjs()) {
                optionals.set(0);
            }
            oprot.writeBitSet(optionals, 1);
            if (struct.isSetAuthzObjs()) {
                oprot.writeI32(struct.authzObjs.size());
                for (String _iter41 : struct.authzObjs) {
                    oprot.writeString(_iter41);
                }
            }
        }

        public void read(TProtocol prot, TPathEntry struct) throws TException {
            TTupleProtocol iprot = (TTupleProtocol)prot;
            struct.type = iprot.readByte();
            struct.setTypeIsSet(true);
            struct.pathElement = iprot.readString();
            struct.setPathElementIsSet(true);
            TList _list42 = new TList(8, iprot.readI32());
            struct.children = new ArrayList(_list42.size);
            for (int _i44 = 0; _i44 < _list42.size; ++_i44) {
                int _elem43 = iprot.readI32();
                struct.children.add(_elem43);
            }
            struct.setChildrenIsSet(true);
            BitSet incoming = iprot.readBitSet(1);
            if (incoming.get(0)) {
                TList _list45 = new TList(11, iprot.readI32());
                struct.authzObjs = new ArrayList(_list45.size);
                for (int _i47 = 0; _i47 < _list45.size; ++_i47) {
                    String _elem46 = iprot.readString();
                    struct.authzObjs.add(_elem46);
                }
                struct.setAuthzObjsIsSet(true);
            }
        }
    }

    private static class TPathEntryTupleSchemeFactory
    implements SchemeFactory {
        private TPathEntryTupleSchemeFactory() {
        }

        public TPathEntryTupleScheme getScheme() {
            return new TPathEntryTupleScheme();
        }
    }

    private static class TPathEntryStandardScheme
    extends StandardScheme<TPathEntry> {
        private TPathEntryStandardScheme() {
        }

        public void read(TProtocol iprot, TPathEntry struct) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField schemeField = iprot.readFieldBegin();
                if (schemeField.type == 0) break;
                switch (schemeField.id) {
                    case 1: {
                        if (schemeField.type == 3) {
                            struct.type = iprot.readByte();
                            struct.setTypeIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 2: {
                        if (schemeField.type == 11) {
                            struct.pathElement = iprot.readString();
                            struct.setPathElementIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 4: {
                        if (schemeField.type == 15) {
                            TList _list32 = iprot.readListBegin();
                            struct.children = new ArrayList(_list32.size);
                            for (int _i34 = 0; _i34 < _list32.size; ++_i34) {
                                int _elem33 = iprot.readI32();
                                struct.children.add(_elem33);
                            }
                            iprot.readListEnd();
                            struct.setChildrenIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 5: {
                        if (schemeField.type == 15) {
                            TList _list35 = iprot.readListBegin();
                            struct.authzObjs = new ArrayList(_list35.size);
                            for (int _i37 = 0; _i37 < _list35.size; ++_i37) {
                                String _elem36 = iprot.readString();
                                struct.authzObjs.add(_elem36);
                            }
                            iprot.readListEnd();
                            struct.setAuthzObjsIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            struct.validate();
        }

        public void write(TProtocol oprot, TPathEntry struct) throws TException {
            struct.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            oprot.writeFieldBegin(TYPE_FIELD_DESC);
            oprot.writeByte(struct.type);
            oprot.writeFieldEnd();
            if (struct.pathElement != null) {
                oprot.writeFieldBegin(PATH_ELEMENT_FIELD_DESC);
                oprot.writeString(struct.pathElement);
                oprot.writeFieldEnd();
            }
            if (struct.children != null) {
                oprot.writeFieldBegin(CHILDREN_FIELD_DESC);
                oprot.writeListBegin(new TList(8, struct.children.size()));
                Iterator iterator = struct.children.iterator();
                while (iterator.hasNext()) {
                    int _iter38 = (Integer)iterator.next();
                    oprot.writeI32(_iter38);
                }
                oprot.writeListEnd();
                oprot.writeFieldEnd();
            }
            if (struct.authzObjs != null && struct.isSetAuthzObjs()) {
                oprot.writeFieldBegin(AUTHZ_OBJS_FIELD_DESC);
                oprot.writeListBegin(new TList(11, struct.authzObjs.size()));
                for (String _iter39 : struct.authzObjs) {
                    oprot.writeString(_iter39);
                }
                oprot.writeListEnd();
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }
    }

    private static class TPathEntryStandardSchemeFactory
    implements SchemeFactory {
        private TPathEntryStandardSchemeFactory() {
        }

        public TPathEntryStandardScheme getScheme() {
            return new TPathEntryStandardScheme();
        }
    }

    public static enum _Fields implements TFieldIdEnum
    {
        TYPE(1, "type"),
        PATH_ELEMENT(2, "pathElement"),
        CHILDREN(4, "children"),
        AUTHZ_OBJS(5, "authzObjs");

        private static final Map<String, _Fields> byName;
        private final short _thriftId;
        private final String _fieldName;

        public static _Fields findByThriftId(int fieldId) {
            switch (fieldId) {
                case 1: {
                    return TYPE;
                }
                case 2: {
                    return PATH_ELEMENT;
                }
                case 4: {
                    return CHILDREN;
                }
                case 5: {
                    return AUTHZ_OBJS;
                }
            }
            return null;
        }

        public static _Fields findByThriftIdOrThrow(int fieldId) {
            _Fields fields = _Fields.findByThriftId(fieldId);
            if (fields == null) {
                throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
            }
            return fields;
        }

        public static _Fields findByName(String name) {
            return byName.get(name);
        }

        private _Fields(short thriftId, String fieldName) {
            this._thriftId = thriftId;
            this._fieldName = fieldName;
        }

        public short getThriftFieldId() {
            return this._thriftId;
        }

        public String getFieldName() {
            return this._fieldName;
        }

        static {
            byName = new HashMap<String, _Fields>();
            for (_Fields field : EnumSet.allOf(_Fields.class)) {
                byName.put(field.getFieldName(), field);
            }
        }
    }
}

