/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.hdfs;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.http.client.utils.URIBuilder;
import org.apache.sentry.hdfs.SentryMalformedPathException;
import org.apache.sentry.hdfs.ThriftSerializer;
import org.apache.sentry.hdfs.Updateable;
import org.apache.sentry.hdfs.service.thrift.TPathChanges;
import org.apache.sentry.hdfs.service.thrift.TPathsUpdate;
import org.apache.thrift.TException;

public class PathsUpdate
implements Updateable.Update {
    public static final String ALL_PATHS = "__ALL_PATHS__";
    private static final Configuration CONF = new Configuration();
    private static String DEFAULT_SCHEME = FileSystem.getDefaultUri((Configuration)CONF).getScheme();
    private static final String SUPPORTED_SCHEME = "hdfs";
    private final TPathsUpdate tPathsUpdate;

    public PathsUpdate() {
        this(0L, false);
    }

    public PathsUpdate(TPathsUpdate tPathsUpdate) {
        this.tPathsUpdate = tPathsUpdate;
    }

    public PathsUpdate(long seqNum, boolean hasFullImage) {
        this(seqNum, -1L, hasFullImage);
    }

    public PathsUpdate(long seqNum, long imgNum, boolean hasFullImage) {
        this.tPathsUpdate = new TPathsUpdate(hasFullImage, seqNum, new ArrayList<TPathChanges>());
        this.tPathsUpdate.setImgNum(imgNum);
    }

    @Override
    public boolean hasFullImage() {
        return this.tPathsUpdate.isHasFullImage();
    }

    public TPathChanges newPathChange(String authzObject) {
        TPathChanges pathChanges = new TPathChanges(authzObject, new ArrayList<List<String>>(), new ArrayList<List<String>>());
        this.tPathsUpdate.addToPathChanges(pathChanges);
        return pathChanges;
    }

    List<TPathChanges> getPathChanges() {
        return this.tPathsUpdate.getPathChanges();
    }

    @Override
    public long getSeqNum() {
        return this.tPathsUpdate.getSeqNum();
    }

    @Override
    public void setSeqNum(long seqNum) {
        this.tPathsUpdate.setSeqNum(seqNum);
    }

    @Override
    public long getImgNum() {
        return this.tPathsUpdate.getImgNum();
    }

    @Override
    public void setImgNum(long imgNum) {
        this.tPathsUpdate.setImgNum(imgNum);
    }

    public TPathsUpdate toThrift() {
        return this.tPathsUpdate;
    }

    @VisibleForTesting
    public static void setDefaultScheme(String scheme) {
        DEFAULT_SCHEME = scheme;
    }

    public static String parsePath(String path) throws SentryMalformedPathException {
        URI uri;
        if (StringUtils.isEmpty((String)path)) {
            return null;
        }
        try {
            uri = new URI(StringUtils.stripStart((String)new URIBuilder().setPath(path).toString(), (String)"/"));
        }
        catch (URISyntaxException e) {
            throw new SentryMalformedPathException("Incomprehensible path [" + path + "]", e);
        }
        String scheme = uri.getScheme();
        if (scheme == null && (scheme = DEFAULT_SCHEME) == null) {
            throw new SentryMalformedPathException("Scheme is missing and could not be constructed from configuration");
        }
        if (!scheme.equalsIgnoreCase(SUPPORTED_SCHEME)) {
            return null;
        }
        String uriPath = uri.getPath();
        if (uriPath == null) {
            throw new SentryMalformedPathException("Path is empty. uri=" + uri);
        }
        if (!uriPath.startsWith("/")) {
            throw new SentryMalformedPathException("Path part of uri does not seem right, was expecting a non empty path: path = " + uriPath + ", uri=" + uri);
        }
        if (uriPath.indexOf("//") >= 0) {
            uriPath = uriPath.replaceAll("//*", "/");
        }
        return StringUtils.strip((String)uriPath, (String)"/");
    }

    @Override
    public byte[] serialize() throws IOException {
        return ThriftSerializer.serialize(this.tPathsUpdate);
    }

    @Override
    public void deserialize(byte[] data) throws IOException {
        ThriftSerializer.deserialize(this.tPathsUpdate, data);
    }

    @Override
    public void JSONDeserialize(String update) throws TException {
        ThriftSerializer.deserializeFromJSON(this.tPathsUpdate, update);
    }

    @Override
    public String JSONSerialize() throws TException {
        return ThriftSerializer.serializeToJSON(this.tPathsUpdate);
    }

    public int hashCode() {
        return this.tPathsUpdate == null ? 0 : this.tPathsUpdate.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PathsUpdate other = (PathsUpdate)obj;
        if (this.tPathsUpdate == null) {
            return other.tPathsUpdate == null;
        }
        return this.tPathsUpdate.equals(other.tPathsUpdate);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.tPathsUpdate + ")";
    }
}

