/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.hdfs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.sentry.hdfs.AuthzPathsDumper;
import org.apache.sentry.hdfs.HMSPaths;
import org.apache.sentry.hdfs.service.thrift.TPathEntry;
import org.apache.sentry.hdfs.service.thrift.TPathsDump;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HMSPathsDumper
implements AuthzPathsDumper<HMSPaths> {
    private final HMSPaths hmsPaths;
    private static final Logger LOG = LoggerFactory.getLogger(HMSPathsDumper.class);

    public HMSPathsDumper(HMSPaths hmsPaths) {
        this.hmsPaths = hmsPaths;
    }

    @Override
    public TPathsDump createPathsDump(boolean minimizeSize) {
        DupDetector dups = null;
        if (minimizeSize) {
            dups = new DupDetector();
            dups.detectDupPathElements(this.hmsPaths.getRootEntry());
        }
        AtomicInteger counter = new AtomicInteger(0);
        HashMap<Integer, TPathEntry> idMap = new HashMap<Integer, TPathEntry>();
        Tuple tRootTuple = this.createTPathEntry(this.hmsPaths.getRootEntry(), counter, idMap, dups);
        idMap.put(tRootTuple.id, tRootTuple.entry);
        this.cloneToTPathEntry(this.hmsPaths.getRootEntry(), tRootTuple.entry, counter, idMap, dups);
        TPathsDump dump = new TPathsDump(tRootTuple.id, idMap);
        String stringDupMsg = "";
        if (minimizeSize) {
            String[] dupStringValues = dups.getDupStringValues();
            dump.setDupStringValues(Arrays.asList(dupStringValues));
            stringDupMsg = String.format(" %d total path strings, %d duplicate strings found, compacted to %d unique strings.", dups.nTotalStrings, dups.nDupStrings, dupStringValues.length);
        }
        LOG.info("Paths Dump created." + stringDupMsg);
        return dump;
    }

    private void cloneToTPathEntry(HMSPaths.Entry parent, TPathEntry tParent, AtomicInteger counter, Map<Integer, TPathEntry> idMap, DupDetector dups) {
        for (HMSPaths.Entry child : parent.childrenValues()) {
            Tuple childTuple = this.createTPathEntry(child, counter, idMap, dups);
            tParent.addToChildren(childTuple.id);
            this.cloneToTPathEntry(child, childTuple.entry, counter, idMap, dups);
        }
    }

    private Tuple createTPathEntry(HMSPaths.Entry entry, AtomicInteger idCounter, Map<Integer, TPathEntry> idMap, DupDetector dups) {
        int myId = idCounter.incrementAndGet();
        ArrayList<Integer> children = entry.hasChildren() ? new ArrayList<Integer>(entry.numChildren()) : Collections.emptyList();
        String pathElement = entry.getPathElement();
        String sameOrReplacementId = dups != null ? dups.getReplacementString(pathElement) : pathElement;
        TPathEntry tEntry = new TPathEntry(entry.getType().getByte(), sameOrReplacementId, children);
        if (!entry.isAuthzObjsEmpty()) {
            tEntry.setAuthzObjs(new ArrayList<String>(entry.getAuthzObjs()));
        }
        idMap.put(myId, tEntry);
        return new Tuple(tEntry, myId);
    }

    @Override
    public HMSPaths initializeFromDump(TPathsDump pathDump) {
        HMSPaths newHmsPaths = new HMSPaths(this.hmsPaths.getPrefixes());
        TPathEntry tRootEntry = pathDump.getNodeMap().get(pathDump.getRootId());
        HMSPaths.Entry rootEntry = newHmsPaths.getRootEntry();
        HashMap<String, Set<HMSPaths.Entry>> authzObjToPath = new HashMap<String, Set<HMSPaths.Entry>>();
        this.cloneToEntry(tRootEntry, rootEntry, pathDump.getNodeMap(), authzObjToPath, pathDump.getDupStringValues(), rootEntry.getType() == HMSPaths.EntryType.PREFIX);
        newHmsPaths.setRootEntry(rootEntry);
        newHmsPaths.setAuthzObjToEntryMapping(authzObjToPath);
        return newHmsPaths;
    }

    private void cloneToEntry(TPathEntry tParent, HMSPaths.Entry parent, Map<Integer, TPathEntry> idMap, Map<String, Set<HMSPaths.Entry>> authzObjToPath, List<String> dupStringValues, boolean hasCrossedPrefix) {
        for (Integer id : tParent.getChildren()) {
            TPathEntry tChild = idMap.get(id);
            String tChildPathElement = tChild.getPathElement();
            if (!tChildPathElement.isEmpty() && tChildPathElement.charAt(0) == ':') {
                int dupStrIdx = Integer.parseInt(tChildPathElement.substring(1), 16);
                tChildPathElement = dupStringValues.get(dupStrIdx);
            }
            HMSPaths.Entry child = null;
            boolean isChildPrefix = hasCrossedPrefix;
            if (!hasCrossedPrefix) {
                child = parent.getChild(tChildPathElement);
                if (child == null) continue;
                boolean bl = isChildPrefix = child.getType() == HMSPaths.EntryType.PREFIX;
                if (isChildPrefix) {
                    child.addAuthzObjs(tChild.getAuthzObjs());
                }
            }
            if (child == null) {
                child = new HMSPaths.Entry(parent, tChildPathElement, HMSPaths.EntryType.fromByte(tChild.getType()), tChild.getAuthzObjs());
            }
            if (!child.isAuthzObjsEmpty()) {
                for (String authzObj : child.getAuthzObjs()) {
                    Set<HMSPaths.Entry> paths = authzObjToPath.get(authzObj);
                    if (paths == null) {
                        paths = new HashSet<HMSPaths.Entry>();
                        authzObjToPath.put(authzObj, paths);
                    }
                    paths.add(child);
                }
            }
            parent.putChild(child.getPathElement(), child);
            this.cloneToEntry(tChild, child, idMap, authzObjToPath, dupStringValues, isChildPrefix);
        }
    }

    private static class DupDetector {
        static final char REPLACEMENT_STRING_PREFIX = ':';
        private static final int TABLE_SIZE = 16384;
        private static final int AVG_ID_LENGTH = 4;
        private static final int MIN_NUM_DUPLICATES = 2;
        private final String[] keys = new String[16384];
        private final int[] values = new int[16384];
        private int auxArraySize;
        int nTotalStrings;
        int nDupStrings;

        private DupDetector() {
        }

        void detectDupPathElements(HMSPaths.Entry root) {
            this.inspectEntry(root);
            for (int i = 0; i < 16384; ++i) {
                if (this.keys[i] == null) continue;
                if (this.values[i] >= 2) {
                    ++this.auxArraySize;
                    this.nDupStrings += this.values[i];
                    continue;
                }
                this.keys[i] = null;
                this.values[i] = -1;
            }
        }

        String getReplacementString(String pathElement) {
            int slot = pathElement.hashCode() & 0x3FFF;
            return pathElement.equals(this.keys[slot]) ? ':' + Integer.toHexString(this.values[slot]) : pathElement;
        }

        String[] getDupStringValues() {
            String[] auxArray = new String[this.auxArraySize];
            int pos = 0;
            for (int i = 0; i < 16384; ++i) {
                if (this.keys[i] == null) continue;
                auxArray[pos++] = this.keys[i];
            }
            return auxArray;
        }

        private void inspectEntry(HMSPaths.Entry entry) {
            ++this.nTotalStrings;
            String pathElement = entry.getPathElement();
            if (pathElement.length() > 4) {
                int slot = pathElement.hashCode() & 0x3FFF;
                if (pathElement.equals(this.keys[slot])) {
                    int n = slot;
                    this.values[n] = this.values[n] + 1;
                } else {
                    this.keys[slot] = pathElement;
                    this.values[slot] = 1;
                }
            }
            for (HMSPaths.Entry child : entry.childrenValues()) {
                this.inspectEntry(child);
            }
        }
    }

    static class Tuple {
        private final TPathEntry entry;
        private final int id;

        Tuple(TPathEntry entry, int id) {
            this.entry = entry;
            this.id = id;
        }
    }
}

