/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.binding.hive;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.BufferedWriter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.sentry.binding.hive.SentryPolicyFileFormatter;
import org.apache.sentry.core.common.exception.SentryConfigurationException;
import org.apache.sentry.core.common.utils.PolicyFiles;
import org.apache.sentry.core.common.utils.SentryConstants;
import org.apache.shiro.config.Ini;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SentryIniPolicyFileFormatter
implements SentryPolicyFileFormatter {
    private static final Logger LOGGER = LoggerFactory.getLogger(SentryIniPolicyFileFormatter.class);
    private static final String NL = System.getProperty("line.separator", "\n");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(String resourcePath, Configuration conf, Map<String, Map<String, Set<String>>> sentryMappingData) throws Exception {
        FileSystem fileSystem;
        Path path = new Path(resourcePath);
        if (Strings.isNullOrEmpty((String)path.toUri().getScheme())) {
            String defaultFs = conf.get("sentry.export.import.default.fs", "file:///");
            path = new Path(defaultFs + resourcePath);
        }
        if ((fileSystem = path.getFileSystem(conf)).exists(path)) {
            fileSystem.delete(path, true);
        }
        String contents = Joiner.on((String)NL).join((Object)this.generateSection("userroles", sentryMappingData.get("userroles")), (Object)this.generateSection("groups", sentryMappingData.get("groups")), new Object[]{this.generateSection("roles", sentryMappingData.get("roles")), ""});
        LOGGER.info("Writing policy information to file located at" + path);
        FSDataOutputStream os = fileSystem.create(path);
        BufferedWriter br = new BufferedWriter(new OutputStreamWriter((OutputStream)os, "UTF-8"));
        try {
            br.write(contents);
        }
        catch (Exception exception) {
            LOGGER.error("Failed to export policy information to file, located at " + path);
        }
        finally {
            br.close();
            fileSystem.close();
        }
    }

    @Override
    public Map<String, Map<String, Set<String>>> parse(String resourcePath, Configuration conf) {
        Ini ini;
        HashMap resultMap = Maps.newHashMap();
        Path path = new Path(resourcePath);
        try {
            ini = PolicyFiles.loadFromPath((FileSystem)path.getFileSystem(conf), (Path)path);
        }
        catch (Exception e) {
            throw new SentryConfigurationException("Error loading policy file " + resourcePath, (Throwable)e);
        }
        Map<String, Set<String>> userRolesMap = this.parseSection(ini, "userroles");
        Map<String, Set<String>> groupRolesMap = this.parseSection(ini, "groups");
        Map<String, Set<String>> rolePrivilegesMap = this.parseSection(ini, "roles");
        resultMap.put("userroles", userRolesMap);
        resultMap.put("groups", groupRolesMap);
        resultMap.put("roles", rolePrivilegesMap);
        return resultMap;
    }

    private Map<String, Set<String>> parseSection(Ini ini, String sctionName) {
        HashMap resultMap = Maps.newHashMap();
        Ini.Section sction = ini.getSection(sctionName);
        if (sction == null) {
            return resultMap;
        }
        for (String key : sction.keySet()) {
            String value = sction.get((Object)key);
            HashSet roles = Sets.newHashSet();
            for (String role : value.split(",")) {
                if (!StringUtils.isNotEmpty((String)role)) continue;
                roles.add(role);
            }
            resultMap.put(key, roles);
        }
        return resultMap;
    }

    private String generateSection(String name, Map<String, Set<String>> mappingData) {
        if (mappingData == null || mappingData.isEmpty()) {
            return "";
        }
        ArrayList lines = Lists.newArrayList();
        lines.add("[" + name + "]");
        for (Map.Entry<String, Set<String>> entry : mappingData.entrySet()) {
            lines.add(SentryConstants.KV_JOINER.join((Object)entry.getKey(), (Object)SentryConstants.ROLE_JOINER.join((Iterable)entry.getValue()), new Object[0]));
        }
        return Joiner.on((String)NL).join((Iterable)lines);
    }
}

