/*
 * Decompiled with CFR 0.152.
 */
package sentry.org.apache.curator.x.discovery.details;

import com.google.common.collect.Maps;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import sentry.org.apache.curator.x.discovery.DownInstancePolicy;
import sentry.org.apache.curator.x.discovery.InstanceFilter;
import sentry.org.apache.curator.x.discovery.ServiceInstance;

class DownInstanceManager<T>
implements InstanceFilter<T> {
    private final ConcurrentMap<ServiceInstance<?>, Status> statuses = Maps.newConcurrentMap();
    private final DownInstancePolicy downInstancePolicy;
    private final AtomicLong lastPurge = new AtomicLong(System.currentTimeMillis());

    DownInstanceManager(DownInstancePolicy downInstancePolicy) {
        this.downInstancePolicy = downInstancePolicy;
    }

    void add(ServiceInstance<?> instance) {
        this.purge();
        Status newStatus = new Status();
        Status oldStatus = this.statuses.putIfAbsent(instance, newStatus);
        Status useStatus = oldStatus != null ? oldStatus : newStatus;
        useStatus.errorCount.incrementAndGet();
    }

    public boolean apply(ServiceInstance<T> instance) {
        this.purge();
        Status status = (Status)this.statuses.get(instance);
        return status == null || status.errorCount.get() < this.downInstancePolicy.getErrorThreshold();
    }

    private void purge() {
        long localLastPurge = this.lastPurge.get();
        long ticksSinceLastPurge = System.currentTimeMillis() - localLastPurge;
        if (ticksSinceLastPurge < this.downInstancePolicy.getTimeoutMs() / 2L) {
            return;
        }
        if (!this.lastPurge.compareAndSet(localLastPurge, System.currentTimeMillis())) {
            return;
        }
        Iterator it = this.statuses.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            long elapsedMs = System.currentTimeMillis() - ((Status)entry.getValue()).startMs;
            if (elapsedMs < this.downInstancePolicy.getTimeoutMs()) continue;
            it.remove();
        }
    }

    private static class Status {
        private final long startMs = System.currentTimeMillis();
        private final AtomicInteger errorCount = new AtomicInteger(0);

        private Status() {
        }
    }
}

