/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.service.thrift;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.security.PrivilegedExceptionAction;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.SaslRpcServer;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.sentry.service.thrift.HMSClient;
import org.apache.sentry.service.thrift.HiveConnectionFactory;
import org.apache.sentry.service.thrift.SentryKerberosContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HiveSimpleConnectionFactory
implements HiveConnectionFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(HiveSimpleConnectionFactory.class);
    private final Configuration conf;
    private final HiveConf hiveConf;
    private final boolean insecure;
    private SentryKerberosContext kerberosContext = null;

    public HiveSimpleConnectionFactory(Configuration sentryConf, HiveConf hiveConf) {
        this.conf = sentryConf;
        this.hiveConf = hiveConf;
        this.insecure = !"kerberos".equalsIgnoreCase(sentryConf.get("sentry.service.security.mode", "none").trim());
    }

    public void init() throws IOException, LoginException {
        if (this.insecure) {
            LOGGER.info("Using insecure connection to HMS");
            return;
        }
        LOGGER.info("Using secured connection to HMS");
        int port = this.conf.getInt("sentry.service.server.rpc-port", 8038);
        String rawPrincipal = (String)Preconditions.checkNotNull((Object)this.conf.get("sentry.service.server.principal"), (String)"%s is required", (Object[])new Object[]{"sentry.service.server.principal"});
        String principal = SecurityUtil.getServerPrincipal((String)rawPrincipal, (InetAddress)NetUtils.createSocketAddr((String)this.conf.get("sentry.service.server.rpc-address", "0.0.0.0"), (int)port).getAddress());
        LOGGER.debug("Opening kerberos connection to HMS using kerberos principal {}", (Object)principal);
        String[] principalParts = SaslRpcServer.splitKerberosName((String)principal);
        Preconditions.checkArgument((principalParts.length == 3 ? 1 : 0) != 0, (String)"Kerberos principal %s should have 3 parts", (Object[])new Object[]{principal});
        String keytab = (String)Preconditions.checkNotNull((Object)this.conf.get("sentry.service.server.keytab"), (String)"Configuration is missing required %s paraeter", (Object[])new Object[]{"sentry.service.server.keytab"});
        File keytabFile = new File(keytab);
        Preconditions.checkState((keytabFile.isFile() && keytabFile.canRead() ? 1 : 0) != 0, (String)"Keytab %s does not exist or is not readable", (Object[])new Object[]{keytab});
        this.kerberosContext = new SentryKerberosContext(principal, keytab, false);
        UserGroupInformation.setConfiguration((Configuration)this.conf);
        LOGGER.info("Using secure connection to HMS");
    }

    @Override
    public HMSClient connect() throws IOException, InterruptedException, MetaException {
        UserGroupInformation clientUGI = this.insecure ? UserGroupInformation.getCurrentUser() : UserGroupInformation.getUGIFromSubject((Subject)this.kerberosContext.getSubject());
        return new HMSClient((HiveMetaStoreClient)clientUGI.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<HiveMetaStoreClient>(){

            @Override
            public HiveMetaStoreClient run() throws MetaException {
                return new HiveMetaStoreClient(HiveSimpleConnectionFactory.this.hiveConf);
            }
        }));
    }

    @Override
    public void close() throws Exception {
        if (this.kerberosContext != null) {
            this.kerberosContext.shutDown();
            this.kerberosContext = null;
        }
    }
}

