/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.service.thrift;

import java.util.Arrays;
import java.util.List;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.AuthorizeCallback;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.SaslRpcServer;
import org.apache.hadoop.security.authentication.util.KerberosName;
import org.apache.sentry.core.common.exception.ConnectionDeniedException;
import org.slf4j.LoggerFactory;

public class GSSCallback
extends SaslRpcServer.SaslGssCallbackHandler {
    private final Configuration conf;

    public GSSCallback(Configuration conf) {
        this.conf = conf;
    }

    boolean comparePrincipals(String principal1, String principal2) {
        String[] principalParts1 = SaslRpcServer.splitKerberosName((String)principal1);
        String[] principalParts2 = SaslRpcServer.splitKerberosName((String)principal2);
        if (principalParts1.length == 0 || principalParts2.length == 0) {
            return false;
        }
        if (principalParts1.length == principalParts2.length) {
            for (int i = 0; i < principalParts1.length; ++i) {
                if (principalParts1[i].equals(principalParts2[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    boolean allowConnect(String principal) {
        String principalShortName;
        String allowedPrincipals = this.conf.get("sentry.service.allow.connect");
        if (allowedPrincipals == null) {
            return false;
        }
        if (KerberosName.hasRulesBeenSet()) {
            try {
                KerberosName krbName = new KerberosName(principal);
                principalShortName = krbName.getShortName();
                if (principalShortName.equals(principal)) {
                    principalShortName = this.getShortName(principal);
                }
            }
            catch (KerberosName.NoMatchingRule e) {
                LoggerFactory.getLogger(GSSCallback.class).debug("No matching rule found for principal " + principal, (Throwable)e);
                principalShortName = this.getShortName(principal);
            }
            catch (Exception e) {
                LoggerFactory.getLogger(GSSCallback.class).debug("Cannot derive short name from KerberosName. Use principal name prefix to authenticate", (Throwable)e);
                principalShortName = this.getShortName(principal);
            }
        } else {
            principalShortName = this.getShortName(principal);
        }
        List<String> items = Arrays.asList(allowedPrincipals.split("\\s*,\\s*"));
        for (String item : items) {
            if (!this.comparePrincipals(item, principalShortName)) continue;
            return true;
        }
        return false;
    }

    private String getShortName(String principal) {
        String[] parts = SaslRpcServer.splitKerberosName((String)principal);
        return parts[0];
    }

    public void handle(Callback[] callbacks) throws UnsupportedCallbackException, ConnectionDeniedException {
        AuthorizeCallback ac = null;
        for (Callback callback : callbacks) {
            if (!(callback instanceof AuthorizeCallback)) {
                throw new UnsupportedCallbackException(callback, "Unrecognized SASL GSSAPI Callback");
            }
            ac = (AuthorizeCallback)callback;
        }
        if (ac != null) {
            String authid = ac.getAuthenticationID();
            String authzid = ac.getAuthorizationID();
            if (this.allowConnect(authid)) {
                if (authid.equals(authzid)) {
                    ac.setAuthorized(true);
                } else {
                    ac.setAuthorized(false);
                }
                if (ac.isAuthorized()) {
                    ac.setAuthorizedID(authzid);
                }
            } else {
                throw new ConnectionDeniedException((Callback)ac, "Connection to sentry service denied due to lack of client credentials", authid);
            }
        }
    }
}

