/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.service.thrift;

import com.google.common.base.Preconditions;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

public class DynamicProxy<T>
implements InvocationHandler {
    private final Object obj;
    private final Class<T> iface;

    public DynamicProxy(Object obj, Class<T> iface, String objectClassName) {
        this.obj = Preconditions.checkNotNull((Object)obj);
        this.iface = (Class)Preconditions.checkNotNull(iface);
        this.validateObjectImplementsInterface(objectClassName);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Method proxiedMethod = this.findMethodBySignature(method);
        return proxiedMethod.invoke(this.obj, args);
    }

    private Method findMethodBySignature(Method method) throws NoSuchMethodException {
        return this.obj.getClass().getMethod(method.getName(), method.getParameterTypes());
    }

    private void validateObjectImplementsInterface(String className) {
        for (Method method : this.iface.getMethods()) {
            try {
                this.findMethodBySignature(method);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(String.format("Class %s does not implement %s.", className, this.iface.getName()));
            }
        }
    }

    public T createProxy() {
        return (T)Proxy.newProxyInstance(this.iface.getClassLoader(), new Class[]{this.iface}, (InvocationHandler)this);
    }
}

