/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.provider.db.service.persistent;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SentryUpgradeOrder {
    private static final Logger LOGGER = LoggerFactory.getLogger(SentryUpgradeOrder.class);

    public static Map<String, List<String>> readUpgradeGraph(Reader reader) throws IOException {
        HashMap<String, List<String>> upgradeSchemaVersions = new HashMap<String, List<String>>();
        try (BufferedReader bfReader = new BufferedReader(reader);){
            String schemaVersion;
            while ((schemaVersion = bfReader.readLine()) != null) {
                String[] versions = schemaVersion.toLowerCase().split("-to-");
                if (versions.length != 2) {
                    LOGGER.warn("Ignoring unknown Sentry schema upgrade path: " + schemaVersion);
                    continue;
                }
                String source = versions[0].trim();
                String target = versions[1].trim();
                if (source.isEmpty() || source.startsWith("#") || source.equals(target)) continue;
                List toVersions = upgradeSchemaVersions.getOrDefault(source, new LinkedList());
                toVersions.add(target);
                upgradeSchemaVersions.put(source, toVersions);
            }
        }
        return upgradeSchemaVersions;
    }

    public static List<String> getUpgradePath(Map<String, List<String>> upgrades, String from, String to) {
        LinkedList<String> upgradeListPath = new LinkedList<String>();
        Stack<String> upgradePaths = new Stack<String>();
        HashSet<String> visited = new HashSet<String>();
        SentryUpgradeOrder.searchPath(upgrades, from, to, upgradePaths, visited);
        while (!upgradePaths.isEmpty()) {
            upgradeListPath.add(upgradePaths.pop());
        }
        return upgradeListPath;
    }

    private static boolean searchPath(Map<String, List<String>> graph, String from, String to, Stack<String> upgradePath, Set<String> visited) {
        if (from.equals(to)) {
            return true;
        }
        if (!graph.containsKey(from)) {
            return false;
        }
        boolean found = false;
        for (String toVersion : graph.get(from)) {
            String nextPath = SentryUpgradeOrder.generateUpgradeVersionString(from, toVersion);
            boolean isVisited = visited.contains(nextPath);
            if (isVisited) continue;
            visited.add(nextPath);
            found = SentryUpgradeOrder.searchPath(graph, toVersion, to, upgradePath, visited);
            if (found) {
                upgradePath.push(nextPath);
                break;
            }
            visited.remove(nextPath);
        }
        return found;
    }

    private static String generateUpgradeVersionString(String from, String to) {
        StringBuilder sb = new StringBuilder();
        sb.append(from).append("-to-").append(to);
        return sb.toString();
    }
}

